/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.network;

import com.crabmods.instantworldmirror.item.DimensionMirrorItem;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record TeleportToSpawnPacket() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TeleportToSpawnPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"teleport_to_spawn"));
    public static final StreamCodec<FriendlyByteBuf, TeleportToSpawnPacket> STREAM_CODEC = StreamCodec.unit((Object)new TeleportToSpawnPacket());

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handle(TeleportToSpawnPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt0$temp;
                if (serverPlayer.isCreative()) {
                    DimensionMirrorItem.clearCooldown(serverPlayer.getUUID());
                    DimensionMirrorItem.syncCooldownToClient(serverPlayer);
                } else {
                    long remainingMillis = DimensionMirrorItem.getRemainingCooldownMillis(serverPlayer.getUUID());
                    if (remainingMillis > 0L) {
                        int seconds = (int)(remainingMillis / 1000L);
                        serverPlayer.displayClientMessage((Component)Component.translatable((String)"message.instantworldmirror.cooldown", (Object[])new Object[]{seconds}), true);
                        return;
                    }
                }
                MirrorWorldManager.teleportToMirrorSpawn(serverPlayer);
            }
        });
    }
}

