/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.saveddata.SavedData;

public class CleanupQueueData
extends SavedData {
    private static final String DATA_NAME = "instantworldmirror_cleanup_queue";
    private final Queue<CleanupTask> pendingTasks = new ConcurrentLinkedQueue<CleanupTask>();

    public static CleanupQueueData load(CompoundTag tag, HolderLookup.Provider provider) {
        CleanupQueueData data = new CleanupQueueData();
        if (tag.contains("tasks")) {
            ListTag taskList = tag.getList("tasks", 10);
            for (int i = 0; i < taskList.size(); ++i) {
                CompoundTag taskTag = taskList.getCompound(i);
                data.pendingTasks.add(CleanupTask.load(taskTag));
            }
            InstantWorldMirror.LOGGER.info("Loaded {} pending cleanup tasks from saved data", (Object)data.pendingTasks.size());
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag taskList = new ListTag();
        for (CleanupTask task : this.pendingTasks) {
            taskList.add((Object)task.save());
        }
        tag.put("tasks", (Tag)taskList);
        if (!this.pendingTasks.isEmpty()) {
            InstantWorldMirror.LOGGER.info("Saved {} pending cleanup tasks to world data", (Object)this.pendingTasks.size());
        }
        return tag;
    }

    public void addTask(CleanupTask task) {
        this.pendingTasks.add(task);
        this.setDirty();
    }

    public CleanupTask getCurrentTask() {
        return this.pendingTasks.peek();
    }

    public void completeCurrentTask() {
        this.pendingTasks.poll();
        this.setDirty();
    }

    public void markProgress() {
        this.setDirty();
    }

    public CleanupTask peekTask() {
        return this.pendingTasks.peek();
    }

    public boolean hasTasks() {
        return !this.pendingTasks.isEmpty();
    }

    public int getTaskCount() {
        return this.pendingTasks.size();
    }

    public void clearTasks() {
        this.pendingTasks.clear();
        this.setDirty();
    }

    public static CleanupQueueData get(ServerLevel level) {
        return (CleanupQueueData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(CleanupQueueData::new, CleanupQueueData::load), DATA_NAME);
    }

    public static class CleanupTask {
        private final BlockPos centerPos;
        private final int chunkRadius;
        private int currentChunkX;
        private int currentChunkZ;
        private final int minChunkX;
        private final int maxChunkX;
        private final int minChunkZ;
        private final int maxChunkZ;
        private boolean started = false;
        private boolean completed = false;

        public CleanupTask(BlockPos centerPos, int chunkRadius) {
            this.centerPos = centerPos;
            this.chunkRadius = chunkRadius;
            int centerChunkX = centerPos.getX() >> 4;
            int centerChunkZ = centerPos.getZ() >> 4;
            this.minChunkX = centerChunkX - chunkRadius;
            this.maxChunkX = centerChunkX + chunkRadius;
            this.minChunkZ = centerChunkZ - chunkRadius;
            this.maxChunkZ = centerChunkZ + chunkRadius;
            this.currentChunkX = this.minChunkX;
            this.currentChunkZ = this.minChunkZ;
        }

        public BlockPos centerPos() {
            return this.centerPos;
        }

        public int chunkRadius() {
            return this.chunkRadius;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public int getTotalChunks() {
            int width = this.maxChunkX - this.minChunkX + 1;
            int height = this.maxChunkZ - this.minChunkZ + 1;
            return width * height;
        }

        public int getCleanedChunks() {
            if (!this.started) {
                return 0;
            }
            if (this.completed) {
                return this.getTotalChunks();
            }
            int width = this.maxChunkX - this.minChunkX + 1;
            int rowsCleaned = this.currentChunkZ - this.minChunkZ;
            int colsCleaned = this.currentChunkX - this.minChunkX;
            return rowsCleaned * width + colsCleaned;
        }

        public int[] getNextChunk() {
            int[] result;
            if (this.completed) {
                return null;
            }
            this.started = true;
            int[] nArray = result = new int[]{this.currentChunkX++, this.currentChunkZ++};
            if (this.currentChunkX > this.maxChunkX) {
                this.currentChunkX = this.minChunkX;
                if (this.currentChunkZ > this.maxChunkZ) {
                    this.completed = true;
                }
            }
            return result;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putInt("x", this.centerPos.getX());
            tag.putInt("y", this.centerPos.getY());
            tag.putInt("z", this.centerPos.getZ());
            tag.putInt("radius", this.chunkRadius);
            tag.putInt("currentX", this.currentChunkX);
            tag.putInt("currentZ", this.currentChunkZ);
            tag.putBoolean("started", this.started);
            tag.putBoolean("completed", this.completed);
            return tag;
        }

        public static CleanupTask load(CompoundTag tag) {
            BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            int radius = tag.getInt("radius");
            CleanupTask task = new CleanupTask(pos, radius);
            task.currentChunkX = tag.getInt("currentX");
            task.currentChunkZ = tag.getInt("currentZ");
            task.started = tag.getBoolean("started");
            task.completed = tag.getBoolean("completed");
            return task;
        }
    }
}

