/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class CopyQueueData
extends SavedData {
    private static final String DATA_NAME = "instantworldmirror_copy_queue";
    private final Queue<CopyTask> pendingTasks = new ConcurrentLinkedQueue<CopyTask>();

    public static CopyQueueData load(CompoundTag tag, HolderLookup.Provider provider) {
        CopyQueueData data = new CopyQueueData();
        if (tag.contains("tasks")) {
            ListTag taskList = tag.getList("tasks", 10);
            for (int i = 0; i < taskList.size(); ++i) {
                CompoundTag taskTag = taskList.getCompound(i);
                data.pendingTasks.add(CopyTask.load(taskTag));
            }
            InstantWorldMirror.LOGGER.info("Loaded {} pending copy tasks from saved data", (Object)data.pendingTasks.size());
        }
        return data;
    }

    public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag taskList = new ListTag();
        for (CopyTask task : this.pendingTasks) {
            taskList.add((Object)task.save());
        }
        tag.put("tasks", (Tag)taskList);
        if (!this.pendingTasks.isEmpty()) {
            InstantWorldMirror.LOGGER.info("Saved {} pending copy tasks to world data", (Object)this.pendingTasks.size());
        }
        return tag;
    }

    public void addTask(CopyTask task) {
        this.pendingTasks.add(task);
        this.setDirty();
    }

    public CopyTask getCurrentTask() {
        return this.pendingTasks.peek();
    }

    public CopyTask getTaskBySession(UUID sessionId) {
        for (CopyTask task : this.pendingTasks) {
            if (!task.sessionId().equals(sessionId)) continue;
            return task;
        }
        return null;
    }

    public void completeCurrentTask() {
        this.pendingTasks.poll();
        this.setDirty();
    }

    public void markProgress() {
        this.setDirty();
    }

    public boolean hasTasks() {
        return !this.pendingTasks.isEmpty();
    }

    public int getTaskCount() {
        return this.pendingTasks.size();
    }

    public static CopyQueueData get(ServerLevel level) {
        return (CopyQueueData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(CopyQueueData::new, CopyQueueData::load), DATA_NAME);
    }

    public static class CopyTask {
        private final UUID sessionId;
        private final BlockPos centerPos;
        private final int chunkRadius;
        private final String sourceDimension;
        private int currentChunkX;
        private int currentChunkZ;
        private final int minChunkX;
        private final int maxChunkX;
        private final int minChunkZ;
        private final int maxChunkZ;
        private boolean started = false;
        private boolean completed = false;
        private int totalBlocksCopied = 0;

        public CopyTask(UUID sessionId, BlockPos centerPos, int chunkRadius, ResourceKey<Level> sourceDimension) {
            this.sessionId = sessionId;
            this.centerPos = centerPos;
            this.chunkRadius = chunkRadius;
            this.sourceDimension = sourceDimension.location().toString();
            int centerChunkX = centerPos.getX() >> 4;
            int centerChunkZ = centerPos.getZ() >> 4;
            this.minChunkX = centerChunkX - chunkRadius;
            this.maxChunkX = centerChunkX + chunkRadius;
            this.minChunkZ = centerChunkZ - chunkRadius;
            this.maxChunkZ = centerChunkZ + chunkRadius;
            this.currentChunkX = this.minChunkX;
            this.currentChunkZ = this.minChunkZ;
        }

        public UUID sessionId() {
            return this.sessionId;
        }

        public BlockPos centerPos() {
            return this.centerPos;
        }

        public int chunkRadius() {
            return this.chunkRadius;
        }

        public String sourceDimension() {
            return this.sourceDimension;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public int getTotalBlocksCopied() {
            return this.totalBlocksCopied;
        }

        public void addBlocksCopied(int count) {
            this.totalBlocksCopied += count;
        }

        public int getTotalChunks() {
            int width = this.maxChunkX - this.minChunkX + 1;
            int height = this.maxChunkZ - this.minChunkZ + 1;
            return width * height;
        }

        public int getCopiedChunks() {
            if (!this.started) {
                return 0;
            }
            if (this.completed) {
                return this.getTotalChunks();
            }
            int width = this.maxChunkX - this.minChunkX + 1;
            int rowsCopied = this.currentChunkZ - this.minChunkZ;
            int colsCopied = this.currentChunkX - this.minChunkX;
            return rowsCopied * width + colsCopied;
        }

        public int getProgressPercent() {
            int total = this.getTotalChunks();
            if (total == 0) {
                return 100;
            }
            return this.getCopiedChunks() * 100 / total;
        }

        public int[] getNextChunk() {
            int[] result;
            if (this.completed) {
                return null;
            }
            this.started = true;
            int[] nArray = result = new int[]{this.currentChunkX++, this.currentChunkZ++};
            if (this.currentChunkX > this.maxChunkX) {
                this.currentChunkX = this.minChunkX;
                if (this.currentChunkZ > this.maxChunkZ) {
                    this.completed = true;
                }
            }
            return result;
        }

        public CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.putUUID("sessionId", this.sessionId);
            tag.putInt("x", this.centerPos.getX());
            tag.putInt("y", this.centerPos.getY());
            tag.putInt("z", this.centerPos.getZ());
            tag.putInt("radius", this.chunkRadius);
            tag.putString("sourceDim", this.sourceDimension);
            tag.putInt("currentX", this.currentChunkX);
            tag.putInt("currentZ", this.currentChunkZ);
            tag.putBoolean("started", this.started);
            tag.putBoolean("completed", this.completed);
            tag.putInt("blocksCopied", this.totalBlocksCopied);
            return tag;
        }

        public static CopyTask load(CompoundTag tag) {
            UUID sessionId = tag.getUUID("sessionId");
            BlockPos pos = new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
            int radius = tag.getInt("radius");
            String dimStr = tag.getString("sourceDim");
            ResourceKey dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dimStr));
            CopyTask task = new CopyTask(sessionId, pos, radius, (ResourceKey<Level>)dim);
            task.currentChunkX = tag.getInt("currentX");
            task.currentChunkZ = tag.getInt("currentZ");
            task.started = tag.getBoolean("started");
            task.completed = tag.getBoolean("completed");
            task.totalBlocksCopied = tag.getInt("blocksCopied");
            return task;
        }
    }
}

