/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.world.ModDimensions;
import com.crabmods.instantworldmirror.world.WorldCopyService;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class DimensionPool {
    private static final Map<Integer, DimensionState> dimensionStates = new ConcurrentHashMap<Integer, DimensionState>();
    private static final Map<Integer, UUID> dimensionToSession = new ConcurrentHashMap<Integer, UUID>();
    private static final Map<UUID, Integer> sessionToDimension = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<Integer, ResourceKey<Level>> dimensionToSource = new ConcurrentHashMap<Integer, ResourceKey<Level>>();
    private static boolean initialized = false;
    private static MinecraftServer serverRef = null;

    public static synchronized void initialize() {
        if (!initialized) {
            int poolSize = ModDimensions.getPoolSize();
            for (int i = 0; i < poolSize; ++i) {
                dimensionStates.put(i, DimensionState.AVAILABLE);
            }
            initialized = true;
            InstantWorldMirror.LOGGER.debug("Dimension pool initialized with {} dimensions", (Object)poolSize);
        }
    }

    public static synchronized void initializeWithServer(MinecraftServer server) {
        serverRef = server;
        DimensionPool.initialize();
        ServerLevel overworld = server.overworld();
        DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
        int poolSize = ModDimensions.getPoolSize();
        for (int i = 0; i < poolSize; ++i) {
            if (!data.isMarkedForCleanup(i)) continue;
            dimensionStates.put(i, DimensionState.CLEANING);
            InstantWorldMirror.LOGGER.debug("Restored dimension {} to CLEANING state", (Object)i);
            ServerLevel mirrorWorld = server.getLevel(ModDimensions.getMirrorWorld(i));
            if (mirrorWorld == null) continue;
            WorldCopyService.cleanupMirrorWorld(mirrorWorld, i);
            InstantWorldMirror.LOGGER.debug("Re-queued cleanup task for dimension {}", (Object)i);
        }
    }

    public static synchronized int allocateDimension(UUID sessionId, ResourceKey<Level> sourceDimension) {
        int poolSize = ModDimensions.getPoolSize();
        for (int i = 0; i < poolSize; ++i) {
            if (dimensionStates.get(i) != DimensionState.AVAILABLE) continue;
            dimensionStates.put(i, DimensionState.IN_USE);
            dimensionToSession.put(i, sessionId);
            sessionToDimension.put(sessionId, i);
            dimensionToSource.put(i, sourceDimension);
            InstantWorldMirror.LOGGER.info("Allocated dimension {} for session {} (source: {})", new Object[]{i, sessionId, sourceDimension.location()});
            return i;
        }
        InstantWorldMirror.LOGGER.warn("No available dimensions for session {} (pool size: {})", (Object)sessionId, (Object)poolSize);
        return -1;
    }

    public static synchronized int allocateDimension(UUID sessionId) {
        return DimensionPool.allocateDimension(sessionId, (ResourceKey<Level>)Level.OVERWORLD);
    }

    public static synchronized void releaseDimension(UUID sessionId) {
        Integer dimIndex = sessionToDimension.remove(sessionId);
        if (dimIndex != null) {
            dimensionToSession.remove(dimIndex);
            dimensionToSource.remove(dimIndex);
            dimensionStates.put(dimIndex, DimensionState.CLEANING);
            DimensionPool.markCleanupInProgress(dimIndex, true);
            InstantWorldMirror.LOGGER.debug("Released dimension {} from session {}", (Object)dimIndex, (Object)sessionId);
        }
    }

    public static ResourceKey<Level> getSourceDimension(int dimIndex) {
        return dimensionToSource.getOrDefault(dimIndex, (ResourceKey<Level>)Level.OVERWORLD);
    }

    public static synchronized void updateDimensionSession(int dimIndex, UUID oldSessionId, UUID newSessionId) {
        if (dimensionToSession.get(dimIndex) != null && dimensionToSession.get(dimIndex).equals(oldSessionId)) {
            sessionToDimension.remove(oldSessionId);
            dimensionToSession.put(dimIndex, newSessionId);
            sessionToDimension.put(newSessionId, dimIndex);
            InstantWorldMirror.LOGGER.debug("Updated dimension {} session from {} to {}", new Object[]{dimIndex, oldSessionId, newSessionId});
        }
    }

    public static synchronized void markDimensionAvailable(int dimIndex) {
        int poolSize = ModDimensions.getPoolSize();
        if (dimIndex >= 0 && dimIndex < poolSize) {
            dimensionStates.put(dimIndex, DimensionState.AVAILABLE);
            DimensionPool.markCleanupInProgress(dimIndex, false);
            InstantWorldMirror.LOGGER.debug("Dimension {} now available", (Object)dimIndex);
        }
    }

    public static Optional<ResourceKey<Level>> getSessionDimension(UUID sessionId) {
        Integer dimIndex = sessionToDimension.get(sessionId);
        if (dimIndex != null) {
            return Optional.of(ModDimensions.getMirrorWorld(dimIndex));
        }
        return Optional.empty();
    }

    public static int getSessionDimensionIndex(UUID sessionId) {
        return sessionToDimension.getOrDefault(sessionId, -1);
    }

    public static Optional<UUID> getDimensionSession(int dimIndex) {
        return Optional.ofNullable(dimensionToSession.get(dimIndex));
    }

    public static UUID getSessionForDimension(int dimIndex) {
        return dimensionToSession.get(dimIndex);
    }

    public static synchronized void forceReleaseDimension(int dimIndex) {
        int poolSize = ModDimensions.getPoolSize();
        if (dimIndex >= 0 && dimIndex < poolSize) {
            UUID sessionId = dimensionToSession.remove(dimIndex);
            if (sessionId != null) {
                sessionToDimension.remove(sessionId);
            }
            dimensionToSource.remove(dimIndex);
            dimensionStates.put(dimIndex, DimensionState.CLEANING);
            DimensionPool.markCleanupInProgress(dimIndex, true);
            InstantWorldMirror.LOGGER.debug("Force released orphaned dimension {}", (Object)dimIndex);
        }
    }

    public static DimensionState getDimensionState(int dimIndex) {
        return dimensionStates.getOrDefault(dimIndex, DimensionState.AVAILABLE);
    }

    public static synchronized void markDimensionCleaning(int dimIndex) {
        int poolSize = ModDimensions.getPoolSize();
        if (dimIndex >= 0 && dimIndex < poolSize) {
            dimensionStates.put(dimIndex, DimensionState.CLEANING);
            dimensionToSession.remove(dimIndex);
            DimensionPool.markCleanupInProgress(dimIndex, true);
            InstantWorldMirror.LOGGER.debug("Dimension {} force marked as CLEANING", (Object)dimIndex);
        }
    }

    public static boolean hasAvailableDimension() {
        return dimensionStates.containsValue((Object)DimensionState.AVAILABLE);
    }

    public static int getAvailableCount() {
        return (int)dimensionStates.values().stream().filter(state -> state == DimensionState.AVAILABLE).count();
    }

    public static int getInUseCount() {
        return (int)dimensionStates.values().stream().filter(state -> state == DimensionState.IN_USE).count();
    }

    public static int getCleaningCount() {
        return (int)dimensionStates.values().stream().filter(state -> state == DimensionState.CLEANING).count();
    }

    public static ServerLevel getDimensionLevel(MinecraftServer server, int dimIndex) {
        int poolSize = ModDimensions.getPoolSize();
        if (dimIndex < 0 || dimIndex >= poolSize) {
            return null;
        }
        return server.getLevel(ModDimensions.getMirrorWorld(dimIndex));
    }

    public static synchronized void clearAll() {
        dimensionToSession.clear();
        sessionToDimension.clear();
        serverRef = null;
        initialized = false;
        InstantWorldMirror.LOGGER.debug("Dimension pool cleared");
    }

    private static void markCleanupInProgress(int dimIndex, boolean cleaning) {
        if (serverRef != null) {
            ServerLevel overworld = serverRef.overworld();
            DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
            data.setCleanupState(dimIndex, cleaning);
        }
    }

    public static void saveCleanupData(int dimIndex, BlockPos copyCenter, Set<Long> modifiedChunks, int cleanupProgress) {
        if (serverRef != null) {
            ServerLevel overworld = serverRef.overworld();
            DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
            data.setCopyCenter(dimIndex, copyCenter);
            data.setModifiedChunks(dimIndex, modifiedChunks);
            data.setCleanupProgress(dimIndex, cleanupProgress);
        }
    }

    public static BlockPos getSavedCopyCenter(int dimIndex) {
        if (serverRef != null) {
            ServerLevel overworld = serverRef.overworld();
            DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
            return data.getCopyCenter(dimIndex);
        }
        return null;
    }

    public static Set<Long> getSavedModifiedChunks(int dimIndex) {
        if (serverRef != null) {
            ServerLevel overworld = serverRef.overworld();
            DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
            return data.getModifiedChunks(dimIndex);
        }
        return Collections.emptySet();
    }

    public static int getSavedCleanupProgress(int dimIndex) {
        if (serverRef != null) {
            ServerLevel overworld = serverRef.overworld();
            DimensionPoolData data = (DimensionPoolData)overworld.getDataStorage().computeIfAbsent(DimensionPoolData.factory(), "instantworldmirror_dimension_pool");
            return data.getCleanupProgress(dimIndex);
        }
        return 0;
    }

    public static String getDebugInfo() {
        int poolSize = ModDimensions.getPoolSize();
        StringBuilder sb = new StringBuilder("DimensionPool Status (pool size: " + poolSize + "):\n");
        for (int i = 0; i < poolSize; ++i) {
            DimensionState state = dimensionStates.get(i);
            UUID session = dimensionToSession.get(i);
            sb.append(String.format("  [%d] %s", new Object[]{i, state}));
            if (session != null) {
                sb.append(" (session: ").append(session.toString().substring(0, 8)).append("...)");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static enum DimensionState {
        AVAILABLE,
        IN_USE,
        CLEANING;

    }

    public static class DimensionPoolData
    extends SavedData {
        public static final String DATA_NAME = "instantworldmirror_dimension_pool";
        private final Map<Integer, Boolean> cleanupStates = new ConcurrentHashMap<Integer, Boolean>();
        private final Map<Integer, BlockPos> copyCenterPositions = new ConcurrentHashMap<Integer, BlockPos>();
        private final Map<Integer, Set<Long>> modifiedChunks = new ConcurrentHashMap<Integer, Set<Long>>();
        private final Map<Integer, Integer> cleanupProgress = new ConcurrentHashMap<Integer, Integer>();

        public static DimensionPoolData load(CompoundTag tag, HolderLookup.Provider provider) {
            DimensionPoolData data = new DimensionPoolData();
            CompoundTag states = tag.getCompound("cleanup_states");
            for (Object key : states.getAllKeys()) {
                try {
                    int dimIndex = Integer.parseInt((String)key);
                    data.cleanupStates.put(dimIndex, states.getBoolean((String)key));
                }
                catch (NumberFormatException dimIndex) {}
            }
            CompoundTag centers = tag.getCompound("copy_centers");
            for (String key : centers.getAllKeys()) {
                try {
                    int dimIndex = Integer.parseInt(key);
                    long[] pos = centers.getLongArray(key);
                    if (pos.length < 3) continue;
                    data.copyCenterPositions.put(dimIndex, new BlockPos((int)pos[0], (int)pos[1], (int)pos[2]));
                }
                catch (NumberFormatException dimIndex) {}
            }
            CompoundTag chunks = tag.getCompound("modified_chunks");
            for (String key : chunks.getAllKeys()) {
                try {
                    int dimIndex = Integer.parseInt(key);
                    long[] chunkArray = chunks.getLongArray(key);
                    ConcurrentHashMap.KeySetView chunkSet = ConcurrentHashMap.newKeySet();
                    for (long packed : chunkArray) {
                        chunkSet.add(packed);
                    }
                    data.modifiedChunks.put(dimIndex, chunkSet);
                }
                catch (NumberFormatException dimIndex) {}
            }
            CompoundTag progress = tag.getCompound("cleanup_progress");
            for (String key : progress.getAllKeys()) {
                try {
                    int dimIndex = Integer.parseInt(key);
                    data.cleanupProgress.put(dimIndex, progress.getInt(key));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return data;
        }

        public CompoundTag save(CompoundTag tag, HolderLookup.Provider provider) {
            CompoundTag states = new CompoundTag();
            for (Map.Entry<Integer, Boolean> entry : this.cleanupStates.entrySet()) {
                states.putBoolean(String.valueOf(entry.getKey()), entry.getValue().booleanValue());
            }
            tag.put("cleanup_states", (Tag)states);
            CompoundTag centers = new CompoundTag();
            for (Map.Entry<Integer, BlockPos> entry : this.copyCenterPositions.entrySet()) {
                BlockPos blockPos = entry.getValue();
                centers.putLongArray(String.valueOf(entry.getKey()), new long[]{blockPos.getX(), blockPos.getY(), blockPos.getZ()});
            }
            tag.put("copy_centers", (Tag)centers);
            CompoundTag compoundTag = new CompoundTag();
            for (Map.Entry<Integer, Set<Long>> entry : this.modifiedChunks.entrySet()) {
                long[] chunkArray = entry.getValue().stream().mapToLong(Long::longValue).toArray();
                compoundTag.putLongArray(String.valueOf(entry.getKey()), chunkArray);
            }
            tag.put("modified_chunks", (Tag)compoundTag);
            CompoundTag compoundTag2 = new CompoundTag();
            for (Map.Entry<Integer, Integer> entry : this.cleanupProgress.entrySet()) {
                compoundTag2.putInt(String.valueOf(entry.getKey()), entry.getValue().intValue());
            }
            tag.put("cleanup_progress", (Tag)compoundTag2);
            return tag;
        }

        public boolean isMarkedForCleanup(int dimIndex) {
            return this.cleanupStates.getOrDefault(dimIndex, false);
        }

        public void setCleanupState(int dimIndex, boolean cleaning) {
            if (cleaning) {
                this.cleanupStates.put(dimIndex, true);
            } else {
                this.cleanupStates.remove(dimIndex);
                this.copyCenterPositions.remove(dimIndex);
                this.modifiedChunks.remove(dimIndex);
                this.cleanupProgress.remove(dimIndex);
            }
            this.setDirty();
        }

        public BlockPos getCopyCenter(int dimIndex) {
            return this.copyCenterPositions.get(dimIndex);
        }

        public void setCopyCenter(int dimIndex, BlockPos pos) {
            if (pos != null) {
                this.copyCenterPositions.put(dimIndex, pos);
            } else {
                this.copyCenterPositions.remove(dimIndex);
            }
            this.setDirty();
        }

        public Set<Long> getModifiedChunks(int dimIndex) {
            return this.modifiedChunks.getOrDefault(dimIndex, Collections.emptySet());
        }

        public void setModifiedChunks(int dimIndex, Set<Long> chunks) {
            if (chunks != null && !chunks.isEmpty()) {
                this.modifiedChunks.put(dimIndex, new HashSet<Long>(chunks));
            } else {
                this.modifiedChunks.remove(dimIndex);
            }
            this.setDirty();
        }

        public int getCleanupProgress(int dimIndex) {
            return this.cleanupProgress.getOrDefault(dimIndex, 0);
        }

        public void setCleanupProgress(int dimIndex, int progress) {
            if (progress > 0) {
                this.cleanupProgress.put(dimIndex, progress);
            } else {
                this.cleanupProgress.remove(dimIndex);
            }
            this.setDirty();
        }

        public static SavedData.Factory<DimensionPoolData> factory() {
            return new SavedData.Factory(DimensionPoolData::new, DimensionPoolData::load);
        }
    }
}

