/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.world.ModDimensions;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class MirrorSession {
    private final UUID sessionId;
    private final UUID creatorId;
    private volatile UUID portalEntityId;
    private final BlockPos sourcePosition;
    private final ResourceKey<Level> sourceDimension;
    private volatile int dimensionIndex = -1;
    private final Set<UUID> playersInSession = ConcurrentHashMap.newKeySet();
    private volatile boolean destroyed = false;
    private volatile boolean copyComplete = false;
    private volatile boolean hostEntered = false;
    private final boolean sourceInWater;
    private final long createdAt;

    public MirrorSession(UUID creatorId, BlockPos sourcePosition, ResourceKey<Level> sourceDimension, boolean sourceInWater) {
        this.sessionId = UUID.randomUUID();
        this.creatorId = creatorId;
        this.sourcePosition = sourcePosition;
        this.sourceDimension = sourceDimension;
        this.sourceInWater = sourceInWater;
        this.createdAt = System.currentTimeMillis();
    }

    public UUID getSessionId() {
        return this.sessionId;
    }

    public UUID getCreatorId() {
        return this.creatorId;
    }

    public int getDimensionIndex() {
        return this.dimensionIndex;
    }

    public void setDimensionIndex(int dimensionIndex) {
        this.dimensionIndex = dimensionIndex;
    }

    public ResourceKey<Level> getMirrorDimension() {
        if (this.dimensionIndex < 0) {
            return null;
        }
        return ModDimensions.getMirrorWorld(this.dimensionIndex);
    }

    public UUID getPortalEntityId() {
        return this.portalEntityId;
    }

    public void setPortalEntityId(UUID portalEntityId) {
        this.portalEntityId = portalEntityId;
    }

    public BlockPos getSourcePosition() {
        return this.sourcePosition;
    }

    public ResourceKey<Level> getSourceDimension() {
        return this.sourceDimension;
    }

    public boolean isSourceInWater() {
        return this.sourceInWater;
    }

    public boolean addPlayer(UUID playerId) {
        if (this.destroyed) {
            return false;
        }
        return this.playersInSession.add(playerId);
    }

    public boolean removePlayer(UUID playerId) {
        this.playersInSession.remove(playerId);
        return this.playersInSession.isEmpty();
    }

    public boolean hasPlayer(UUID playerId) {
        return this.playersInSession.contains(playerId);
    }

    public int getPlayerCount() {
        return this.playersInSession.size();
    }

    public Set<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.playersInSession);
    }

    public boolean isEmpty() {
        return this.playersInSession.isEmpty();
    }

    public void markDestroyed() {
        this.destroyed = true;
        this.playersInSession.clear();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void markCopyComplete() {
        this.copyComplete = true;
    }

    public boolean isCopyComplete() {
        return this.copyComplete;
    }

    public void markHostEntered() {
        this.hostEntered = true;
    }

    public boolean hasHostEntered() {
        return this.hostEntered;
    }

    public boolean isHost(UUID playerId) {
        return this.creatorId.equals(playerId);
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public String toString() {
        return "MirrorSession{sessionId=" + String.valueOf(this.sessionId) + ", creatorId=" + String.valueOf(this.creatorId) + ", sourcePosition=" + String.valueOf(this.sourcePosition) + ", playerCount=" + this.playersInSession.size() + ", destroyed=" + this.destroyed + "}";
    }
}

