/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;

public class ModDimensions {
    public static final int MAX_MIRROR_WORLD_POOL_SIZE = 8;
    private static int configuredPoolSize = 4;
    public static final ResourceKey<DimensionType> MIRROR_WORLD_TYPE = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)"mirror_world"));
    public static final List<ResourceKey<Level>> MIRROR_WORLD_POOL = new ArrayList<ResourceKey<Level>>();

    public static void updatePoolSizeFromConfig() {
        int configured = (Integer)MirrorConfig.DIMENSION_POOL_SIZE.get();
        configuredPoolSize = Math.min(configured, 8);
        InstantWorldMirror.LOGGER.info("Mirror dimension pool size set to {}", (Object)configuredPoolSize);
    }

    public static int getPoolSize() {
        return configuredPoolSize;
    }

    public static ResourceKey<Level> getMirrorWorld(int index) {
        if (index < 0 || index >= configuredPoolSize) {
            return MIRROR_WORLD_POOL.get(0);
        }
        return MIRROR_WORLD_POOL.get(index);
    }

    public static boolean isMirrorWorld(ResourceKey<Level> dimension) {
        int index = MIRROR_WORLD_POOL.indexOf(dimension);
        return index >= 0 && index < configuredPoolSize;
    }

    public static boolean isAnyMirrorWorld(ResourceKey<Level> dimension) {
        return MIRROR_WORLD_POOL.contains(dimension);
    }

    public static int getMirrorWorldIndex(ResourceKey<Level> dimension) {
        int index = MIRROR_WORLD_POOL.indexOf(dimension);
        if (index >= 0 && index < configuredPoolSize) {
            return index;
        }
        return -1;
    }

    static {
        for (int i = 0; i < 8; ++i) {
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"instantworldmirror", (String)("mirror_world_" + i)));
            MIRROR_WORLD_POOL.add((ResourceKey<Level>)dimension);
        }
    }
}

