/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world;

import com.crabmods.instantworldmirror.InstantWorldMirror;
import com.crabmods.instantworldmirror.MirrorConfig;
import com.crabmods.instantworldmirror.mixin.LevelChunkSectionAccessor;
import com.crabmods.instantworldmirror.world.DimensionPool;
import com.crabmods.instantworldmirror.world.MirrorSession;
import com.crabmods.instantworldmirror.world.MirrorWorldManager;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.VehicleEntity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;

public class WorldCopyService {
    private static final Map<Integer, CleanupTask> cleanupTasks = new ConcurrentHashMap<Integer, CleanupTask>();
    private static final Map<Integer, CopyTask> copyTasks = new ConcurrentHashMap<Integer, CopyTask>();
    private static final LinkedList<Integer> copyQueue = new LinkedList();
    private static final LinkedList<Integer> cleanupQueue = new LinkedList();
    private static final Map<Integer, Set<Long>> modifiedChunks = new ConcurrentHashMap<Integer, Set<Long>>();
    private static final Map<Integer, BlockPos> copyCenterPositions = new ConcurrentHashMap<Integer, BlockPos>();
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_POS = ThreadLocal.withInitial(BlockPos.MutableBlockPos::new);
    private static final Set<Integer> pendingSave = ConcurrentHashMap.newKeySet();
    private static int saveTickCounter = 0;
    private static final int SAVE_TICK_INTERVAL = 200;
    private static final TicketType<ChunkPos> MIRROR_PRELOAD_TICKET = TicketType.create((String)"mirror_preload", (a, b) -> Long.compare(a.toLong(), b.toLong()), (int)100);
    private static boolean biomesCopyError = false;
    private static boolean structureCopyError = false;
    private static Field pendingBlockEntitiesField = null;
    private static boolean pendingBEFieldInitialized = false;

    public static void trackModifiedChunk(int dimIndex, int chunkX, int chunkZ) {
        modifiedChunks.computeIfAbsent(dimIndex, k -> ConcurrentHashMap.newKeySet()).add(WorldCopyService.packChunkPos(chunkX, chunkZ));
        pendingSave.add(dimIndex);
    }

    public static void trackChunksInRadius(int dimIndex, int centerChunkX, int centerChunkZ, int radius) {
        for (int x = centerChunkX - radius; x <= centerChunkX + radius; ++x) {
            for (int z = centerChunkZ - radius; z <= centerChunkZ + radius; ++z) {
                WorldCopyService.trackModifiedChunk(dimIndex, x, z);
            }
        }
    }

    public static Set<Long> getModifiedChunks(int dimIndex) {
        return modifiedChunks.getOrDefault(dimIndex, Collections.emptySet());
    }

    public static void clearModifiedChunkTracking(int dimIndex) {
        modifiedChunks.remove(dimIndex);
        pendingSave.remove(dimIndex);
    }

    public static void savePendingModifications() {
        if (pendingSave.isEmpty()) {
            return;
        }
        for (Integer dimIndex : new ArrayList<Integer>(pendingSave)) {
            BlockPos centerPos = copyCenterPositions.get(dimIndex);
            Set<Long> chunks = modifiedChunks.get(dimIndex);
            if (centerPos == null && (chunks == null || chunks.isEmpty())) continue;
            DimensionPool.saveCleanupData(dimIndex, centerPos, chunks, 0);
            pendingSave.remove(dimIndex);
        }
    }

    private static long packChunkPos(int x, int z) {
        return (long)x << 32 | (long)z & 0xFFFFFFFFL;
    }

    private static int unpackChunkX(long packed) {
        return (int)(packed >> 32);
    }

    private static int unpackChunkZ(long packed) {
        return (int)packed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelCopyTask(int dimensionIndex) {
        CopyTask task = copyTasks.get(dimensionIndex);
        if (task != null && !task.isCompleted()) {
            task.cancel();
            InstantWorldMirror.LOGGER.debug("Cancelled copy task for dimension {}", (Object)dimensionIndex);
        }
        copyTasks.remove(dimensionIndex);
        LinkedList<Integer> linkedList = copyQueue;
        synchronized (linkedList) {
            copyQueue.removeFirstOccurrence(dimensionIndex);
        }
        copyCenterPositions.remove(dimensionIndex);
        modifiedChunks.remove(dimensionIndex);
        pendingSave.remove(dimensionIndex);
    }

    private static Set<Long> scanRegionFilesForChunks(ServerLevel mirrorWorld) {
        HashSet<Long> chunks = new HashSet<Long>();
        try {
            Path worldFolder = mirrorWorld.getServer().getWorldPath(LevelResource.ROOT);
            String dimensionPath = mirrorWorld.dimension().location().toString().replace(":", "/");
            Path regionFolder = worldFolder.resolve("dimensions").resolve(dimensionPath).resolve("region");
            if (!Files.exists(regionFolder, new LinkOption[0])) {
                InstantWorldMirror.LOGGER.debug("Region folder does not exist: {}", (Object)regionFolder);
                return chunks;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(regionFolder, "r.*.*.mca");){
                for (Path regionFile : stream) {
                    String fileName = regionFile.getFileName().toString();
                    String[] parts = fileName.split("\\.");
                    if (parts.length < 4) continue;
                    try {
                        int regionX = Integer.parseInt(parts[1]);
                        int regionZ = Integer.parseInt(parts[2]);
                        Set<Long> regionChunks = WorldCopyService.scanRegionFileForChunks(regionFile, regionX, regionZ);
                        chunks.addAll(regionChunks);
                    }
                    catch (NumberFormatException e) {
                        InstantWorldMirror.LOGGER.debug("Skipping malformed region file: {}", (Object)fileName);
                    }
                }
            }
            InstantWorldMirror.LOGGER.debug("Found {} chunks in {} region files", (Object)chunks.size(), (Object)Files.list(regionFolder).count());
        }
        catch (Exception e) {
            InstantWorldMirror.LOGGER.warn("Error scanning region files: {}", (Object)e.getMessage());
        }
        return chunks;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Set<Long> scanRegionFileForChunks(Path regionFile, int regionX, int regionZ) {
        HashSet<Long> chunks = new HashSet<Long>();
        try (RandomAccessFile raf = new RandomAccessFile(regionFile.toFile(), "r");){
            byte[] header = new byte[4096];
            int bytesRead = raf.read(header);
            if (bytesRead < 4096) {
                HashSet<Long> hashSet = chunks;
                return hashSet;
            }
            int localZ = 0;
            while (localZ < 32) {
                for (int localX = 0; localX < 32; ++localX) {
                    int index = (localX + localZ * 32) * 4;
                    int offset = (header[index] & 0xFF) << 16 | (header[index + 1] & 0xFF) << 8 | header[index + 2] & 0xFF;
                    int sectorCount = header[index + 3] & 0xFF;
                    if (offset == 0 || sectorCount == 0) continue;
                    int chunkX = regionX * 32 + localX;
                    int chunkZ = regionZ * 32 + localZ;
                    chunks.add(WorldCopyService.packChunkPos(chunkX, chunkZ));
                }
                ++localZ;
            }
            return chunks;
        }
        catch (Exception e) {
            InstantWorldMirror.LOGGER.debug("Error reading region file {}: {}", (Object)regionFile, (Object)e.getMessage());
        }
        return chunks;
    }

    private static boolean hasBlocksInChunk(ServerLevel level, int chunkX, int chunkZ) {
        try {
            LevelChunk chunk = level.getChunkSource().getChunkNow(chunkX, chunkZ);
            if (chunk == null) {
                return false;
            }
            int sectionCount = chunk.getSectionsCount();
            for (int i = 0; i < sectionCount; ++i) {
                LevelChunkSection section = chunk.getSection(i);
                if (section == null || section.hasOnlyAir()) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean isPortalBlock(BlockState state) {
        return state.is(Blocks.NETHER_PORTAL) || state.is(Blocks.END_PORTAL) || state.is(Blocks.END_PORTAL_FRAME) || state.is(Blocks.END_GATEWAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int queueWorldCopy(MirrorSession session, ServerLevel sourceWorld) {
        ServerLevel mirrorWorld;
        int chunkRadius = (Integer)MirrorConfig.COPY_CHUNK_RADIUS.get();
        int dimIndex = session.getDimensionIndex();
        MinecraftServer server = sourceWorld.getServer();
        if (server != null && (mirrorWorld = DimensionPool.getDimensionLevel(server, dimIndex)) != null) {
            WorldCopyService.syncGameRules(sourceWorld, mirrorWorld);
        }
        CopyTask task = new CopyTask(session.getSessionId(), session.getSourcePosition(), chunkRadius, (ResourceKey<Level>)sourceWorld.dimension(), dimIndex);
        copyTasks.put(dimIndex, task);
        LinkedList<Integer> linkedList = copyQueue;
        synchronized (linkedList) {
            if (!copyQueue.contains(dimIndex)) {
                copyQueue.addLast(dimIndex);
            }
        }
        copyCenterPositions.put(dimIndex, session.getSourcePosition());
        DimensionPool.saveCleanupData(dimIndex, session.getSourcePosition(), null, 0);
        int queuePosition = WorldCopyService.getCopyQueuePosition(dimIndex);
        InstantWorldMirror.LOGGER.debug("Queued world copy for session {} to dimension {}", (Object)session.getSessionId(), (Object)dimIndex);
        return queuePosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCopyQueuePosition(int dimIndex) {
        LinkedList<Integer> linkedList = copyQueue;
        synchronized (linkedList) {
            int position = copyQueue.indexOf(dimIndex);
            return position >= 0 ? position + 1 : 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCopyQueueSize() {
        LinkedList<Integer> linkedList = copyQueue;
        synchronized (linkedList) {
            return copyQueue.size();
        }
    }

    private static void syncGameRules(ServerLevel sourceWorld, ServerLevel mirrorWorld) {
        try {
            GameRules sourceRules = sourceWorld.getGameRules();
            GameRules mirrorRules = mirrorWorld.getGameRules();
            mirrorRules.assignFrom(sourceRules, mirrorWorld.getServer());
            InstantWorldMirror.LOGGER.debug("Synced game rules from {} to mirror world", (Object)sourceWorld.dimension().location());
        }
        catch (Exception e) {
            InstantWorldMirror.LOGGER.warn("Failed to sync game rules: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCopyQueues(MinecraftServer server) {
        Integer currentDimIndex;
        if (copyTasks.isEmpty()) {
            return;
        }
        int chunksPerTick = (Integer)MirrorConfig.COPY_CHUNKS_PER_TICK.get();
        LinkedList<Integer> linkedList = copyQueue;
        synchronized (linkedList) {
            if (copyQueue.isEmpty()) {
                return;
            }
            currentDimIndex = copyQueue.peekFirst();
        }
        CopyTask task = copyTasks.get(currentDimIndex);
        if (task == null) {
            LinkedList<Integer> linkedList2 = copyQueue;
            synchronized (linkedList2) {
                copyQueue.removeFirstOccurrence(currentDimIndex);
            }
            return;
        }
        if (task.isCompleted()) {
            copyTasks.remove(currentDimIndex);
            LinkedList<Integer> linkedList3 = copyQueue;
            synchronized (linkedList3) {
                copyQueue.removeFirstOccurrence(currentDimIndex);
            }
            if (task.isCancelled()) {
                InstantWorldMirror.LOGGER.debug("Copy task for dimension {} was cancelled", (Object)currentDimIndex);
            }
            return;
        }
        ServerLevel targetWorld = DimensionPool.getDimensionLevel(server, currentDimIndex);
        if (targetWorld == null) {
            return;
        }
        ServerLevel sourceWorld = server.getLevel(task.sourceDimension);
        if (sourceWorld == null) {
            sourceWorld = server.overworld();
        }
        if (!task.isPreloadingStarted()) {
            task.preloadChunksAsync(sourceWorld, targetWorld);
        }
        for (int i = 0; i < chunksPerTick && !task.isCompleted(); ++i) {
            int[] chunkCoords = task.getNextChunk();
            if (chunkCoords == null) continue;
            int blocksCopied = WorldCopyService.copyChunk(sourceWorld, targetWorld, chunkCoords[0], chunkCoords[1]);
            task.addBlocksCopied(blocksCopied);
            if (blocksCopied > 0) {
                WorldCopyService.trackModifiedChunk(currentDimIndex, chunkCoords[0], chunkCoords[1]);
            }
            task.preloadChunksAsync(sourceWorld, targetWorld);
        }
        if (task.isCompleted()) {
            copyTasks.remove(currentDimIndex);
            LinkedList<Integer> linkedList4 = copyQueue;
            synchronized (linkedList4) {
                copyQueue.removeFirstOccurrence(currentDimIndex);
            }
            if (!task.isCancelled()) {
                MirrorWorldManager.getSession(task.sessionId).ifPresent(MirrorSession::markCopyComplete);
                InstantWorldMirror.LOGGER.debug("World copy completed for session {} in dimension {}", (Object)task.sessionId, (Object)currentDimIndex);
            }
        }
    }

    public static boolean isCopyComplete(UUID sessionId) {
        return MirrorWorldManager.getSession(sessionId).map(session -> {
            CopyTask task = copyTasks.get(session.getDimensionIndex());
            return task == null || task.isCompleted();
        }).orElse(true);
    }

    public static int getCopyProgress(UUID sessionId) {
        return MirrorWorldManager.getSession(sessionId).map(session -> {
            CopyTask task = copyTasks.get(session.getDimensionIndex());
            if (task == null) {
                return 100;
            }
            return task.getProgressPercent();
        }).orElse(100);
    }

    private static int copyChunk(ServerLevel sourceWorld, ServerLevel mirrorWorld, int chunkX, int chunkZ) {
        int blocksCopied = 0;
        try {
            LevelChunk sourceChunk = sourceWorld.getChunkSource().getChunkNow(chunkX, chunkZ);
            if (sourceChunk == null) {
                sourceWorld.getChunkSource().getChunk(chunkX, chunkZ, ChunkStatus.FULL, false);
                return 0;
            }
            LevelChunk targetChunk = mirrorWorld.getChunk(chunkX, chunkZ);
            int maxHeight = WorldCopyService.getChunkMaxHeight(sourceChunk);
            int minY = sourceWorld.getMinBuildHeight();
            BlockPos.MutableBlockPos sourcePos = MUTABLE_POS.get();
            BlockPos.MutableBlockPos targetPos = new BlockPos.MutableBlockPos();
            int sectionCount = sourceChunk.getSectionsCount();
            int chunkMinSectionY = sourceChunk.getMinSection();
            for (int relativeSectionIndex = 0; relativeSectionIndex < sectionCount; ++relativeSectionIndex) {
                int sectionY;
                int baseY;
                LevelChunkSection sourceSection = sourceChunk.getSection(relativeSectionIndex);
                if (sourceSection == null || sourceSection.hasOnlyAir() || (baseY = (sectionY = chunkMinSectionY + relativeSectionIndex) * 16) > maxHeight) continue;
                LevelChunkSection targetSection = targetChunk.getSection(relativeSectionIndex);
                ArrayList<int[]> blockEntitiesToCopy = null;
                for (int localY = 0; localY < 16; ++localY) {
                    int y = baseY + localY;
                    if (y < minY) continue;
                    for (int localZ = 0; localZ < 16; ++localZ) {
                        int worldZ = chunkZ * 16 + localZ;
                        for (int localX = 0; localX < 16; ++localX) {
                            BlockState state;
                            int worldX = chunkX * 16 + localX;
                            int columnHeight = sourceChunk.getHeight(Heightmap.Types.WORLD_SURFACE, localX, localZ);
                            if (y > columnHeight && y > 0 || (state = sourceSection.getBlockState(localX, localY, localZ)) == null || state.isAir() || WorldCopyService.isPortalBlock(state)) continue;
                            if (targetSection != null) {
                                targetSection.setBlockState(localX, localY, localZ, state, false);
                            } else {
                                targetPos.set(worldX, y, worldZ);
                                mirrorWorld.setBlock((BlockPos)targetPos, state, 18);
                            }
                            ++blocksCopied;
                            if (!state.hasBlockEntity()) continue;
                            if (blockEntitiesToCopy == null) {
                                blockEntitiesToCopy = new ArrayList<int[]>();
                            }
                            blockEntitiesToCopy.add(new int[]{worldX, y, worldZ, localX, localY, localZ});
                        }
                    }
                }
                if (blockEntitiesToCopy == null) continue;
                for (int[] coords : blockEntitiesToCopy) {
                    sourcePos.set(coords[0], coords[1], coords[2]);
                    targetPos.set(coords[0], coords[1], coords[2]);
                    WorldCopyService.copyBlockEntity(sourceWorld, mirrorWorld, (BlockPos)sourcePos, (BlockPos)targetPos);
                }
            }
            targetChunk.setUnsaved(true);
            if (((Boolean)MirrorConfig.COPY_BIOMES.get()).booleanValue()) {
                WorldCopyService.copyChunkBiomes(sourceChunk, targetChunk);
            }
            if (((Boolean)MirrorConfig.COPY_STRUCTURES.get()).booleanValue()) {
                WorldCopyService.copyChunkStructures(sourceChunk, targetChunk, sourceWorld, mirrorWorld);
            }
            if (((Boolean)MirrorConfig.COPY_HEIGHTMAPS.get()).booleanValue()) {
                WorldCopyService.regenerateHeightmaps(targetChunk);
            }
            boolean copyAll = (Boolean)MirrorConfig.COPY_ENTITIES.get();
            boolean copyDecorations = (Boolean)MirrorConfig.COPY_DECORATION_ENTITIES.get();
            if (copyAll || copyDecorations) {
                WorldCopyService.copyEntitiesInChunk(sourceWorld, mirrorWorld, chunkX, chunkZ, copyAll, copyDecorations);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            InstantWorldMirror.LOGGER.warn("Failed to copy chunk ({}, {}): {}", new Object[]{chunkX, chunkZ, errorMsg});
        }
        return blocksCopied;
    }

    private static int getChunkMaxHeight(LevelChunk chunk) {
        int maxHeight = chunk.getMinBuildHeight();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height = chunk.getHeight(Heightmap.Types.WORLD_SURFACE, x, z);
                if (height <= maxHeight) continue;
                maxHeight = height;
            }
        }
        return maxHeight;
    }

    private static boolean isDecorationEntity(Entity entity) {
        if (entity instanceof HangingEntity) {
            return true;
        }
        if (entity instanceof ArmorStand) {
            return true;
        }
        if (entity instanceof Display) {
            return true;
        }
        return entity instanceof VehicleEntity;
    }

    private static void copyEntitiesInChunk(ServerLevel sourceWorld, ServerLevel mirrorWorld, int chunkX, int chunkZ, boolean copyAll, boolean copyDecorations) {
        try {
            int minX = chunkX * 16;
            int minZ = chunkZ * 16;
            int maxX = minX + 16;
            int maxZ = minZ + 16;
            int minY = sourceWorld.getMinBuildHeight();
            int maxY = sourceWorld.getMaxBuildHeight();
            AABB chunkBounds = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = sourceWorld.getEntities((Entity)null, chunkBounds, entity -> {
                if (entity instanceof Player) {
                    return false;
                }
                if (copyAll) {
                    return true;
                }
                return copyDecorations && WorldCopyService.isDecorationEntity(entity);
            });
            if (entities.isEmpty()) {
                return;
            }
            CompoundTag entityData = new CompoundTag();
            ArrayList<Entity> entitiesToAdd = new ArrayList<Entity>(entities.size());
            for (Entity sourceEntity : entities) {
                try {
                    EntityType entityType = sourceEntity.getType();
                    Entity newEntity = entityType.create((Level)mirrorWorld);
                    if (newEntity == null) continue;
                    entityData.getAllKeys().clear();
                    sourceEntity.save(entityData);
                    entityData.remove("UUID");
                    newEntity.load(entityData);
                    newEntity.setPos(sourceEntity.getX(), sourceEntity.getY(), sourceEntity.getZ());
                    entitiesToAdd.add(newEntity);
                }
                catch (Exception exception) {}
            }
            for (Entity entity2 : entitiesToAdd) {
                mirrorWorld.addFreshEntity(entity2);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            InstantWorldMirror.LOGGER.debug("Error copying entities in chunk ({}, {}): {}", new Object[]{chunkX, chunkZ, errorMsg});
        }
    }

    private static void clearEntitiesInChunk(ServerLevel mirrorWorld, int chunkX, int chunkZ) {
        try {
            int minX = chunkX * 16 - 1;
            int minZ = chunkZ * 16 - 1;
            int maxX = minX + 18;
            int maxZ = minZ + 18;
            int minY = mirrorWorld.getMinBuildHeight();
            int maxY = mirrorWorld.getMaxBuildHeight();
            AABB chunkBounds = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = mirrorWorld.getEntities((Entity)null, chunkBounds, entity -> !(entity instanceof Player));
            for (Entity entity2 : entities) {
                int entityChunkX = (int)Math.floor(entity2.getX()) >> 4;
                int entityChunkZ = (int)Math.floor(entity2.getZ()) >> 4;
                if (entityChunkX != chunkX || entityChunkZ != chunkZ) continue;
                entity2.discard();
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            InstantWorldMirror.LOGGER.debug("Error clearing entities in chunk ({}, {}): {}", new Object[]{chunkX, chunkZ, errorMsg});
        }
    }

    private static void copyChunkBiomes(LevelChunk sourceChunk, LevelChunk targetChunk) {
        block7: {
            if (biomesCopyError) {
                return;
            }
            try {
                int sectionCount = sourceChunk.getSectionsCount();
                for (int sectionIndex = 0; sectionIndex < sectionCount; ++sectionIndex) {
                    PalettedContainerRO sourceBiomes;
                    LevelChunkSection sourceSection = sourceChunk.getSection(sectionIndex);
                    LevelChunkSection targetSection = targetChunk.getSection(sectionIndex);
                    if (sourceSection == null || targetSection == null || (sourceBiomes = sourceSection.getBiomes()) == null) continue;
                    PalettedContainer newBiomes = sourceBiomes.recreate();
                    for (int biomeX = 0; biomeX < 4; ++biomeX) {
                        for (int biomeY = 0; biomeY < 4; ++biomeY) {
                            for (int biomeZ = 0; biomeZ < 4; ++biomeZ) {
                                Holder biome = (Holder)sourceBiomes.get(biomeX, biomeY, biomeZ);
                                newBiomes.getAndSetUnchecked(biomeX, biomeY, biomeZ, (Object)biome);
                            }
                        }
                    }
                    ((LevelChunkSectionAccessor)targetSection).setBiomes((PalettedContainerRO<Holder<Biome>>)newBiomes);
                }
                targetChunk.setUnsaved(true);
            }
            catch (Exception e) {
                if (biomesCopyError) break block7;
                biomesCopyError = true;
                InstantWorldMirror.LOGGER.warn("Failed to copy biomes for chunk ({}, {}): {}. This may affect grass colors and sky effects for modded dimensions.", new Object[]{sourceChunk.getPos().x, sourceChunk.getPos().z, e.getMessage()});
            }
        }
    }

    private static void copyChunkStructures(LevelChunk sourceChunk, LevelChunk targetChunk, ServerLevel sourceWorld, ServerLevel mirrorWorld) {
        block10: {
            if (structureCopyError) {
                return;
            }
            try {
                Map sourceRefs;
                Map sourceStarts = sourceChunk.getAllStarts();
                if (!sourceStarts.isEmpty()) {
                    for (Map.Entry entry : sourceStarts.entrySet()) {
                        Structure structure = (Structure)entry.getKey();
                        StructureStart sourceStart = (StructureStart)entry.getValue();
                        if (sourceStart == null || !sourceStart.isValid()) continue;
                        try {
                            targetChunk.setStartForStructure(structure, sourceStart);
                        }
                        catch (Exception e) {
                            InstantWorldMirror.LOGGER.debug("Could not copy structure start {}: {}", (Object)structure, (Object)e.getMessage());
                        }
                    }
                }
                if (!(sourceRefs = sourceChunk.getAllReferences()).isEmpty()) {
                    for (Map.Entry entry : sourceRefs.entrySet()) {
                        Structure structure = (Structure)entry.getKey();
                        LongSet refs = (LongSet)entry.getValue();
                        if (refs == null || refs.isEmpty()) continue;
                        LongIterator longIterator = refs.iterator();
                        while (longIterator.hasNext()) {
                            long ref = (Long)longIterator.next();
                            targetChunk.addReferenceForStructure(structure, ref);
                        }
                    }
                }
                targetChunk.setUnsaved(true);
            }
            catch (Exception e) {
                if (structureCopyError) break block10;
                structureCopyError = true;
                InstantWorldMirror.LOGGER.warn("Failed to copy structure data for chunk ({}, {}): {}. This may affect mod features that depend on structure data.", new Object[]{sourceChunk.getPos().x, sourceChunk.getPos().z, e.getMessage()});
            }
        }
    }

    private static void regenerateHeightmaps(LevelChunk targetChunk) {
        try {
            Heightmap.primeHeightmaps((ChunkAccess)targetChunk, EnumSet.of(Heightmap.Types.MOTION_BLOCKING, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Heightmap.Types.OCEAN_FLOOR, Heightmap.Types.WORLD_SURFACE));
            targetChunk.setUnsaved(true);
        }
        catch (Exception e) {
            InstantWorldMirror.LOGGER.debug("Failed to regenerate heightmaps for chunk ({}, {}): {}", new Object[]{targetChunk.getPos().x, targetChunk.getPos().z, e.getMessage()});
        }
    }

    private static void copyBlockEntity(ServerLevel sourceWorld, ServerLevel mirrorWorld, BlockPos sourcePos, BlockPos targetPos) {
        BlockEntity sourceBE = sourceWorld.getBlockEntity(sourcePos);
        if (sourceBE != null) {
            try {
                BlockState targetState = mirrorWorld.getBlockState(targetPos);
                BlockState sourceState = sourceWorld.getBlockState(sourcePos);
                if (!targetState.is(sourceState.getBlock())) {
                    return;
                }
                BlockEntity targetBE = mirrorWorld.getBlockEntity(targetPos);
                if (targetBE != null && targetBE.getType() == sourceBE.getType()) {
                    targetBE.loadWithComponents(sourceBE.saveWithoutMetadata((HolderLookup.Provider)sourceWorld.registryAccess()), (HolderLookup.Provider)sourceWorld.registryAccess());
                    targetBE.setChanged();
                }
            }
            catch (Exception e) {
                InstantWorldMirror.LOGGER.trace("Could not copy block entity at {}: {}", (Object)sourcePos, (Object)e.getMessage());
            }
        }
    }

    private static void clearPendingBlockEntities(LevelChunk chunk) {
        try {
            Map map;
            Object value;
            if (!pendingBEFieldInitialized) {
                pendingBEFieldInitialized = true;
                for (Field field : LevelChunk.class.getDeclaredFields()) {
                    if (!Map.class.isAssignableFrom(field.getType())) continue;
                    field.setAccessible(true);
                    try {
                        Object firstKey;
                        Map testMap;
                        Object testValue = field.get(chunk);
                        if (!(testValue instanceof Map) || (testMap = (Map)testValue).isEmpty() || !((firstKey = testMap.keySet().iterator().next()) instanceof BlockPos)) continue;
                        pendingBlockEntitiesField = field;
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (pendingBlockEntitiesField != null && (value = pendingBlockEntitiesField.get(chunk)) instanceof Map && !(map = (Map)value).isEmpty()) {
                int count = map.size();
                map.clear();
                if (count > 0) {
                    InstantWorldMirror.LOGGER.debug("Cleared {} pending block entities from chunk", (Object)count);
                }
            }
        }
        catch (Exception e) {
            InstantWorldMirror.LOGGER.debug("Could not clear pending BEs via reflection: {}", (Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupMirrorWorld(ServerLevel mirrorWorld, int dimensionIndex) {
        WorldCopyService.cancelCleanupTask(dimensionIndex);
        WorldCopyService.clearAllEntitiesInDimension(mirrorWorld);
        CleanupTask task = new CleanupTask(dimensionIndex);
        task.initializeChunkList(mirrorWorld);
        cleanupTasks.put(dimensionIndex, task);
        LinkedList<Integer> linkedList = cleanupQueue;
        synchronized (linkedList) {
            if (!cleanupQueue.contains(dimensionIndex)) {
                cleanupQueue.addLast(dimensionIndex);
            }
        }
        InstantWorldMirror.LOGGER.debug("Queued cleanup for dimension {}", (Object)dimensionIndex);
    }

    @Deprecated
    public static void cleanupMirrorWorld(ServerLevel mirrorWorld, BlockPos centerPos, int dimensionIndex) {
        WorldCopyService.cleanupMirrorWorld(mirrorWorld, dimensionIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processCleanupQueues(MinecraftServer server) {
        boolean stillInProgress;
        Integer currentDimIndex;
        if (++saveTickCounter >= 200) {
            saveTickCounter = 0;
            WorldCopyService.savePendingModifications();
        }
        if (cleanupTasks.isEmpty()) {
            return;
        }
        int chunksPerTick = (Integer)MirrorConfig.CLEANUP_CHUNKS_PER_TICK.get();
        LinkedList<Integer> linkedList = cleanupQueue;
        synchronized (linkedList) {
            if (cleanupQueue.isEmpty()) {
                return;
            }
            currentDimIndex = cleanupQueue.peekFirst();
        }
        CleanupTask task = cleanupTasks.get(currentDimIndex);
        if (task == null) {
            LinkedList<Integer> linkedList2 = cleanupQueue;
            synchronized (linkedList2) {
                cleanupQueue.removeFirstOccurrence(currentDimIndex);
            }
            return;
        }
        ServerLevel mirrorWorld = DimensionPool.getDimensionLevel(server, currentDimIndex);
        if (mirrorWorld == null) {
            return;
        }
        if (task.isCompleted()) {
            cleanupTasks.remove(currentDimIndex);
            LinkedList<Integer> linkedList3 = cleanupQueue;
            synchronized (linkedList3) {
                cleanupQueue.removeFirstOccurrence(currentDimIndex);
            }
            WorldCopyService.clearAllEntitiesInDimension(mirrorWorld);
            WorldCopyService.clearModifiedChunkTracking(currentDimIndex);
            copyCenterPositions.remove(currentDimIndex);
            DimensionPool.markDimensionAvailable(currentDimIndex);
            InstantWorldMirror.LOGGER.debug("Cleanup completed for dimension {}", (Object)currentDimIndex);
            return;
        }
        if (task.isBfsScanInProgress() && (stillInProgress = task.processBfsIncremental(mirrorWorld))) {
            return;
        }
        if (task.isRegionScanInProgress() && (stillInProgress = task.processRegionScanIncremental(mirrorWorld))) {
            return;
        }
        int processedThisTick = 0;
        for (int i = 0; i < chunksPerTick && !task.isCompleted(); ++i) {
            long[] chunkCoords = task.getNextChunk();
            if (chunkCoords != null) {
                int result = WorldCopyService.clearChunk(mirrorWorld, (int)chunkCoords[0], (int)chunkCoords[1]);
                if (result == -1) {
                    task.markForRetry((int)chunkCoords[0], (int)chunkCoords[1]);
                }
                ++processedThisTick;
                continue;
            }
            if (task.isCompleted()) break;
            if (task.isMainCleanupDone() && !task.isAuxiliaryCleanupDone()) {
                task.initializeAuxiliaryCleanup(mirrorWorld);
                break;
            }
            if (!task.isAuxiliaryCleanupDone() || !task.needsRegionScan()) break;
            task.initializeRegionScan(mirrorWorld);
            break;
        }
        if (task.isCompleted()) {
            cleanupTasks.remove(currentDimIndex);
            LinkedList<Integer> linkedList4 = cleanupQueue;
            synchronized (linkedList4) {
                cleanupQueue.removeFirstOccurrence(currentDimIndex);
            }
            WorldCopyService.clearAllEntitiesInDimension(mirrorWorld);
            WorldCopyService.clearModifiedChunkTracking(currentDimIndex);
            copyCenterPositions.remove(currentDimIndex);
            DimensionPool.markDimensionAvailable(currentDimIndex);
            InstantWorldMirror.LOGGER.debug("Cleanup completed for dimension {}", (Object)currentDimIndex);
        }
    }

    private static int countRemainingBlocks(ServerLevel mirrorWorld, CleanupTask task) {
        int totalBlocks = 0;
        try {
            Random random = new Random();
            List<long[]> allChunks = task.getAllCleanedChunks();
            int sampleSize = Math.min(10, allChunks.size());
            for (int i = 0; i < sampleSize; ++i) {
                int index = random.nextInt(allChunks.size());
                long[] coords = allChunks.get(index);
                int chunkX = (int)coords[0];
                int chunkZ = (int)coords[1];
                try {
                    LevelChunk chunk = mirrorWorld.getChunkSource().getChunkNow(chunkX, chunkZ);
                    if (chunk == null) continue;
                    int sectionCount = chunk.getSectionsCount();
                    for (int s = 0; s < sectionCount; ++s) {
                        LevelChunkSection section = chunk.getSection(s);
                        if (section == null || section.hasOnlyAir()) continue;
                        for (int x = 0; x < 16; x += 4) {
                            for (int y = 0; y < 16; y += 4) {
                                for (int z = 0; z < 16; z += 4) {
                                    BlockState state = section.getBlockState(x, y, z);
                                    if (state == null || state.isAir()) continue;
                                    ++totalBlocks;
                                }
                            }
                        }
                    }
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return totalBlocks;
    }

    private static int clearChunk(ServerLevel mirrorWorld, int chunkX, int chunkZ) {
        int blocksCleared;
        block8: {
            blocksCleared = 0;
            try {
                LevelChunk chunk = mirrorWorld.getChunkSource().getChunkNow(chunkX, chunkZ);
                if (chunk == null) {
                    try {
                        chunk = mirrorWorld.getChunk(chunkX, chunkZ);
                    }
                    catch (Exception e) {
                        InstantWorldMirror.LOGGER.debug("Force chunk load failed for ({}, {}), trying alternate method", (Object)chunkX, (Object)chunkZ);
                        return -1;
                    }
                    if (chunk == null) {
                        InstantWorldMirror.LOGGER.warn("Could not load chunk ({}, {}) for cleanup", (Object)chunkX, (Object)chunkZ);
                        return 0;
                    }
                }
                WorldCopyService.clearPendingBlockEntities(chunk);
                for (BlockPos bePos : new ArrayList(chunk.getBlockEntities().keySet())) {
                    mirrorWorld.removeBlockEntity(bePos);
                }
                int sectionCount = chunk.getSectionsCount();
                for (int relativeSectionIndex = 0; relativeSectionIndex < sectionCount; ++relativeSectionIndex) {
                    LevelChunkSection section = chunk.getSection(relativeSectionIndex);
                    if (section == null || section.hasOnlyAir()) continue;
                    blocksCleared += WorldCopyService.countNonAirBlocks(section);
                    WorldCopyService.clearSectionBlockStates(section);
                }
                WorldCopyService.clearEntitiesInChunk(mirrorWorld, chunkX, chunkZ);
                chunk.setUnsaved(true);
            }
            catch (Exception e) {
                String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
                InstantWorldMirror.LOGGER.warn("Failed to clear chunk ({}, {}): {}", new Object[]{chunkX, chunkZ, errorMsg});
                if (!InstantWorldMirror.LOGGER.isDebugEnabled()) break block8;
                InstantWorldMirror.LOGGER.debug("Chunk clear exception details:", (Throwable)e);
            }
        }
        return blocksCleared;
    }

    private static int countNonAirBlocks(LevelChunkSection section) {
        if (section.hasOnlyAir()) {
            return 0;
        }
        return 1024;
    }

    private static void clearSectionBlockStates(LevelChunkSection section) {
        BlockState airState = Blocks.AIR.defaultBlockState();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    section.setBlockState(x, y, z, airState, false);
                }
            }
        }
    }

    private static boolean clearEntitiesIncrementally(ServerLevel mirrorWorld, int dimIndex, int maxEntitiesPerTick) {
        try {
            int removed = 0;
            Iterable allEntities = mirrorWorld.getAllEntities();
            for (Entity entity : allEntities) {
                if (entity instanceof Player) continue;
                entity.discard();
                if (++removed < maxEntitiesPerTick) continue;
                InstantWorldMirror.LOGGER.debug("Incremental entity cleanup: removed {} entities, more remaining", (Object)removed);
                return true;
            }
            if (removed > 0) {
                InstantWorldMirror.LOGGER.debug("Incremental entity cleanup: removed {} entities", (Object)removed);
            }
            return false;
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            InstantWorldMirror.LOGGER.debug("Error during incremental entity cleanup: {}", (Object)errorMsg);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void clearAllEntitiesInDimension(ServerLevel mirrorWorld) {
        try {
            Set<Long> trackedChunks;
            int removed = 0;
            int batchSize = 100;
            boolean moreEntities = true;
            while (moreEntities) {
                Iterable allEntities = mirrorWorld.getAllEntities();
                ArrayList toRemove = new ArrayList();
                int n = 0;
                for (Entity entity : allEntities) {
                    if (entity instanceof Player) continue;
                    toRemove.add(entity);
                    if (++n < batchSize) continue;
                    break;
                }
                if (toRemove.isEmpty()) {
                    moreEntities = false;
                    continue;
                }
                Iterator<Object> iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    Entity entity;
                    entity = (Entity)iterator.next();
                    entity.discard();
                    ++removed;
                }
            }
            int dimIndex = -1;
            for (Map.Entry entry : modifiedChunks.entrySet()) {
                if (DimensionPool.getDimensionLevel(mirrorWorld.getServer(), (Integer)entry.getKey()) != mirrorWorld) continue;
                dimIndex = (Integer)entry.getKey();
                break;
            }
            if (dimIndex >= 0 && (trackedChunks = modifiedChunks.get(dimIndex)) != null) {
                boolean bl = false;
                for (Long chunkKey : trackedChunks) {
                    void var6_13;
                    int chunkX = WorldCopyService.unpackChunkX(chunkKey);
                    int chunkZ = WorldCopyService.unpackChunkZ(chunkKey);
                    try {
                        LevelChunk chunk = mirrorWorld.getChunkSource().getChunkNow(chunkX, chunkZ);
                        if (chunk != null) {
                            removed += WorldCopyService.clearEntitiesInChunkForced(mirrorWorld, chunkX, chunkZ);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (++var6_13 < 50) continue;
                    break;
                }
            }
            if (removed > 0) {
                InstantWorldMirror.LOGGER.debug("Final cleanup: removed {} entities", (Object)removed);
            }
        }
        catch (Exception e) {
            String errorMsg = e.getMessage() != null ? e.getMessage() : e.getClass().getSimpleName();
            InstantWorldMirror.LOGGER.warn("Error during final entity cleanup: {}", (Object)errorMsg);
        }
    }

    private static int clearEntitiesInChunkForced(ServerLevel mirrorWorld, int chunkX, int chunkZ) {
        int removed = 0;
        try {
            int minX = chunkX * 16;
            int minZ = chunkZ * 16;
            int maxX = minX + 16;
            int maxZ = minZ + 16;
            int minY = mirrorWorld.getMinBuildHeight();
            int maxY = mirrorWorld.getMaxBuildHeight();
            AABB chunkBounds = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
            List entities = mirrorWorld.getEntities((Entity)null, chunkBounds, entity -> !(entity instanceof Player));
            for (Entity entity2 : entities) {
                entity2.discard();
                ++removed;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return removed;
    }

    public static boolean hasPendingCleanup(int dimIndex) {
        return cleanupTasks.containsKey(dimIndex);
    }

    public static boolean hasPendingCopy(int dimIndex) {
        return copyTasks.containsKey(dimIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelCleanupTask(int dimIndex) {
        CleanupTask removed = cleanupTasks.remove(dimIndex);
        if (removed != null) {
            InstantWorldMirror.LOGGER.debug("Cancelled cleanup task for dimension {}", (Object)dimIndex);
        }
        LinkedList<Integer> linkedList = cleanupQueue;
        synchronized (linkedList) {
            cleanupQueue.removeFirstOccurrence(dimIndex);
        }
    }

    public static void clearAllTasks() {
        for (Map.Entry<Integer, CleanupTask> entry : cleanupTasks.entrySet()) {
            CleanupTask task = entry.getValue();
            if (task.isCompleted()) continue;
            task.saveProgress();
            InstantWorldMirror.LOGGER.debug("Saved cleanup progress for dimension {}", (Object)task.dimensionIndex);
        }
        WorldCopyService.savePendingModifications();
        copyTasks.clear();
        cleanupTasks.clear();
        copyCenterPositions.clear();
        modifiedChunks.clear();
        pendingSave.clear();
        saveTickCounter = 0;
        InstantWorldMirror.LOGGER.debug("All tasks cleared");
    }

    public static class CopyTask {
        public final UUID sessionId;
        public final BlockPos centerPos;
        public final int chunkRadius;
        public final ResourceKey<Level> sourceDimension;
        public final int targetDimensionIndex;
        private int currentChunkX;
        private int currentChunkZ;
        private final int minChunkX;
        private final int maxChunkX;
        private final int minChunkZ;
        private final int maxChunkZ;
        private boolean started = false;
        private boolean completed = false;
        private int totalBlocksCopied = 0;
        private boolean preloadingStarted = false;
        private int preloadedChunks = 0;
        private static final int PRELOAD_AHEAD = 8;
        private boolean cancelled = false;

        public CopyTask(UUID sessionId, BlockPos centerPos, int chunkRadius, ResourceKey<Level> sourceDimension, int targetDimensionIndex) {
            this.sessionId = sessionId;
            this.centerPos = centerPos;
            this.chunkRadius = chunkRadius;
            this.sourceDimension = sourceDimension;
            this.targetDimensionIndex = targetDimensionIndex;
            int centerChunkX = centerPos.getX() >> 4;
            int centerChunkZ = centerPos.getZ() >> 4;
            this.minChunkX = centerChunkX - chunkRadius;
            this.maxChunkX = centerChunkX + chunkRadius;
            this.minChunkZ = centerChunkZ - chunkRadius;
            this.maxChunkZ = centerChunkZ + chunkRadius;
            this.currentChunkX = this.minChunkX;
            this.currentChunkZ = this.minChunkZ;
        }

        public void preloadChunksAsync(ServerLevel sourceWorld, ServerLevel targetWorld) {
            if (this.completed) {
                return;
            }
            int preloadX = this.currentChunkX;
            int preloadZ = this.currentChunkZ;
            int chunksToPreload = 8;
            while (chunksToPreload > 0) {
                ChunkPos sourcePos = new ChunkPos(preloadX, preloadZ);
                sourceWorld.getChunkSource().addRegionTicket(MIRROR_PRELOAD_TICKET, sourcePos, 0, (Object)sourcePos);
                ChunkPos targetPos = new ChunkPos(preloadX, preloadZ);
                targetWorld.getChunkSource().addRegionTicket(MIRROR_PRELOAD_TICKET, targetPos, 0, (Object)targetPos);
                if (++preloadX > this.maxChunkX) {
                    preloadX = this.minChunkX;
                    if (++preloadZ > this.maxChunkZ) break;
                }
                --chunksToPreload;
                ++this.preloadedChunks;
            }
            this.preloadingStarted = true;
        }

        public int getTotalChunks() {
            int width = this.maxChunkX - this.minChunkX + 1;
            int height = this.maxChunkZ - this.minChunkZ + 1;
            return width * height;
        }

        public int getCopiedChunks() {
            if (!this.started) {
                return 0;
            }
            if (this.completed) {
                return this.getTotalChunks();
            }
            int width = this.maxChunkX - this.minChunkX + 1;
            return (this.currentChunkZ - this.minChunkZ) * width + (this.currentChunkX - this.minChunkX);
        }

        public int getProgressPercent() {
            int total = this.getTotalChunks();
            if (total == 0) {
                return 100;
            }
            return this.getCopiedChunks() * 100 / total;
        }

        public int[] getNextChunk() {
            int[] result;
            if (this.completed) {
                return null;
            }
            this.started = true;
            int[] nArray = result = new int[]{this.currentChunkX++, this.currentChunkZ++};
            if (this.currentChunkX > this.maxChunkX) {
                this.currentChunkX = this.minChunkX;
                if (this.currentChunkZ > this.maxChunkZ) {
                    this.completed = true;
                }
            }
            return result;
        }

        public void addBlocksCopied(int count) {
            this.totalBlocksCopied += count;
        }

        public boolean isCompleted() {
            return this.completed;
        }

        public boolean isCancelled() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
            this.completed = true;
        }

        public int getTotalBlocksCopied() {
            return this.totalBlocksCopied;
        }

        public boolean isPreloadingStarted() {
            return this.preloadingStarted;
        }
    }

    public static class CleanupTask {
        public final int dimensionIndex;
        private final List<long[]> chunksToClean = new ArrayList<long[]>();
        private int currentIndex = 0;
        private boolean initialized = false;
        private boolean completed = false;
        private int saveCounter = 0;
        private static final int SAVE_INTERVAL = 10;
        private boolean mainCleanupComplete = false;
        private boolean auxiliaryCleanupStarted = false;
        private boolean auxiliaryBfsScanComplete = false;
        private List<long[]> auxiliaryChunks = new ArrayList<long[]>();
        private int auxiliaryIndex = 0;
        private Queue<long[]> bfsQueue = new LinkedList<long[]>();
        private Set<Long> bfsProcessed = new HashSet<Long>();
        private int bfsCenterX;
        private int bfsCenterZ;
        private int bfsMaxRadius;
        private int bfsChunksScanned = 0;
        private static final int BFS_CHUNKS_PER_TICK = 20;
        private boolean auxiliaryCleanupComplete = false;
        private boolean regionScanStarted = false;
        private boolean regionScanInitialized = false;
        private boolean regionScanComplete = false;
        private List<long[]> regionScanChunks = new ArrayList<long[]>();
        private int regionScanIndex = 0;
        private int regionScanPass = 0;
        private static final int MAX_REGION_SCAN_PASSES = 5;
        private List<Long> regionChunksToCheck = new ArrayList<Long>();
        private int regionCheckIndex = 0;
        private Set<Long> regionProcessedChunks = new HashSet<Long>();
        private static final int REGION_CHUNKS_PER_TICK = 200;
        private final Queue<long[]> retryQueue = new LinkedList<long[]>();
        private final Map<Long, Integer> retryCount = new HashMap<Long, Integer>();
        private static final int MAX_RETRIES = 50;
        private int skippedChunks = 0;

        public CleanupTask(int dimensionIndex) {
            this.dimensionIndex = dimensionIndex;
        }

        public void initializeChunkList(ServerLevel mirrorWorld) {
            if (this.initialized) {
                return;
            }
            this.initialized = true;
            HashSet<Long> allChunksToClean = new HashSet<Long>();
            BlockPos savedCenter = DimensionPool.getSavedCopyCenter(this.dimensionIndex);
            Set<Long> savedChunks = DimensionPool.getSavedModifiedChunks(this.dimensionIndex);
            int savedProgress = DimensionPool.getSavedCleanupProgress(this.dimensionIndex);
            BlockPos centerPos = copyCenterPositions.get(this.dimensionIndex);
            if (centerPos == null) {
                centerPos = savedCenter;
            }
            int copyRadius = (Integer)MirrorConfig.COPY_CHUNK_RADIUS.get();
            if (centerPos != null) {
                int centerChunkX = centerPos.getX() >> 4;
                int centerChunkZ = centerPos.getZ() >> 4;
                for (int x = centerChunkX - copyRadius; x <= centerChunkX + copyRadius; ++x) {
                    for (int z = centerChunkZ - copyRadius; z <= centerChunkZ + copyRadius; ++z) {
                        allChunksToClean.add(WorldCopyService.packChunkPos(x, z));
                    }
                }
            }
            Set<Long> tracked = WorldCopyService.getModifiedChunks(this.dimensionIndex);
            int additionalChunks = 0;
            for (Long packed : tracked) {
                if (!allChunksToClean.add(packed)) continue;
                ++additionalChunks;
            }
            int restoredChunks = 0;
            for (Long packed : savedChunks) {
                if (!allChunksToClean.add(packed)) continue;
                ++restoredChunks;
            }
            for (Long packed : allChunksToClean) {
                this.chunksToClean.add(new long[]{WorldCopyService.unpackChunkX(packed), WorldCopyService.unpackChunkZ(packed)});
            }
            if (savedProgress > 0 && savedProgress < this.chunksToClean.size()) {
                this.currentIndex = savedProgress;
            }
            InstantWorldMirror.LOGGER.debug("Cleanup initialized for dimension {}: {} chunks", (Object)this.dimensionIndex, (Object)this.chunksToClean.size());
        }

        public int getTotalChunks() {
            return this.chunksToClean.size() + this.auxiliaryChunks.size() + this.regionScanChunks.size();
        }

        public int getCleanedChunks() {
            return this.currentIndex + this.auxiliaryIndex + this.regionScanIndex;
        }

        public List<long[]> getAllCleanedChunks() {
            ArrayList<long[]> all = new ArrayList<long[]>(this.chunksToClean);
            all.addAll(this.auxiliaryChunks);
            all.addAll(this.regionScanChunks);
            return all;
        }

        public boolean isMainCleanupDone() {
            return this.mainCleanupComplete;
        }

        public boolean isAuxiliaryCleanupDone() {
            return this.auxiliaryCleanupComplete;
        }

        public boolean needsRegionScan() {
            return this.auxiliaryCleanupComplete && !this.regionScanStarted;
        }

        public boolean isBfsScanInProgress() {
            return this.auxiliaryCleanupStarted && !this.auxiliaryBfsScanComplete;
        }

        public boolean isRegionScanInProgress() {
            return this.regionScanStarted && !this.regionScanInitialized;
        }

        public long[] getNextChunk() {
            if (!this.mainCleanupComplete) {
                if (this.currentIndex >= this.chunksToClean.size()) {
                    this.mainCleanupComplete = true;
                    return null;
                }
                long[] result = this.chunksToClean.get(this.currentIndex++);
                ++this.saveCounter;
                if (this.saveCounter >= 10) {
                    this.saveCounter = 0;
                    this.saveProgress();
                }
                return result;
            }
            if (!this.auxiliaryCleanupComplete) {
                if (!this.auxiliaryCleanupStarted) {
                    return null;
                }
                if (!this.auxiliaryBfsScanComplete) {
                    return null;
                }
                if (this.auxiliaryIndex >= this.auxiliaryChunks.size()) {
                    if (!this.retryQueue.isEmpty()) {
                        return this.retryQueue.poll();
                    }
                    this.auxiliaryCleanupComplete = true;
                    return null;
                }
                return this.auxiliaryChunks.get(this.auxiliaryIndex++);
            }
            if (!this.regionScanComplete) {
                if (!this.regionScanStarted) {
                    return null;
                }
                if (this.regionScanIndex >= this.regionScanChunks.size()) {
                    if (!this.retryQueue.isEmpty()) {
                        return this.retryQueue.poll();
                    }
                    if (this.regionScanChunks.isEmpty() || this.regionScanPass >= 5) {
                        this.regionScanComplete = true;
                        this.completed = true;
                        if (this.skippedChunks > 0) {
                            InstantWorldMirror.LOGGER.warn("Cleanup completed for dimension {} but {} chunks were skipped", (Object)this.dimensionIndex, (Object)this.skippedChunks);
                        }
                        return null;
                    }
                    this.regionScanStarted = false;
                    return null;
                }
                return this.regionScanChunks.get(this.regionScanIndex++);
            }
            return null;
        }

        public void markForRetry(int chunkX, int chunkZ) {
            long key = WorldCopyService.packChunkPos(chunkX, chunkZ);
            int count = this.retryCount.getOrDefault(key, 0) + 1;
            if (count <= 50) {
                this.retryCount.put(key, count);
                this.retryQueue.offer(new long[]{chunkX, chunkZ});
            } else {
                ++this.skippedChunks;
                InstantWorldMirror.LOGGER.debug("Skipping cleanup of chunk [{}, {}] after {} retries", new Object[]{chunkX, chunkZ, 50});
            }
        }

        public int getSkippedChunks() {
            return this.skippedChunks;
        }

        public int initializeAuxiliaryCleanup(ServerLevel mirrorWorld) {
            if (this.auxiliaryCleanupStarted) {
                return this.auxiliaryChunks.size();
            }
            this.auxiliaryCleanupStarted = true;
            int maxExpansionRadius = (Integer)MirrorConfig.EDGE_CLEANUP_RADIUS.get();
            if (maxExpansionRadius <= 0) {
                this.auxiliaryBfsScanComplete = true;
                this.auxiliaryCleanupComplete = true;
                this.regionScanStarted = true;
                this.regionScanComplete = true;
                this.completed = true;
                return 0;
            }
            this.bfsProcessed = new HashSet<Long>();
            for (long[] chunk : this.chunksToClean) {
                this.bfsProcessed.add(WorldCopyService.packChunkPos((int)chunk[0], (int)chunk[1]));
            }
            int minChunkX = Integer.MAX_VALUE;
            int maxChunkX = Integer.MIN_VALUE;
            int minChunkZ = Integer.MAX_VALUE;
            int maxChunkZ = Integer.MIN_VALUE;
            for (long[] chunk : this.chunksToClean) {
                int cx = (int)chunk[0];
                int cz = (int)chunk[1];
                minChunkX = Math.min(minChunkX, cx);
                maxChunkX = Math.max(maxChunkX, cx);
                minChunkZ = Math.min(minChunkZ, cz);
                maxChunkZ = Math.max(maxChunkZ, cz);
            }
            this.bfsCenterX = (minChunkX + maxChunkX) / 2;
            this.bfsCenterZ = (minChunkZ + maxChunkZ) / 2;
            int baseRadius = Math.max(maxChunkX - this.bfsCenterX, maxChunkZ - this.bfsCenterZ);
            this.bfsMaxRadius = baseRadius + maxExpansionRadius;
            this.bfsQueue = new LinkedList<long[]>();
            for (int cx = minChunkX - 1; cx <= maxChunkX + 1; ++cx) {
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx, minChunkZ - 1);
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx, maxChunkZ + 1);
            }
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, minChunkX - 1, cz);
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, maxChunkX + 1, cz);
            }
            this.bfsChunksScanned = 0;
            return 0;
        }

        public boolean processBfsIncremental(ServerLevel mirrorWorld) {
            if (this.auxiliaryBfsScanComplete) {
                return false;
            }
            for (int processedThisTick = 0; !this.bfsQueue.isEmpty() && processedThisTick < 20; ++processedThisTick) {
                long[] current = this.bfsQueue.poll();
                int cx = (int)current[0];
                int cz = (int)current[1];
                ++this.bfsChunksScanned;
                if (!WorldCopyService.hasBlocksInChunk(mirrorWorld, cx, cz)) continue;
                this.auxiliaryChunks.add(current);
                int distFromCenter = Math.max(Math.abs(cx - this.bfsCenterX), Math.abs(cz - this.bfsCenterZ));
                if (distFromCenter >= this.bfsMaxRadius) continue;
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx - 1, cz);
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx + 1, cz);
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx, cz - 1);
                this.addToQueueIfNew(this.bfsQueue, this.bfsProcessed, cx, cz + 1);
            }
            if (this.bfsQueue.isEmpty()) {
                this.auxiliaryBfsScanComplete = true;
                if (this.auxiliaryChunks.isEmpty()) {
                    this.auxiliaryCleanupComplete = true;
                }
                return false;
            }
            return true;
        }

        public int initializeRegionScan(ServerLevel mirrorWorld) {
            if (this.regionScanStarted && this.regionScanInitialized) {
                return this.regionScanChunks.size();
            }
            this.regionScanStarted = true;
            ++this.regionScanPass;
            this.regionScanChunks.clear();
            this.regionScanIndex = 0;
            this.regionCheckIndex = 0;
            this.regionChunksToCheck.clear();
            this.regionProcessedChunks = new HashSet<Long>();
            for (long[] chunk : this.chunksToClean) {
                this.regionProcessedChunks.add(WorldCopyService.packChunkPos((int)chunk[0], (int)chunk[1]));
            }
            for (long[] chunk : this.auxiliaryChunks) {
                this.regionProcessedChunks.add(WorldCopyService.packChunkPos((int)chunk[0], (int)chunk[1]));
            }
            Set<Long> regionChunks = WorldCopyService.scanRegionFilesForChunks(mirrorWorld);
            if (regionChunks.isEmpty()) {
                this.regionScanInitialized = true;
                this.regionScanComplete = true;
                this.completed = true;
                return 0;
            }
            for (Long packed : regionChunks) {
                if (this.regionProcessedChunks.contains(packed)) continue;
                this.regionChunksToCheck.add(packed);
            }
            if (this.regionChunksToCheck.isEmpty()) {
                this.regionScanInitialized = true;
                this.regionScanComplete = true;
                this.completed = true;
                return 0;
            }
            return 0;
        }

        public boolean processRegionScanIncremental(ServerLevel mirrorWorld) {
            if (this.regionScanInitialized) {
                return false;
            }
            int processedThisTick = 0;
            int chunksWithBlocks = 0;
            while (this.regionCheckIndex < this.regionChunksToCheck.size() && processedThisTick < 200) {
                int cz;
                Long packed = this.regionChunksToCheck.get(this.regionCheckIndex++);
                ++processedThisTick;
                int cx = WorldCopyService.unpackChunkX(packed);
                if (!WorldCopyService.hasBlocksInChunk(mirrorWorld, cx, cz = WorldCopyService.unpackChunkZ(packed))) continue;
                this.regionScanChunks.add(new long[]{cx, cz});
                ++chunksWithBlocks;
                this.regionProcessedChunks.add(packed);
            }
            if (this.regionCheckIndex >= this.regionChunksToCheck.size()) {
                this.regionScanInitialized = true;
                if (this.regionScanChunks.isEmpty()) {
                    this.regionScanComplete = true;
                    this.completed = true;
                }
                return false;
            }
            return true;
        }

        private void addToQueueIfNew(Queue<long[]> queue, Set<Long> processed, int cx, int cz) {
            long packed = WorldCopyService.packChunkPos(cx, cz);
            if (processed.add(packed)) {
                queue.add(new long[]{cx, cz});
            }
        }

        public void saveProgress() {
            BlockPos centerPos = copyCenterPositions.get(this.dimensionIndex);
            Set<Long> chunks = WorldCopyService.getModifiedChunks(this.dimensionIndex);
            HashSet<Long> allChunks = new HashSet<Long>();
            for (long[] chunk : this.chunksToClean) {
                allChunks.add(WorldCopyService.packChunkPos((int)chunk[0], (int)chunk[1]));
            }
            allChunks.addAll(chunks);
            DimensionPool.saveCleanupData(this.dimensionIndex, centerPos, allChunks, this.currentIndex);
        }

        public boolean isCompleted() {
            return this.completed;
        }
    }
}

