/*
 * Decompiled with CFR 0.152.
 */
package com.crabmods.instantworldmirror.world.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class MirrorChunkGenerator
extends ChunkGenerator {
    public static final MapCodec<MirrorChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.CODEC.fieldOf("biome").forGetter(gen -> gen.biome)).apply((Applicative)instance, MirrorChunkGenerator::new));
    private final Holder<Biome> biome;

    public MirrorChunkGenerator(Holder<Biome> biome) {
        super((BiomeSource)new FixedBiomeSource(biome));
        this.biome = biome;
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion level, long seed, RandomState random, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunk, GenerationStep.Carving step) {
    }

    public void buildSurface(WorldGenRegion level, StructureManager structureManager, RandomState random, ChunkAccess chunk) {
    }

    public void spawnOriginalMobs(WorldGenRegion level) {
    }

    public int getGenDepth() {
        return 384;
    }

    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState random, StructureManager structureManager, ChunkAccess chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public int getSeaLevel() {
        return 63;
    }

    public int getMinY() {
        return -64;
    }

    public int getBaseHeight(int x, int z, Heightmap.Types type, LevelHeightAccessor level, RandomState random) {
        return level.getMinBuildHeight();
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState random) {
        return new NoiseColumn(level.getMinBuildHeight(), new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> info, RandomState random, BlockPos pos) {
        info.add("Mirror World Generator");
    }
}

