/*
 * Decompiled with CFR 0.152.
 */
package com.bizcub.inventoryItemGroups.mixin;

import com.bizcub.inventoryItemGroups.Group;
import com.bizcub.inventoryItemGroups.Main;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerScreen.class})
public class AbstractContainerScreenMixin<T extends AbstractContainerMenu> {
    @Shadow
    @Final
    protected T menu;

    @Unique
    private static boolean iig$onScreen(Slot slot) {
        return slot.index <= 44;
    }

    @Unique
    private int iig$calculateIndex(Slot slot) {
        int index = 0;
        NonNullList slots = ((AbstractContainerMenu)this.menu).slots;
        if (!slots.isEmpty() && slots.size() > 1 && slots.get(0) != slots.get(1)) {
            index = Main.tempInventoryItemStack.indexOf(((Slot)slots.get(1)).getItem()) - 1;
        }
        return index + slot.index;
    }

    @Unique
    private ResourceLocation iig$getSprite(String location) {
        String id = "inventory_item_groups";
        String path = "container/" + location;
        return ResourceLocation.fromNamespaceAndPath((String)id, (String)path);
    }

    @Unique
    private void iig$renderSprite(GuiGraphics guiGraphics, String location, int x, int y, int size) {
        RenderSystem.disableDepthTest();
        guiGraphics.blitSprite(this.iig$getSprite(location), x, y, size, size);
        RenderSystem.enableDepthTest();
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="HEAD")})
    private void renderSlotSprites(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        ArrayList<Group> groupsOnSelectedTab = Main.groupsOnSelectedTab(Main.tempSelectedTab);
        int index = this.iig$calculateIndex(slot);
        for (Group group : groupsOnSelectedTab) {
            if (!AbstractContainerScreenMixin.iig$onScreen(slot) || !group.isVisibility()) continue;
            if (group.getIconIndex() == index) {
                this.iig$renderSprite(guiGraphics, "icon_slot", slot.x - 1, slot.y - 1, 18);
            }
            for (String str : group.getItems()) {
                if (group.getItemsWithIndexes().get(str) != index) continue;
                this.iig$renderSprite(guiGraphics, "item_slot", slot.x - 1, slot.y - 1, 18);
            }
        }
    }

    @Inject(method={"renderSlot(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/world/inventory/Slot;)V"}, at={@At(value="TAIL")})
    private void renderVisibilitySprites(GuiGraphics guiGraphics, Slot slot, CallbackInfo ci) {
        ArrayList<Group> groupsOnSelectedTab = Main.groupsOnSelectedTab(Main.tempSelectedTab);
        int index = this.iig$calculateIndex(slot);
        for (Group group : groupsOnSelectedTab) {
            if (!AbstractContainerScreenMixin.iig$onScreen(slot) || group.getIconIndex() != index) continue;
            if (group.isVisibility()) {
                this.iig$renderSprite(guiGraphics, "minus", slot.x, slot.y, 16);
                continue;
            }
            this.iig$renderSprite(guiGraphics, "plus", slot.x, slot.y, 16);
        }
    }
}

