/*
 * Decompiled with CFR 0.152.
 */
package com.bizcub.inventoryItemGroups.mixin;

import com.bizcub.inventoryItemGroups.Group;
import com.bizcub.inventoryItemGroups.Main;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={CreativeModeInventoryScreen.class})
public class CreativeModeInventoryScreenMixin
extends Screen {
    @Shadow
    private float scrollOffs;
    @Shadow
    private static CreativeModeTab selectedTab;
    @Unique
    private static Slot iig$clickedSlot;

    protected CreativeModeInventoryScreenMixin(Component component) {
        super(component);
    }

    @Unique
    private int iig$indexCalculation(int inventorySize, int slotIndex) {
        float rows = (float)inventorySize / 9.0f;
        rows = (float)Math.ceil(rows);
        int index = 0;
        if (inventorySize > 45 && (index = Math.round((rows - 5.0f) * this.scrollOffs)) > 0) {
            index *= 9;
        }
        return index + slotIndex;
    }

    @Unique
    private void iig$mouseButtonsFix(CreativeModeInventoryScreen.ItemPickerMenu instance, ItemStack itemStack) {
        int index = this.iig$indexCalculation(Main.tempInventoryItemStack.size(), CreativeModeInventoryScreenMixin.iig$clickedSlot.index);
        Group group = Main.findGroupByIndex(index);
        if (group != null && selectedTab == Main.tabsMapping.get(group.getTab()) && group.getIconIndex() == index) {
            instance.setCarried(ItemStack.EMPTY);
            Main.itemsChanged(index);
        } else {
            instance.setCarried(itemStack);
        }
    }

    @Inject(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen$ItemPickerMenu;setCarried(Lnet/minecraft/world/item/ItemStack;)V", ordinal=4)})
    private void slotClicked(Slot slot, int i, int j, ClickType clickType, CallbackInfo ci) {
        iig$clickedSlot = slot;
    }

    @Redirect(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen$ItemPickerMenu;setCarried(Lnet/minecraft/world/item/ItemStack;)V", ordinal=4))
    private void mouseButtonsFix(CreativeModeInventoryScreen.ItemPickerMenu instance, ItemStack itemStack) {
        this.iig$mouseButtonsFix(instance, itemStack);
    }

    @Inject(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen$ItemPickerMenu;setCarried(Lnet/minecraft/world/item/ItemStack;)V", ordinal=2)})
    private void getSlot(Slot slot, int i, int j, ClickType clickType, CallbackInfo ci) {
        iig$clickedSlot = slot;
    }

    @Redirect(method={"slotClicked(Lnet/minecraft/world/inventory/Slot;IILnet/minecraft/world/inventory/ClickType;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/screens/inventory/CreativeModeInventoryScreen$ItemPickerMenu;setCarried(Lnet/minecraft/world/item/ItemStack;)V", ordinal=2))
    private void mouseMiddleButtonFix(CreativeModeInventoryScreen.ItemPickerMenu instance, ItemStack itemStack) {
        this.iig$mouseButtonsFix(instance, itemStack);
    }

    @Inject(method={"mouseReleased(DDI)Z"}, at={@At(value="RETURN")})
    private void removeTexturesDisplay(CallbackInfoReturnable<Boolean> cir) {
        if (selectedTab.getType() != CreativeModeTab.Type.CATEGORY) {
            Main.groups.clear();
        }
    }

    @Redirect(method={"selectTab(Lnet/minecraft/world/item/CreativeModeTab;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/CreativeModeTab;getDisplayItems()Ljava/util/Collection;"))
    private Collection<ItemStack> groupsImplementation(CreativeModeTab instance) {
        Main.createMapping();
        Main.createDefaultGroups();
        ArrayList<Group> groupsOnSelectedTab = Main.groupsOnSelectedTab(selectedTab);
        ArrayList<ItemStack> newStack = new ArrayList<ItemStack>(instance.getDisplayItems());
        ArrayList<String> removeItems = new ArrayList<String>();
        for (Group group : groupsOnSelectedTab) {
            removeItems.addAll(group.getItems());
            removeItems.remove(group.getIcon());
        }
        for (int i = 0; i < newStack.size(); ++i) {
            String name = ((ItemStack)newStack.get(i)).getItem().toString();
            for (String item : removeItems) {
                if (!name.equals(item)) continue;
                newStack.remove(i);
                --i;
            }
        }
        Main.tempSelectedTab = selectedTab;
        Main.tempInventoryItemStack = newStack;
        Main.hideGroups();
        Main.setIndexes();
        return newStack;
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;IIF)V"}, at={@At(value="HEAD")})
    private void getScrollOffs(CallbackInfo ci) {
        Main.tempScrollOffs = this.scrollOffs;
    }

    public void onClose() {
        Main.groups.clear();
        super.onClose();
    }
}

