/*
 * Decompiled with CFR 0.152.
 */
package com.bizcub.inventoryItemGroups;

import com.bizcub.inventoryItemGroups.Main;
import java.util.ArrayList;
import java.util.HashMap;

public class Group {
    private final String tab;
    private final HashMap<String, Integer> icon = new HashMap();
    private final HashMap<String, Integer> items = new HashMap();
    private boolean visibility;

    public Group(String tab, ArrayList<String> items) {
        this.tab = tab;
        this.visibility = false;
        items = Main.sortList(this.removeDuplicates(items));
        if (!items.isEmpty()) {
            this.icon.put(items.get(0), -1);
            for (String str : items) {
                this.items.put(str, -1);
            }
        }
    }

    public ArrayList<String> removeDuplicates(ArrayList<String> list) {
        ArrayList<Group> groupsOnSelectedTab = Main.groupsOnSelectedTab(Main.tabsMapping.get(this.tab));
        groupsOnSelectedTab.forEach(group -> list.removeAll(group.getItems()));
        return list;
    }

    public String getTab() {
        return this.tab;
    }

    public ArrayList<String> getItems() {
        return Main.sortList(new ArrayList<String>(this.items.keySet()));
    }

    public HashMap<String, Integer> getItemsWithIndexes() {
        return this.items;
    }

    public void setItemWithIndex(String item, int index) {
        this.items.put(item, index);
    }

    public boolean isVisibility() {
        return this.visibility;
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public String getIcon() {
        return (String)this.icon.keySet().stream().toList().get(0);
    }

    public int getIconIndex() {
        return this.icon.get(this.getIcon());
    }

    public void setIconIndex(int index) {
        this.icon.put(this.getIcon(), index);
    }
}

