/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelirradiated<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_wasteland_reworked", (String)"modelirradiated"), "main");
    public final ModelPart body;
    public final ModelPart backpack;
    public final ModelPart pipe;
    public final ModelPart left_leg;
    public final ModelPart right_leg;
    public final ModelPart left_arm;
    public final ModelPart right_arm;
    public final ModelPart head;

    public Modelirradiated(ModelPart root) {
        this.body = root.getChild("body");
        this.backpack = this.body.getChild("backpack");
        this.pipe = this.backpack.getChild("pipe");
        this.left_leg = root.getChild("left_leg");
        this.right_leg = root.getChild("right_leg");
        this.left_arm = root.getChild("left_arm");
        this.right_arm = root.getChild("right_arm");
        this.head = root.getChild("head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition backpack = body.addOrReplaceChild("backpack", CubeListBuilder.create().texOffs(32, 16).addBox(-3.5f, -4.0f, 0.0f, 7.0f, 13.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-10.0f, (float)2.0f));
        PartDefinition pipe = backpack.addOrReplaceChild("pipe", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)22.0f, (float)-2.0f));
        PartDefinition pipe_3_r1 = pipe.addOrReplaceChild("pipe_3_r1", CubeListBuilder.create().texOffs(-1, 54).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-14.0f, (float)6.5f, (float)1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition pipe_2_r1 = pipe.addOrReplaceChild("pipe_2_r1", CubeListBuilder.create().texOffs(-1, 54).addBox(-4.0f, 0.0f, 0.0f, 9.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-14.0f, (float)1.5f, (float)0.0f, (float)-1.5708f, (float)2.3562f));
        PartDefinition pipe_1_r1 = pipe.addOrReplaceChild("pipe_1_r1", CubeListBuilder.create().texOffs(-1, 54).addBox(-4.0f, 0.0f, 0.0f, 4.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)4.0f, (float)-14.0f, (float)-2.5f, (float)1.5708f, (float)0.0f, (float)0.7854f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 38).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)2.0f, (float)12.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(32, 33).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)4.0f, (float)2.0f, (float)0.0f));
        PartDefinition left_arm_r1 = left_arm.addOrReplaceChild("left_arm_r1", CubeListBuilder.create().texOffs(16, 38).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)-4.0f, (float)2.0f, (float)0.0f));
        PartDefinition right_arm_r1 = right_arm.addOrReplaceChild("right_arm_r1", CubeListBuilder.create().texOffs(48, 33).addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 14.0f, 8.0f, new CubeDeformation(0.5f)).texOffs(0, 22).addBox(-4.0f, -7.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

