/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelirradipede<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_wasteland_reworked", (String)"modelirradipede"), "main");
    public final ModelPart head;
    public final ModelPart body;
    public final ModelPart left_antenna;
    public final ModelPart right_antenna;
    public final ModelPart right_leg_1;
    public final ModelPart right_leg_2;
    public final ModelPart right_leg_3;
    public final ModelPart left_leg_1;
    public final ModelPart left_leg_2;
    public final ModelPart left_leg_3;
    public final ModelPart left_wing;
    public final ModelPart right_wing;

    public Modelirradipede(ModelPart root) {
        this.head = root.getChild("head");
        this.body = root.getChild("body");
        this.left_antenna = root.getChild("left_antenna");
        this.right_antenna = root.getChild("right_antenna");
        this.right_leg_1 = root.getChild("right_leg_1");
        this.right_leg_2 = root.getChild("right_leg_2");
        this.right_leg_3 = root.getChild("right_leg_3");
        this.left_leg_1 = root.getChild("left_leg_1");
        this.left_leg_2 = root.getChild("left_leg_2");
        this.left_leg_3 = root.getChild("left_leg_3");
        this.left_wing = root.getChild("left_wing");
        this.right_wing = root.getChild("right_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(24, 48).addBox(-3.0f, -2.0f, -4.0f, 6.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-5.0f));
        PartDefinition body = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(1, 0).addBox(-5.0f, -3.0f, 0.0f, 10.0f, 4.0f, 14.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)22.0f, (float)-5.0f));
        PartDefinition left_antenna = partdefinition.addOrReplaceChild("left_antenna", CubeListBuilder.create().texOffs(52, 0).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.0f, (float)20.0f, (float)-8.0f, (float)0.3604f, (float)0.2457f, (float)0.0914f));
        PartDefinition right_antenna = partdefinition.addOrReplaceChild("right_antenna", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)20.0f, (float)-9.0f));
        PartDefinition right_antenna_r1 = right_antenna.addOrReplaceChild("right_antenna_r1", CubeListBuilder.create().texOffs(44, 48).addBox(0.0f, -5.0f, -1.0f, 0.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)1.0f, (float)0.3604f, (float)-0.2457f, (float)-0.0914f));
        PartDefinition right_leg_1 = partdefinition.addOrReplaceChild("right_leg_1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-6.0f, (float)22.0f, (float)-3.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition right_leg_1_r1 = right_leg_1.addOrReplaceChild("right_leg_1_r1", CubeListBuilder.create().texOffs(46, 24).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition right_leg_2 = partdefinition.addOrReplaceChild("right_leg_2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-6.0f, (float)22.0f, (float)2.0f, (float)0.0f, (float)0.0873f, (float)0.0f));
        PartDefinition right_leg_2_r1 = right_leg_2.addOrReplaceChild("right_leg_2_r1", CubeListBuilder.create().texOffs(0, 48).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.2618f, (float)-0.3491f));
        PartDefinition right_leg_3 = partdefinition.addOrReplaceChild("right_leg_3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-6.0f, (float)22.0f, (float)7.0f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition right_leg_3_r1 = right_leg_3.addOrReplaceChild("right_leg_3_r1", CubeListBuilder.create().texOffs(46, 30).addBox(-6.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3491f));
        PartDefinition left_leg_1 = partdefinition.addOrReplaceChild("left_leg_1", CubeListBuilder.create(), PartPose.offsetAndRotation((float)6.0f, (float)22.0f, (float)-3.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition left_leg_1_r1 = left_leg_1.addOrReplaceChild("left_leg_1_r1", CubeListBuilder.create().texOffs(46, 18).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.1745f, (float)0.3491f));
        PartDefinition left_leg_2 = partdefinition.addOrReplaceChild("left_leg_2", CubeListBuilder.create(), PartPose.offsetAndRotation((float)6.0f, (float)22.0f, (float)2.0f, (float)0.0f, (float)-0.0873f, (float)0.0f));
        PartDefinition left_leg_2_r1 = left_leg_2.addOrReplaceChild("left_leg_2_r1", CubeListBuilder.create().texOffs(46, 42).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.2618f, (float)0.3491f));
        PartDefinition left_leg_3 = partdefinition.addOrReplaceChild("left_leg_3", CubeListBuilder.create(), PartPose.offsetAndRotation((float)6.0f, (float)22.0f, (float)7.0f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        PartDefinition left_leg_3_r1 = left_leg_3.addOrReplaceChild("left_leg_3_r1", CubeListBuilder.create().texOffs(46, 36).addBox(0.0f, 0.0f, -3.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3491f));
        PartDefinition left_wing = partdefinition.addOrReplaceChild("left_wing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)-5.0f));
        PartDefinition left_wing_r1 = left_wing.addOrReplaceChild("left_wing_r1", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, 0.0f, 0.0f, 8.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0465f, (float)0.2577f, (float)0.1806f));
        PartDefinition right_wing = partdefinition.addOrReplaceChild("right_wing", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)18.0f, (float)-5.0f));
        PartDefinition right_wing_r1 = right_wing.addOrReplaceChild("right_wing_r1", CubeListBuilder.create().texOffs(0, 33).addBox(-7.0f, 0.0f, 0.0f, 8.0f, 0.0f, 15.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0465f, (float)-0.2577f, (float)-0.1806f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.body.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_antenna.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_antenna.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg_3.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg_1.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg_2.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg_3.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_wing.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_wing.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_leg_2.yRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.right_leg_3.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.right_leg_1.yRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
        this.left_leg_1.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_leg_2.yRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.left_leg_3.yRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
    }
}

