/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class Modelmutant<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"the_wasteland_reworked", (String)"modelmutant"), "main");
    public final ModelPart head;
    public final ModelPart torso;
    public final ModelPart right_arm;
    public final ModelPart left_arm;
    public final ModelPart right_leg;
    public final ModelPart left_leg;

    public Modelmutant(ModelPart root) {
        this.head = root.getChild("head");
        this.torso = root.getChild("torso");
        this.right_arm = root.getChild("right_arm");
        this.left_arm = root.getChild("left_arm");
        this.right_leg = root.getChild("right_leg");
        this.left_leg = root.getChild("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 36).addBox(-6.0f, -12.0f, -8.0f, 12.0f, 14.0f, 8.0f, new CubeDeformation(0.0f)).texOffs(64, 52).addBox(-6.0f, -12.0f, -8.25f, 12.0f, 14.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-14.0f, (float)-1.0f));
        PartDefinition left_hair_r1 = head.addOrReplaceChild("left_hair_r1", CubeListBuilder.create().texOffs(24, 60).mirror().addBox(0.0f, 0.0f, -4.0f, 0.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)6.0f, (float)-12.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)-0.1745f));
        PartDefinition right_hair_r1 = head.addOrReplaceChild("right_hair_r1", CubeListBuilder.create().texOffs(24, 60).addBox(0.0f, 0.0f, -4.0f, 0.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-6.0f, (float)-12.0f, (float)-4.0f, (float)0.0f, (float)0.0f, (float)0.1745f));
        PartDefinition torso = partdefinition.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 76).addBox(-9.0f, 2.0f, -5.0f, 18.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)).texOffs(0, 0).addBox(-9.0f, -24.0f, -5.0f, 18.0f, 26.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition right_arm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(40, 36).addBox(-6.0f, -4.0f, -3.0f, 6.0f, 28.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-9.0f, (float)-10.0f, (float)0.0f));
        PartDefinition left_arm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(56, 0).addBox(0.0f, -4.0f, -3.0f, 6.0f, 28.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)9.0f, (float)-10.0f, (float)0.0f));
        PartDefinition right_leg = partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 58).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-4.0f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(64, 34).addBox(-3.0f, 0.0f, -3.0f, 6.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.0f, (float)12.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.head.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.torso.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_arm.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.right_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.left_leg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.yRot = netHeadYaw / 57.295776f;
        this.head.xRot = headPitch / 57.295776f;
        this.right_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * limbSwingAmount;
        this.left_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * -1.0f * limbSwingAmount;
        this.left_arm.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * limbSwingAmount;
        this.right_leg.xRot = Mth.cos((float)(limbSwing * 1.0f)) * 1.0f * limbSwingAmount;
    }
}

