/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mcreator.thewastelandreworked.client.model.Modelmutant;
import net.mcreator.thewastelandreworked.client.model.Modelmutant_easter_egg_marco;
import net.mcreator.thewastelandreworked.entity.MutantEntity;
import net.mcreator.thewastelandreworked.procedures.MutantEasterEggMarcoConditionProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.definitions.WardenAnimation;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class MutantRenderer
extends MobRenderer<MutantEntity, Modelmutant<MutantEntity>> {
    public MutantRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new AnimatedModel(context.bakeLayer(Modelmutant.LAYER_LOCATION)), 0.6f);
        this.addLayer((RenderLayer)new RenderLayer<MutantEntity, Modelmutant<MutantEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"the_wasteland_reworked:textures/entities/mutant_eyes.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, MutantEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.eyes((ResourceLocation)this.LAYER_TEXTURE));
                Modelmutant model = new Modelmutant(Minecraft.getInstance().getEntityModels().bakeLayer(Modelmutant.LAYER_LOCATION));
                ((Modelmutant)this.getParentModel()).copyPropertiesTo(model);
                model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
            }
        });
        this.addLayer((RenderLayer)new RenderLayer<MutantEntity, Modelmutant<MutantEntity>>(this, (RenderLayerParent)this){
            final ResourceLocation LAYER_TEXTURE = ResourceLocation.parse((String)"the_wasteland_reworked:textures/entities/mutant_easter_egg_marco.png");

            public void render(PoseStack poseStack, MultiBufferSource bufferSource, int light, MutantEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
                Level world = entity.level();
                double x = entity.getX();
                double y = entity.getY();
                double z = entity.getZ();
                if (MutantEasterEggMarcoConditionProcedure.execute((Entity)entity)) {
                    VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.LAYER_TEXTURE));
                    Modelmutant_easter_egg_marco model = new Modelmutant_easter_egg_marco(Minecraft.getInstance().getEntityModels().bakeLayer(Modelmutant_easter_egg_marco.LAYER_LOCATION));
                    ((Modelmutant)this.getParentModel()).copyPropertiesTo(model);
                    model.prepareMobModel((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
                    model.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                    model.renderToBuffer(poseStack, vertexConsumer, light, LivingEntityRenderer.getOverlayCoords((LivingEntity)entity, (float)0.0f));
                }
            }
        });
    }

    public ResourceLocation getTextureLocation(MutantEntity entity) {
        return ResourceLocation.parse((String)"the_wasteland_reworked:textures/entities/mutant.png");
    }

    private static final class AnimatedModel
    extends Modelmutant<MutantEntity> {
        private final ModelPart root;
        private final HierarchicalModel animator = new HierarchicalModel<MutantEntity>(){

            public ModelPart root() {
                return root;
            }

            public void setupAnim(MutantEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
                this.root().getAllParts().forEach(ModelPart::resetPose);
                this.animate(entity.animationState0, WardenAnimation.WARDEN_ATTACK, ageInTicks, 1.0f);
            }
        };

        public AnimatedModel(ModelPart root) {
            super(root);
            this.root = root;
        }

        @Override
        public void setupAnim(MutantEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            this.animator.setupAnim((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            super.setupAnim(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

