/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.init;

import net.mcreator.thewastelandreworked.entity.CartridgeProjectileEntity;
import net.mcreator.thewastelandreworked.entity.FissileGrenadeProjectileEntity;
import net.mcreator.thewastelandreworked.entity.InfectedScientistEntity;
import net.mcreator.thewastelandreworked.entity.IrradiatedEntity;
import net.mcreator.thewastelandreworked.entity.IrradipedeEntity;
import net.mcreator.thewastelandreworked.entity.LightAmmoProjectileEntity;
import net.mcreator.thewastelandreworked.entity.MutantEntity;
import net.mcreator.thewastelandreworked.entity.WandererEntity;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TheWastelandReworkedModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"the_wasteland_reworked");
    public static final DeferredHolder<EntityType<?>, EntityType<IrradiatedEntity>> IRRADIATED = TheWastelandReworkedModEntities.register("irradiated", EntityType.Builder.of(IrradiatedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<IrradipedeEntity>> IRRADIPEDE = TheWastelandReworkedModEntities.register("irradipede", EntityType.Builder.of(IrradipedeEntity::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.8f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<FissileGrenadeProjectileEntity>> FISSILE_GRENADE_PROJECTILE = TheWastelandReworkedModEntities.register("fissile_grenade_projectile", EntityType.Builder.of(FissileGrenadeProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<LightAmmoProjectileEntity>> LIGHT_AMMO_PROJECTILE = TheWastelandReworkedModEntities.register("light_ammo_projectile", EntityType.Builder.of(LightAmmoProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<CartridgeProjectileEntity>> CARTRIDGE_PROJECTILE = TheWastelandReworkedModEntities.register("cartridge_projectile", EntityType.Builder.of(CartridgeProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.3f, 0.3f));
    public static final DeferredHolder<EntityType<?>, EntityType<InfectedScientistEntity>> INFECTED_SCIENTIST = TheWastelandReworkedModEntities.register("infected_scientist", EntityType.Builder.of(InfectedScientistEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<MutantEntity>> MUTANT = TheWastelandReworkedModEntities.register("mutant", EntityType.Builder.of(MutantEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(48).setUpdateInterval(3).sized(1.0f, 3.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<WandererEntity>> WANDERER = TheWastelandReworkedModEntities.register("wanderer", EntityType.Builder.of(WandererEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).sized(0.6f, 1.8f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        IrradiatedEntity.init(event);
        IrradipedeEntity.init(event);
        InfectedScientistEntity.init(event);
        MutantEntity.init(event);
        WandererEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)IRRADIATED.get(), IrradiatedEntity.createAttributes().build());
        event.put((EntityType)IRRADIPEDE.get(), IrradipedeEntity.createAttributes().build());
        event.put((EntityType)INFECTED_SCIENTIST.get(), InfectedScientistEntity.createAttributes().build());
        event.put((EntityType)MUTANT.get(), MutantEntity.createAttributes().build());
        event.put((EntityType)WANDERER.get(), WandererEntity.createAttributes().build());
    }
}

