/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.init;

import net.mcreator.thewastelandreworked.potion.IncubationMobEffect;
import net.mcreator.thewastelandreworked.potion.InfectionMobEffect;
import net.mcreator.thewastelandreworked.potion.RadiationImmunityMobEffect;
import net.mcreator.thewastelandreworked.potion.RadiationPoisoningMobEffect;
import net.mcreator.thewastelandreworked.potion.RadiationResistanceMobEffect;
import net.mcreator.thewastelandreworked.procedures.IncubationEffectExpiresProcedure;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.MobEffectEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

@EventBusSubscriber
public class TheWastelandReworkedModMobEffects {
    public static final DeferredRegister<MobEffect> REGISTRY = DeferredRegister.create((ResourceKey)Registries.MOB_EFFECT, (String)"the_wasteland_reworked");
    public static final DeferredHolder<MobEffect, MobEffect> RADIATION_RESISTANCE = REGISTRY.register("radiation_resistance", () -> new RadiationResistanceMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RADIATION_IMMUNITY = REGISTRY.register("radiation_immunity", () -> new RadiationImmunityMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> RADIATION_POISONING = REGISTRY.register("radiation_poisoning", () -> new RadiationPoisoningMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INFECTION = REGISTRY.register("infection", () -> new InfectionMobEffect());
    public static final DeferredHolder<MobEffect, MobEffect> INCUBATION = REGISTRY.register("incubation", () -> new IncubationMobEffect());

    @SubscribeEvent
    public static void onEffectRemoved(MobEffectEvent.Remove event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheWastelandReworkedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    @SubscribeEvent
    public static void onEffectExpired(MobEffectEvent.Expired event) {
        MobEffectInstance effectInstance = event.getEffectInstance();
        if (effectInstance != null) {
            TheWastelandReworkedModMobEffects.expireEffects((Entity)event.getEntity(), effectInstance);
        }
    }

    private static void expireEffects(Entity entity, MobEffectInstance effectInstance) {
        if (effectInstance.getEffect().is(INCUBATION)) {
            IncubationEffectExpiresProcedure.execute(entity);
        }
    }
}

