/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thewastelandreworked.procedures;

import net.mcreator.thewastelandreworked.TheWastelandReworkedMod;
import net.mcreator.thewastelandreworked.entity.CartridgeProjectileEntity;
import net.mcreator.thewastelandreworked.init.TheWastelandReworkedModEntities;
import net.mcreator.thewastelandreworked.init.TheWastelandReworkedModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class ShotgunShootProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if ((ShotgunShootProcedure.hasEntityInInventory(entity, new ItemStack((ItemLike)TheWastelandReworkedModItems.CARTRIDGE.get())) || ShotgunShootProcedure.getEntityGameType(entity) == GameType.CREATIVE) && world.getBlockState(BlockPos.containing((double)x, (double)y, (double)z)).getBlock() != Blocks.WATER) {
            Player _player;
            if (entity instanceof Player) {
                _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack.getItem(), 40);
            }
            if (ShotgunShootProcedure.getEntityGameType(entity) != GameType.CREATIVE) {
                if (entity instanceof Player) {
                    _player = (Player)entity;
                    ItemStack _stktoremove = new ItemStack((ItemLike)TheWastelandReworkedModItems.CARTRIDGE.get());
                    _player.getInventory().clearOrCountMatchingItems(p -> _stktoremove.getItem() == p.getItem(), 1, (Container)_player.inventoryMenu.getCraftSlots());
                }
                if (world instanceof ServerLevel) {
                    ServerLevel _level = (ServerLevel)world;
                    itemstack.hurtAndBreak(1, _level, null, _stkprov -> {});
                }
            }
            for (int index0 = 0; index0 < 16; ++index0) {
                Entity _shootFrom = entity;
                Level projectileLevel = _shootFrom.level();
                if (projectileLevel.isClientSide()) continue;
                AbstractArrow _entityToSpawn = ShotgunShootProcedure.initArrowProjectile(new CartridgeProjectileEntity((EntityType<? extends CartridgeProjectileEntity>)((EntityType)TheWastelandReworkedModEntities.CARTRIDGE_PROJECTILE.get()), projectileLevel), entity, 3.0f, true, false, false, AbstractArrow.Pickup.DISALLOWED);
                _entityToSpawn.setPos(_shootFrom.getX(), _shootFrom.getEyeY() - 0.1, _shootFrom.getZ());
                _entityToSpawn.shoot(_shootFrom.getLookAngle().x, _shootFrom.getLookAngle().y, _shootFrom.getLookAngle().z, 5.0f, 20.0f);
                projectileLevel.addFreshEntity((Entity)_entityToSpawn);
            }
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"the_wasteland_reworked:shotgun.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"the_wasteland_reworked:shotgun.shoot")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                }
            }
            world.addParticle((ParticleOptions)ParticleTypes.FLASH, x, y, z, 0.0, 0.0, 0.0);
            TheWastelandReworkedMod.queueServerWork(16, () -> {
                if (world instanceof Level) {
                    Level _level = (Level)world;
                    if (!_level.isClientSide()) {
                        _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"the_wasteland_reworked:shotgun.reload")), SoundSource.NEUTRAL, 1.0f, 1.0f);
                    } else {
                        _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"the_wasteland_reworked:shotgun.reload")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
                    }
                }
            });
        } else if (world instanceof Level) {
            Level _level = (Level)world;
            if (!_level.isClientSide()) {
                _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stone_button.click_on")), SoundSource.NEUTRAL, 1.0f, 1.0f);
            } else {
                _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"block.stone_button.click_on")), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
            }
        }
    }

    private static boolean hasEntityInInventory(Entity entity, ItemStack itemstack) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.getInventory().contains(stack -> !stack.isEmpty() && ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemstack));
        }
        return false;
    }

    private static GameType getEntityGameType(Entity entity) {
        PlayerInfo playerInfo;
        Player player;
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            return serverPlayer.gameMode.getGameModeForPlayer();
        }
        if (entity instanceof Player && (player = (Player)entity).level().isClientSide() && (playerInfo = Minecraft.getInstance().getConnection().getPlayerInfo(player.getGameProfile().getId())) != null) {
            return playerInfo.getGameMode();
        }
        return null;
    }

    private static AbstractArrow initArrowProjectile(AbstractArrow entityToSpawn, Entity shooter, float damage, boolean silent, boolean fire, boolean particles, AbstractArrow.Pickup pickup) {
        entityToSpawn.setOwner(shooter);
        entityToSpawn.setBaseDamage((double)damage);
        if (silent) {
            entityToSpawn.setSilent(true);
        }
        if (fire) {
            entityToSpawn.igniteForSeconds(100.0f);
        }
        if (particles) {
            entityToSpawn.setCritArrow(true);
        }
        entityToSpawn.pickup = pickup;
        return entityToSpawn;
    }
}

