/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Register;
import io.github.mortuusars.envelope.command.argument.AddressArgument;
import io.github.mortuusars.envelope.util.DeferredSoundType;
import io.github.mortuusars.envelope.util.bugger.Bugger;
import io.github.mortuusars.envelope.world.block.PackageBlock;
import io.github.mortuusars.envelope.world.block.PackageBlockEntity;
import io.github.mortuusars.envelope.world.block.PaperBoxBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlockEntity;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlock;
import io.github.mortuusars.envelope.world.block.mailbox.MailboxBlockEntity;
import io.github.mortuusars.envelope.world.block.occupiable.Occupant;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.inventory.PackingMenu;
import io.github.mortuusars.envelope.world.inventory.PaybackPackingMenu;
import io.github.mortuusars.envelope.world.inventory.PaybackTagMenu;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.item.LetterAndQuillItem;
import io.github.mortuusars.envelope.world.item.LetterItem;
import io.github.mortuusars.envelope.world.item.MailboxBlockItem;
import io.github.mortuusars.envelope.world.item.PackageItem;
import io.github.mortuusars.envelope.world.item.PackingBoxItem;
import io.github.mortuusars.envelope.world.item.PaybackPackageItem;
import io.github.mortuusars.envelope.world.item.PaybackPackingBoxItem;
import io.github.mortuusars.envelope.world.item.PaybackTagItem;
import io.github.mortuusars.envelope.world.item.SealStampItem;
import io.github.mortuusars.envelope.world.item.SealedLetterItem;
import io.github.mortuusars.envelope.world.item.SealedPackageItem;
import io.github.mortuusars.envelope.world.item.component.Id;
import io.github.mortuusars.envelope.world.item.component.LetterAndQuillContent;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.component.seal.SealImpression;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import io.github.mortuusars.envelope.world.item.crafting.LetterCloningRecipe;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.entity.mail_service.payback_department.PaybackSubject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class Envelope {
    public static final String ID = "envelope";
    public static final Logger LOGGER = LogUtils.getLogger();

    public static void init() {
        Bugger.enabler = () -> Config.Server.SPEC.isLoaded() && (Boolean)Config.Server.DEBUG.get() != false;
        Blocks.init();
        BlockEntityTypes.init();
        PoiTypes.init();
        EntityTypes.init();
        Items.init();
        DataComponents.init();
        Stats.init();
        CriteriaTriggers.init();
        ItemSubPredicates.init();
        MenuTypes.init();
        RecipeSerializers.init();
        SoundEvents.init();
        ArgumentTypes.init();
    }

    public static ResourceLocation resource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)ID, (String)path);
    }

    public static boolean debug() {
        return (Boolean)Config.Server.DEBUG.get();
    }

    public static class Blocks {
        public static final Map<ResourceLocation, Supplier<PigeonholeBlock>> PIGEONHOLES = new HashMap<ResourceLocation, Supplier<PigeonholeBlock>>();
        public static final Supplier<PigeonholeBlock> OAK_PIGEONHOLE = Blocks.pigeonhole("oak", MapColor.WOOD);
        public static final Supplier<MailboxBlock> MAILBOX = Register.block("mailbox", () -> new MailboxBlock(BlockBehaviour.Properties.of().strength(4.0f).sound(SoundType.WOOD).mapColor(MapColor.WOOD)));
        public static final Supplier<PaperBoxBlock> PAPER_BOX = Register.block("paper_box", () -> new PaperBoxBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).ignitedByLava().strength(0.3f).sound(SoundTypes.PAPER).mapColor(MapColor.SAND)));
        public static final Supplier<PackageBlock> PACKAGE = Register.block("package", () -> new PackageBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).ignitedByLava().strength(0.4f).sound(SoundTypes.PAPER).mapColor(MapColor.SAND).noOcclusion()));
        public static final Supplier<PackageBlock> SEALED_PACKAGE = Register.block("sealed_package", () -> new PackageBlock(BlockBehaviour.Properties.of().pushReaction(PushReaction.DESTROY).ignitedByLava().strength(0.4f).sound(SoundTypes.PAPER).mapColor(MapColor.SAND).noOcclusion()));

        private static Supplier<PigeonholeBlock> pigeonhole(String type, MapColor color) {
            String id = type + "_pigeonhole";
            Supplier<PigeonholeBlock> block = Register.block(id, () -> new PigeonholeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)net.minecraft.world.level.block.Blocks.BEEHIVE).strength(2.0f).mapColor(color)));
            PIGEONHOLES.put(Envelope.resource(id), block);
            return block;
        }

        static void init() {
        }
    }

    public static class BlockEntityTypes {
        public static final Supplier<BlockEntityType<MailboxBlockEntity>> MAILBOX = Register.blockEntityType("mailbox", () -> Register.newBlockEntityType(MailboxBlockEntity::new, (Block)Blocks.MAILBOX.get()));
        public static final Supplier<BlockEntityType<PigeonholeBlockEntity>> PIGEONHOLE = Register.blockEntityType("pigeonhole", () -> Register.newBlockEntityType(PigeonholeBlockEntity::new, (Block[])BlockEntityTypes.getPigeonholeBlocks()));
        public static final Supplier<BlockEntityType<PackageBlockEntity>> PACKAGE = Register.blockEntityType("package", () -> Register.newBlockEntityType(PackageBlockEntity::new, Blocks.PACKAGE.get(), Blocks.SEALED_PACKAGE.get()));

        private static PigeonholeBlock[] getPigeonholeBlocks() {
            return (PigeonholeBlock[])Blocks.PIGEONHOLES.values().stream().map(Supplier::get).toArray(PigeonholeBlock[]::new);
        }

        static void init() {
        }
    }

    public static class PoiTypes {
        public static final ResourceKey<PoiType> PIGEONHOLE = ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)Envelope.resource("pigeonhole"));
        public static final ResourceKey<PoiType> MAILBOX = ResourceKey.create((ResourceKey)net.minecraft.core.registries.Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)Envelope.resource("mailbox"));

        static void init() {
            Register.poiType(PIGEONHOLE, 0, 1, PoiTypes::getPigeonholePoiBlockStates);
            Register.poiType(MAILBOX, 0, 1, PoiTypes::getMailboxPoiBlockStates);
        }

        private static Set<BlockState> getPigeonholePoiBlockStates() {
            return Blocks.PIGEONHOLES.values().stream().map(Supplier::get).map(b -> b.getStateDefinition().getPossibleStates()).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        private static Set<BlockState> getMailboxPoiBlockStates() {
            return Set.copyOf(Blocks.MAILBOX.get().getStateDefinition().getPossibleStates());
        }
    }

    public static class EntityTypes {
        public static final Supplier<EntityType<Pigeon>> PIGEON = Register.entityType("pigeon", Pigeon::new, MobCategory.CREATURE, true, builder -> builder.sized(0.65f, 0.85f).eyeHeight(0.59375f).passengerAttachments(new float[]{0.4625f}).clientTrackingRange(8));

        static void init() {
        }
    }

    public static class Items {
        public static final List<Supplier<BlockItem>> PIGEONHOLES = new ArrayList<Supplier<BlockItem>>();
        public static final Supplier<BlockItem> OAK_PIGEONHOLE = Items.pigeonhole("oak", Blocks.OAK_PIGEONHOLE);
        public static final Supplier<LetterAndQuillItem> LETTER_AND_QUILL = Register.item("letter_and_quill", () -> new LetterAndQuillItem(new Item.Properties().stacksTo(1)));
        public static final Supplier<LetterItem> LETTER = Register.item("letter", () -> new LetterItem(new Item.Properties()));
        public static final Supplier<SealedLetterItem> SEALED_LETTER = Register.item("sealed_letter", () -> new SealedLetterItem(new Item.Properties()));
        public static final Supplier<BlockItem> PAPER_BOX = Register.item("paper_box", () -> new BlockItem((Block)Blocks.PAPER_BOX.get(), new Item.Properties()));
        public static final Supplier<PackingBoxItem> PACKING_BOX = Register.item("packing_box", () -> new PackingBoxItem(new Item.Properties().stacksTo(1)));
        public static final Supplier<PackageItem> PACKAGE = Register.item("package", () -> new PackageItem(Blocks.PACKAGE.get(), new Item.Properties().stacksTo(1)));
        public static final Supplier<SealedPackageItem> SEALED_PACKAGE = Register.item("sealed_package", () -> new SealedPackageItem(Blocks.SEALED_PACKAGE.get(), new Item.Properties().stacksTo(1)));
        public static final Supplier<PaybackTagItem> PAYBACK_TAG = Register.item("payback_tag", () -> new PaybackTagItem(new Item.Properties()));
        public static final Supplier<PaybackPackingBoxItem> PAYBACK_PACKING_BOX = Register.item("payback_packing_box", () -> new PaybackPackingBoxItem(new Item.Properties().stacksTo(1)));
        public static final Supplier<PaybackPackageItem> PAYBACK_PACKAGE = Register.item("payback_package", () -> new PaybackPackageItem(new Item.Properties().stacksTo(1)));
        public static final Supplier<AddressTagItem> ADDRESS_TAG = Register.item("address_tag", () -> new AddressTagItem(new Item.Properties()));
        public static final Supplier<SealStampItem> SEAL_STAMP = Register.item("seal_stamp", () -> new SealStampItem(new Item.Properties().stacksTo(1)));
        public static final Supplier<SpawnEggItem> PIGEON_SPAWN_EGG = Register.item("pigeon_spawn_egg", () -> new SpawnEggItem(EntityTypes.PIGEON.get(), 6776705, 0xB8B8CB, new Item.Properties()));
        public static final Supplier<MailboxBlockItem> MAILBOX = Register.item("mailbox", () -> new MailboxBlockItem((Block)Blocks.MAILBOX.get(), new Item.Properties()));

        @NotNull
        private static Supplier<BlockItem> pigeonhole(String type, Supplier<PigeonholeBlock> block) {
            Supplier<BlockItem> item = Register.item(type + "_pigeonhole", () -> new BlockItem((Block)block.get(), new Item.Properties()));
            PIGEONHOLES.add(item);
            return item;
        }

        static void init() {
        }
    }

    public static class DataComponents {
        public static final DataComponentType<Address> ADDRESS = Register.dataComponentType("address", b -> b.persistent(Address.CODEC).networkSynchronized(Address.STREAM_CODEC));
        public static final DataComponentType<Id> MAIL_ID = Register.dataComponentType("mail_id", b -> b.persistent(Id.CODEC).networkSynchronized(Id.STREAM_CODEC));
        public static final DataComponentType<Address> MAIL_RECIPIENT = Register.dataComponentType("mail_recipient", b -> b.persistent(Address.CODEC).networkSynchronized(Address.STREAM_CODEC));
        public static final DataComponentType<RequestedPayback> MAIL_REQUESTED_PAYBACK = Register.dataComponentType("mail_requested_payback", b -> b.persistent(RequestedPayback.CODEC).networkSynchronized(RequestedPayback.STREAM_CODEC));
        public static final DataComponentType<DeliveryLog> MAIL_DELIVERY_LOG = Register.dataComponentType("mail_delivery_log", b -> b.persistent(DeliveryLog.CODEC).networkSynchronized(DeliveryLog.STREAM_CODEC));
        public static final DataComponentType<Unit> MAIL_RETURNED = Register.dataComponentType("mail_returned", b -> b.persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));
        public static final DataComponentType<Address> MAIL_SENDER = Register.dataComponentType("mail_sender", b -> b.persistent(Address.CODEC).networkSynchronized(Address.STREAM_CODEC));
        public static final DataComponentType<LetterAndQuillContent> LETTER_AND_QUILL_CONTENT = Register.dataComponentType("letter_and_quill_content", b -> b.persistent(LetterAndQuillContent.CODEC).networkSynchronized(LetterAndQuillContent.STREAM_CODEC));
        public static final DataComponentType<LetterContent> LETTER_CONTENT = Register.dataComponentType("letter_content", b -> b.persistent(LetterContent.CODEC).networkSynchronized(LetterContent.STREAM_CODEC));
        public static final DataComponentType<Unit> LETTER_TATTERED = Register.dataComponentType("letter_tattered", b -> b.persistent(Unit.CODEC).networkSynchronized(StreamCodec.unit((Object)Unit.INSTANCE)));
        public static final DataComponentType<PackageContents> PACKAGE_CONTENTS = Register.dataComponentType("package_contents", b -> b.persistent(PackageContents.CODEC).networkSynchronized(PackageContents.STREAM_CODEC));
        public static final DataComponentType<Integer> PACKAGE_TIMES_PACKED = Register.dataComponentType("package_times_packed", b -> b.persistent((Codec)Codec.INT).networkSynchronized(ByteBufCodecs.VAR_INT));
        public static final DataComponentType<Seal> SEAL = Register.dataComponentType("seal", b -> b.persistent(Seal.CODEC).networkSynchronized(Seal.STREAM_CODEC));
        public static final DataComponentType<Holder<SealImpression>> SEAL_STAMP_IMPRESSION = Register.dataComponentType("seal_stamp_impression", b -> b.persistent(SealImpression.CODEC).networkSynchronized(SealImpression.STREAM_CODEC));
        public static final DataComponentType<PaybackTagContents> PAYBACK_TAG_CONTENTS = Register.dataComponentType("payback_tag_contents", b -> b.persistent(PaybackTagContents.CODEC).networkSynchronized(PaybackTagContents.STREAM_CODEC));
        public static final DataComponentType<PaybackSubject> PAYBACK_SUBJECT = Register.dataComponentType("payback_subject", b -> b.persistent(PaybackSubject.CODEC).networkSynchronized(PaybackSubject.STREAM_CODEC));
        public static final DataComponentType<List<Occupant>> PIGEONS = Register.dataComponentType("pigeons", b -> b.persistent(Occupant.LIST_CODEC).networkSynchronized(Occupant.STREAM_CODEC.apply(ByteBufCodecs.list())).cacheEncoding());

        static void init() {
        }
    }

    public static class Stats {
        public static void init() {
        }
    }

    public static class CriteriaTriggers {
        public static void init() {
        }
    }

    public static class ItemSubPredicates {
        public static void init() {
        }
    }

    public static class MenuTypes {
        public static final Supplier<MenuType<MailboxMenu>> PIGEONHOLE = Register.menuType("pigeonhole", MailboxMenu::fromNetwork);
        public static final Supplier<MenuType<PackingMenu>> PACKAGE = Register.menuType("package", PackingMenu::fromNetwork);
        public static final Supplier<MenuType<PaybackPackingMenu>> PAYBACK_PACKAGE = Register.menuType("payback_package", PaybackPackingMenu::fromNetwork);
        public static final Supplier<MenuType<PaybackTagMenu>> PAYBACK_TAG = Register.menuType("payback_tag", PaybackTagMenu::fromNetwork);

        static void init() {
        }
    }

    public static class RecipeSerializers {
        public static final Supplier<RecipeSerializer<?>> LETTER_CLONING = Register.recipeSerializer("crafting_special_letter_cloning", () -> new SimpleCraftingRecipeSerializer(LetterCloningRecipe::new));

        static void init() {
        }
    }

    public static class SoundEvents {
        public static final Supplier<SoundEvent> PAPER_TEAR = SoundEvents.register("item", "paper.tear");
        public static final Supplier<SoundEvent> PAPER_CRACKLE = SoundEvents.register("item", "paper.crackle");
        public static final Supplier<SoundEvent> PAPER_PLACE = SoundEvents.register("block", "paper.place");
        public static final Supplier<SoundEvent> PAPER_BREAK = SoundEvents.register("block", "paper.break");
        public static final Supplier<SoundEvent> PAPER_HIT = SoundEvents.register("block", "paper.hit");
        public static final Supplier<SoundEvent> PAPER_FALL = SoundEvents.register("block", "paper.fall");
        public static final Supplier<SoundEvent> PAPER_STEP = SoundEvents.register("block", "paper.step");
        public static final Supplier<SoundEvent> PAPER_USE = SoundEvents.register("block", "paper.use");
        public static final Supplier<SoundEvent> PIGEON_AMBIENT = SoundEvents.register("entity", "pigeon.ambient");
        public static final Supplier<SoundEvent> PIGEON_DEATH = SoundEvents.register("entity", "pigeon.death");
        public static final Supplier<SoundEvent> PIGEON_EAT = SoundEvents.register("entity", "pigeon.eat");
        public static final Supplier<SoundEvent> PIGEON_FLY = SoundEvents.register("entity", "pigeon.fly");
        public static final Supplier<SoundEvent> PIGEON_HURT = SoundEvents.register("entity", "pigeon.hurt");
        public static final Supplier<SoundEvent> PIGEON_STEP = SoundEvents.register("entity", "pigeon.step");

        private static Supplier<SoundEvent> register(String category, String key) {
            Preconditions.checkState((category != null && !category.isEmpty() ? 1 : 0) != 0, (Object)"'category' should not be empty.");
            Preconditions.checkState((key != null && !key.isEmpty() ? 1 : 0) != 0, (Object)"'key' should not be empty.");
            String path = category + "." + key;
            return Register.soundEvent(path, () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Envelope.resource(path)));
        }

        static void init() {
        }
    }

    public static class ArgumentTypes {
        public static final Supplier<ArgumentTypeInfo<AddressArgument, SingletonArgumentInfo.Template>> ADDRESS = Register.commandArgumentType("address", AddressArgument.class, SingletonArgumentInfo.contextFree(AddressArgument::all));

        public static void init() {
        }
    }

    public static class Registries {
        public static final ResourceKey<Registry<SealMaterial>> SEAL_MATERIAL = ResourceKey.createRegistryKey((ResourceLocation)Envelope.resource("seal_material"));
        public static final ResourceKey<Registry<SealImpression>> SEAL_IMPRESSION = ResourceKey.createRegistryKey((ResourceLocation)Envelope.resource("seal_impression"));
    }

    public static class Tags {

        public static class SealImpressions {
            public static final TagKey<SealImpression> SPECIAL = TagKey.create(Registries.SEAL_IMPRESSION, (ResourceLocation)Envelope.resource("special"));
            public static final TagKey<SealImpression> TOOLS = TagKey.create(Registries.SEAL_IMPRESSION, (ResourceLocation)Envelope.resource("tools"));
        }

        public static class Structures {
            public static final TagKey<Structure> PIGEONS_SPAWN_IN = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.STRUCTURE, (ResourceLocation)Envelope.resource("pigeons_spawn_in"));
        }

        public static class Biomes {
            public static final TagKey<Biome> ALLOWS_PIGEON_SPAWNS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BIOME, (ResourceLocation)Envelope.resource("allows_pigeon_spawns"));
            public static final TagKey<Biome> HAS_PASSENGER_PIGEONS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BIOME, (ResourceLocation)Envelope.resource("has_passenger_pigeons"));
        }

        public static class DamageTypes {
            public static final TagKey<DamageType> BYPASSES_PIGEON_DELIVERY_EVASION = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.DAMAGE_TYPE, (ResourceLocation)Envelope.resource("bypasses_pigeon_delivery_evasion"));
        }

        public static class EntityTypes {
            public static final TagKey<EntityType<?>> PIGEONHOLE_INHABITORS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ENTITY_TYPE, (ResourceLocation)Envelope.resource("pigeonhole_inhabitors"));
        }

        public static class Items {
            public static final TagKey<Item> PIGEON_FOOD = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("pigeon_food"));
            public static final TagKey<Item> PIGEONHOLES = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("pigeonholes"));
            public static final TagKey<Item> WASTE_SCOOPABLE = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("waste_scoopable"));
            public static final TagKey<Item> LETTERS = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("letters"));
            public static final TagKey<Item> PACKAGES = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("packages"));
            public static final TagKey<Item> MAILABLE = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("mailable"));
            public static final TagKey<Item> CANNOT_BE_PACKAGED = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("cannot_be_packaged"));
            public static final TagKey<Item> CANNOT_BE_USED_AS_PAYBACK = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.ITEM, (ResourceLocation)Envelope.resource("cannot_be_used_as_payback"));
        }

        public static class Blocks {
            public static final TagKey<Block> PIGEONS_SPAWNABLE_ON = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Envelope.resource("pigeons_spawnable_on"));
            public static final TagKey<Block> PIGEONHOLES = TagKey.create((ResourceKey)net.minecraft.core.registries.Registries.BLOCK, (ResourceLocation)Envelope.resource("pigeonholes"));
        }
    }

    public static class LootTables {
    }

    public static class SoundTypes {
        public static final SoundType PAPER = new DeferredSoundType(1.0f, 1.0f, SoundEvents.PAPER_BREAK, SoundEvents.PAPER_STEP, SoundEvents.PAPER_PLACE, SoundEvents.PAPER_HIT, SoundEvents.PAPER_FALL);
    }
}

