/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.tooltip.CompositeTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.MailAddressTagTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PackageTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PaybackTagContentsTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.PaybackTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.SealDieTooltipComponent;
import io.github.mortuusars.envelope.client.gui.tooltip.SealTooltipComponent;
import io.github.mortuusars.envelope.client.renderer.SealRenderer;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.bugger.BuggerDebugScreen;
import io.github.mortuusars.envelope.util.bugger.BuggerEntityOverhead;
import io.github.mortuusars.envelope.util.bugger_data.EnvelopeBuggerPage;
import io.github.mortuusars.envelope.util.bugger_data.PigeonEntityDataDisplay;
import io.github.mortuusars.envelope.world.item.component.LetterAndQuillContent;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import io.github.mortuusars.envelope.world.item.component.RequestedPayback;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.item.tooltip.CompositeTooltip;
import io.github.mortuusars.envelope.world.item.tooltip.MailAddressTagTooltip;
import io.github.mortuusars.envelope.world.mail.address.Address;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class EnvelopeClient {
    private static final SealRenderer sealRenderer = new SealRenderer();

    public static void init() {
        BuggerDebugScreen.addPage(new EnvelopeBuggerPage());
        BuggerEntityOverhead.addData(new PigeonEntityDataDisplay());
        ItemModelOverrides.register();
    }

    public static SealRenderer getSealRenderer() {
        return sealRenderer;
    }

    public static class ItemModelOverrides {
        public static final ResourceLocation LETTER_TATTERED = Envelope.resource("letter_tattered");
        public static final ResourceLocation LETTER_UNFOLDED = Envelope.resource("letter_unfolded");
        public static final ResourceLocation LETTER_CONTENT = Envelope.resource("letter_content");

        public static void register() {
            ItemProperties.register((Item)Envelope.Items.LETTER_AND_QUILL.get(), (ResourceLocation)LETTER_CONTENT, ItemModelOverrides::hasLetterContent);
            ItemProperties.register((Item)Envelope.Items.LETTER.get(), (ResourceLocation)LETTER_TATTERED, ItemModelOverrides::isLetterTattered);
            ItemProperties.register((Item)Envelope.Items.LETTER.get(), (ResourceLocation)LETTER_UNFOLDED, ItemModelOverrides::isLetterUnfolded);
            ItemProperties.register((Item)Envelope.Items.LETTER.get(), (ResourceLocation)LETTER_CONTENT, ItemModelOverrides::hasLetterContent);
            ItemProperties.register((Item)Envelope.Items.SEALED_LETTER.get(), (ResourceLocation)LETTER_TATTERED, ItemModelOverrides::isLetterTattered);
        }

        public static float isLetterTattered(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            return stack.has(Envelope.DataComponents.LETTER_TATTERED) ? 1.0f : 0.0f;
        }

        public static float isLetterUnfolded(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            LetterContent content = (LetterContent)stack.getOrDefault(Envelope.DataComponents.LETTER_CONTENT, (Object)LetterContent.EMPTY);
            return content.unfolded() ? 1.0f : 0.0f;
        }

        public static float hasLetterContent(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            if (!((LetterAndQuillContent)stack.getOrDefault(Envelope.DataComponents.LETTER_AND_QUILL_CONTENT, (Object)LetterAndQuillContent.EMPTY)).isEmpty()) {
                return 1.0f;
            }
            if (!((LetterContent)stack.getOrDefault(Envelope.DataComponents.LETTER_CONTENT, (Object)LetterContent.EMPTY)).isEmpty()) {
                return 1.0f;
            }
            return 0.0f;
        }
    }

    public static class TooltipComponents {
        public static ClientTooltipComponent create(TooltipComponent component) {
            TooltipComponent tooltipComponent = component;
            Objects.requireNonNull(tooltipComponent);
            TooltipComponent tooltipComponent2 = tooltipComponent;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MailAddressTagTooltip.class, PackageContents.class, RequestedPayback.class, PaybackTagContents.class, Seal.class, io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent.class, CompositeTooltip.class}, (Object)tooltipComponent2, n)) {
                case 0 -> {
                    MailAddressTagTooltip mailAddress = (MailAddressTagTooltip)tooltipComponent2;
                    yield new MailAddressTagTooltipComponent(mailAddress.address());
                }
                case 1 -> {
                    PackageContents packageContents = (PackageContents)tooltipComponent2;
                    yield new PackageTooltipComponent(packageContents);
                }
                case 2 -> {
                    RequestedPayback requestedPayback = (RequestedPayback)tooltipComponent2;
                    yield new PaybackTooltipComponent(requestedPayback);
                }
                case 3 -> {
                    PaybackTagContents paybackTagContents = (PaybackTagContents)tooltipComponent2;
                    yield new PaybackTagContentsTooltipComponent(paybackTagContents);
                }
                case 4 -> {
                    Seal seal = (Seal)tooltipComponent2;
                    yield new SealTooltipComponent(seal);
                }
                case 5 -> {
                    io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent die = (io.github.mortuusars.envelope.world.inventory.tooltip.SealDieTooltipComponent)tooltipComponent2;
                    yield new SealDieTooltipComponent(die.impression());
                }
                case 6 -> {
                    CompositeTooltip composite = (CompositeTooltip)tooltipComponent2;
                    yield new CompositeTooltipComponent(composite.components().stream().map(ClientTooltipComponent::create).toList());
                }
                default -> null;
            };
        }

        public static Optional<TooltipComponent> modifyTooltipImage(ItemStack stack, Optional<TooltipComponent> original) {
            if (stack.is(Envelope.Tags.Items.MAILABLE)) {
                return CompositeTooltip.of(original, Optional.ofNullable((Address)stack.get(Envelope.DataComponents.MAIL_RECIPIENT)).map(MailAddressTagTooltip::new), Optional.ofNullable((TooltipComponent)stack.get(Envelope.DataComponents.MAIL_REQUESTED_PAYBACK)));
            }
            return original;
        }

        public static void appendTooltipLines(ItemStack stack, Consumer<Component> consumer, Item.TooltipContext context, Player player, TooltipFlag tooltipFlag) {
            Mail.getSender(stack).ifPresent(sender -> {
                DeliveryLog deliveryLog = Mail.getLog(stack);
                if (Screen.hasShiftDown() && !deliveryLog.isEmpty()) {
                    consumer.accept((Component)Component.translatable((String)"gui.envelope.delivery_log").withStyle(ChatFormatting.DARK_GRAY));
                    for (DeliveryRecord record : deliveryLog.records()) {
                        consumer.accept((Component)record.toComponent(Minecrft.level().getGameTime()));
                    }
                } else {
                    consumer.accept((Component)Component.translatable((String)"gui.envelope.mail.from").withStyle(ChatFormatting.GRAY).append(": ").withStyle(ChatFormatting.GRAY).append((Component)sender.format().asNeutral().toComponent()));
                }
            });
            if (tooltipFlag.isAdvanced()) {
                Optional.ofNullable(Mail.getId(stack)).ifPresent(id -> consumer.accept((Component)Component.literal((String)("Mail Id: " + String.valueOf(id))).withStyle(ChatFormatting.GRAY)));
            }
        }
    }
}

