/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.github.mortuusars.envelope.neoforge.PlatformHelperImpl;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformHelper {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isInDevEnv() {
        return PlatformHelperImpl.isInDevEnv();
    }

    @ExpectPlatform
    @Nullable
    @ExpectPlatform.Transformed
    public static MinecraftServer getCurrentServer() {
        return PlatformHelperImpl.getCurrentServer();
    }

    public static Optional<MinecraftServer> getServer() {
        return Optional.ofNullable(PlatformHelper.getCurrentServer());
    }

    @NotNull
    public static MinecraftServer getCurrentServerOrThrow() {
        return Objects.requireNonNull(PlatformHelper.getCurrentServer());
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoaded(String modId) {
        return PlatformHelperImpl.isModLoaded(modId);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isModLoading(String modId) {
        return PlatformHelperImpl.isModLoading(modId);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void openMenu(ServerPlayer serverPlayer, MenuProvider menuProvider, Consumer<RegistryFriendlyByteBuf> extraDataWriter) {
        void var2_2;
        void var1_1;
        PlatformHelperImpl.openMenu(serverPlayer, (MenuProvider)var1_1, (Consumer<RegistryFriendlyByteBuf>)var2_2);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getGameDirectory() {
        return PlatformHelperImpl.getGameDirectory();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path getConfigDirectory() {
        return PlatformHelperImpl.getConfigDirectory();
    }
}

