/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.screen.AddressTagScreen;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.validation.CachedValidator;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractMailboxAddressScreen
extends AddressTagScreen {
    protected final LocalPlayer player = Minecrft.player();
    protected CachedValidator<String> addressValidator;

    public AbstractMailboxAddressScreen(InteractionHand hand, AllAddresses knownAddresses, Optional<Address.Block> existingAddress, Component title) {
        super(hand, knownAddresses, title);
        this.existingAddress = existingAddress.map(Address.class::cast);
        this.addressValidator = AddressValidation.forMailbox(knownAddresses, (Player)this.player).cached();
    }

    @Override
    protected abstract ItemStack getTargetPreview();

    protected abstract void onConfirm();

    protected abstract boolean stillValid();

    @Override
    protected String getInitialAddressValue() {
        return this.existingAddress.map(Address::id).orElseGet(() -> Optional.ofNullable((Address)this.player.getItemInHand(this.hand).get(Envelope.DataComponents.ADDRESS)).map(Address::getName).map(Component::getString).orElse(""));
    }

    @Override
    protected AllAddresses getAddressesForSuggestions() {
        return AllAddresses.EMPTY;
    }

    public CachedValidator<String> getAddressValidator() {
        return this.addressValidator;
    }

    protected boolean canConfirm() {
        return this.isCurrentIdSameAsExistingAddress() || this.getAddressValidator().getErrors().isEmpty();
    }

    protected void updateConfirmButton() {
        if (this.confirmButton == null) {
            return;
        }
        this.confirmButton.active = this.canConfirm();
        MutableComponent confirmTooltip = Component.translatable((String)"gui.envelope.confirm");
        if (!this.confirmButton.active) {
            this.getAddressValidator().getErrors().forEach(issue -> confirmTooltip.append("\n").append((Component)Component.literal((String)"\u2022 ").withStyle(ChatFormatting.RED)).append((Component)issue.getTranslation().withStyle(ChatFormatting.RED)));
            this.confirmButton.setTooltip(Tooltip.create((Component)confirmTooltip));
            return;
        }
        if (this.isRenaming() && !this.isCurrentIdSameAsExistingAddress()) {
            confirmTooltip.append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox_address.rename_warning.inbox").withStyle(Style.EMPTY.withColor(-1611158))).append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox_address.rename_warning.traveling").withStyle(Style.EMPTY.withColor(-1611158)));
        }
        this.confirmButton.setTooltip(Tooltip.create((Component)confirmTooltip));
    }

    @Override
    protected void addressTextChanged(String text) {
        super.addressTextChanged(text);
        this.getAddressValidator().testAll(this.getCurrentAddressId());
    }

    @Override
    protected boolean confirm() {
        if (!this.canConfirm()) {
            return false;
        }
        if (!this.isCurrentIdSameAsExistingAddress()) {
            this.onConfirm();
        }
        this.close();
        return true;
    }

    @Override
    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.stillValid()) {
            this.close();
        }
        this.updateConfirmButton();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderExperienceCost(guiGraphics, mouseX, mouseY);
    }

    @Override
    protected void renderAddressIcon(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int color = this.canConfirm() ? -1 : -1426063361;
        guiGraphics.drawString(this.font, "\uee00", this.leftPos + 17, this.topPos + 21, color, true);
    }

    protected void renderExperienceCost(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (this.isCurrentIdSameAsExistingAddress() || this.player.isCreative()) {
            return;
        }
        int cost = (Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get();
        if (cost <= 0) {
            return;
        }
        boolean hasEnough = this.player.experienceLevel >= cost;
        ResourceLocation sprite = Envelope.resource("address_tag/experience" + (hasEnough ? "" : "_disabled"));
        int x = 159;
        int y = 4;
        guiGraphics.blitSprite(sprite, this.leftPos + x, this.topPos + y, 11, 11);
        String text = Integer.toString(cost);
        int centerColor = hasEnough ? -3604593 : -7577507;
        int outlineColor = hasEnough ? -13819646 : -12110545;
        guiGraphics.drawString(this.font, text, this.leftPos + (x += 7), this.topPos + (y += 2) - 1, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x + 1, this.topPos + y - 1, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x + 1, this.topPos + y, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x + 1, this.topPos + y + 1, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x, this.topPos + y + 1, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x - 1, this.topPos + y + 1, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x - 1, this.topPos + y, outlineColor, false);
        guiGraphics.drawString(this.font, text, this.leftPos + x, this.topPos + y, centerColor, false);
    }
}

