/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.gui.widget.AddressBoxSuggestions;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.AddressTagApplyC2SP;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddressTagScreen
extends Screen {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/address_tag.png");
    public static final WidgetSprites CONFIRM_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("address_tag/confirm_button"));
    protected final InteractionHand hand;
    protected final ItemStack tag;
    protected final AllAddresses knownAddresses;
    protected Optional<Address> existingAddress;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int titleLabelX;
    protected int titleLabelY;
    protected EditBox addressBox;
    protected AddressBoxSuggestions suggestions;
    protected ImageButton confirmButton;
    protected Optional<Address> matchedKnownAddress = Optional.empty();
    @Nullable
    protected String currentSuggestion;

    public AddressTagScreen(InteractionHand hand, AllAddresses knownAddresses, Component title) {
        super(title);
        this.hand = hand;
        this.tag = Minecrft.player().getItemInHand(hand).copy();
        this.knownAddresses = knownAddresses;
        this.existingAddress = Optional.ofNullable((Address)this.tag.get(Envelope.DataComponents.ADDRESS));
    }

    protected void init() {
        this.imageWidth = 186;
        this.imageHeight = 40;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.titleLabelX = this.leftPos + 12;
        this.titleLabelY = this.topPos + 6;
        this.addressBox = new EditBox(this.font, this.leftPos + 26, this.topPos + 21, 125, 9, (Component)Component.empty());
        this.addressBox.setValue(this.getInitialAddressValue());
        this.addressBox.setMaxLength(40);
        this.addressBox.setTextColor(-1);
        this.addressBox.setResponder(this::addressTextChanged);
        this.addressBox.setBordered(false);
        this.addressBox.setCanLoseFocus(false);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.suggestions = new AddressBoxSuggestions(this.addressBox, this.getAddressesForSuggestions(), 6);
        this.suggestions.update();
        this.confirmButton = new ImageButton(this.leftPos + 158, this.topPos + 17, 16, 16, CONFIRM_BUTTON_SPRITES, button -> this.confirm(), (Component)Component.translatable((String)"gui.envelope.confirm"));
        this.confirmButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.confirm")));
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
        this.setInitialFocus((GuiEventListener)this.addressBox);
        this.addressTextChanged(this.addressBox.getValue());
    }

    protected ItemStack getTargetPreview() {
        return this.tag;
    }

    protected String getCurrentAddressId() {
        return this.addressBox.getValue().trim();
    }

    protected String getInitialAddressValue() {
        @Nullable Address address = (Address)this.tag.get(Envelope.DataComponents.ADDRESS);
        if (address != null) {
            return address.toString();
        }
        return "";
    }

    protected Optional<Address> getMatchedKnownAddress() {
        return this.matchedKnownAddress;
    }

    protected Optional<Address> getOrCreateAddressFromCurrentValue() {
        String addressId = this.getCurrentAddressId().trim();
        if (addressId.isBlank()) {
            return Optional.empty();
        }
        return this.getMatchedKnownAddress().or(() -> Optional.of(new Address.Block(addressId)));
    }

    protected AllAddresses getAddressesForSuggestions() {
        return this.knownAddresses;
    }

    protected boolean isRenaming() {
        return this.existingAddress.isPresent();
    }

    protected boolean isCurrentIdSameAsExistingAddress() {
        String currentAddressId = this.getCurrentAddressId().trim();
        return this.existingAddress.map(address -> address.matches(currentAddressId)).orElse(false);
    }

    protected void updateItem() {
        this.getOrCreateAddressFromCurrentValue().ifPresentOrElse(value -> this.tag.set(Envelope.DataComponents.ADDRESS, value), () -> this.tag.remove(Envelope.DataComponents.ADDRESS));
    }

    protected void addressTextChanged(String text) {
        String addressId = text.trim();
        this.matchedKnownAddress = this.knownAddresses.byName(addressId);
        this.updateItem();
        this.suggestions.update();
    }

    protected boolean confirm() {
        if (!this.isCurrentIdSameAsExistingAddress()) {
            Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, (float)1.0f));
            int slot = this.hand == InteractionHand.MAIN_HAND ? Minecrft.player().getInventory().selected : 40;
            Packets.sendToServer(new AddressTagApplyC2SP(slot, this.getOrCreateAddressFromCurrentValue()));
        }
        this.close();
        return true;
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String text = this.addressBox.getValue();
        int cursorPosition = this.addressBox.getCursorPosition();
        super.resize(minecraft, width, height);
        this.addressBox.setValue(text);
        this.addressBox.setCursorPosition(cursorPosition);
        this.suggestions.update();
    }

    protected void close() {
        this.onClose();
    }

    public void render(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
        this.suggestions.render(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.pose().popPose();
        this.renderLabels(guiGraphics);
        this.renderAddressIcon(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTargetPreview(guiGraphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderLabels(@NotNull GuiGraphics guiGraphics) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, -12829636, false);
    }

    protected void renderAddressIcon(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Address address = this.getMatchedKnownAddress().orElse(Address.UNKNOWN);
        int color = !address.equals(Address.UNKNOWN) ? -5438 : -1996494142;
        guiGraphics.drawString(this.font, AddressFormatter.getIcon(address), this.leftPos + 17, this.topPos + 21, color, true);
        if (address != Address.UNKNOWN && this.isHovering(15, 20, 9, 9, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, (Component)address.type().translate(), mouseX, mouseY);
        }
    }

    protected void renderTargetPreview(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack target = this.getTargetPreview();
        if (target.isEmpty()) {
            return;
        }
        float scale = 2.0f;
        int size = (int)(16.0f * scale);
        int x = this.leftPos - size - 4;
        int y = this.topPos + (this.imageHeight - size) / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 0.0f);
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
        guiGraphics.renderItem(target, 0, 0);
        guiGraphics.pose().popPose();
        if (this.isHovering(x - this.leftPos, y - this.topPos, size, size, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, target, mouseX, mouseY);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.suggestions.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 256) {
            this.close();
            return true;
        }
        if (keyCode == 257 || keyCode == 335) {
            if (this.confirm()) {
                Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            }
            return true;
        }
        if (keyCode == 258 && this.currentSuggestion != null) {
            this.addressBox.setValue(this.currentSuggestion);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.suggestions.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 1 && this.addressBox.isMouseOver(mouseX, mouseY)) {
            if (!this.addressBox.getValue().isEmpty()) {
                this.addressBox.setValue("");
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void mouseMoved(double mouseX, double mouseY) {
        this.suggestions.mouseMoved(mouseX, mouseY);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.suggestions.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public int getSuggestionTextColor() {
        return -1996488705;
    }

    protected boolean isHovering(int x, int y, int width, int height, int mouseX, int mouseY) {
        return mouseX >= this.leftPos + x && mouseX < this.leftPos + x + width && mouseY >= this.topPos + y && mouseY < this.topPos + y + height;
    }
}

