/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.gui.widget.textbox.TextBox;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.compat.jei.JeiCompatibleScreen;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.LetterEditC2SP;
import io.github.mortuusars.envelope.util.ItemAndStack;
import io.github.mortuusars.envelope.world.item.LetterAndQuillItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LetterEditScreen
extends Screen
implements JeiCompatibleScreen {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/letter_and_quill.png");
    public static final WidgetSprites FOLD_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("letter_and_quill/fold_button"));
    protected final ItemAndStack<LetterAndQuillItem> letter;
    protected final InteractionHand hand;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected TextBox textBox;
    protected ImageButton foldButton;

    public LetterEditScreen(ItemStack letter, InteractionHand hand) {
        super((Component)Component.empty());
        this.letter = new ItemAndStack(letter);
        this.hand = hand;
    }

    public boolean isPauseScreen() {
        return (Boolean)Config.Server.LETTER_PAUSE.get();
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 192;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.textBox = (TextBox)this.addRenderableWidget((GuiEventListener)new TextBox(this.font, this.leftPos + 17, this.topPos + 21, 142, 144).setFontColor(-8693443).setFontUnfocusedColor(-8693443).setSelectionColor(-10075000).setSelectionUnfocusedColor(-9870992).setHintColor(-4020865).setText(FormattedString.parse(this.letter.map(LetterAndQuillItem::getContent).text())));
        this.foldButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + this.imageWidth + 5, this.topPos + 144, 18, 18, FOLD_BUTTON_SPRITES, btn -> {
            this.saveChanges(true);
            Minecrft.get().setScreen(null);
        }, (Component)Component.translatable((String)"envelope.letter_and_quill.fold_button")));
        this.foldButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"envelope.letter_and_quill.fold_button").append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"envelope.letter_and_quill.fold_warning").withStyle(ChatFormatting.GRAY))));
        this.setInitialFocus((GuiEventListener)this.textBox);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        FormattedString message = this.textBox.getEditor().getText();
        int messageCursorPos = this.textBox.getEditor().getCursorPos();
        super.resize(minecraft, width, height);
        this.textBox.getEditor().setText(message);
        this.textBox.getEditor().setCursorPos(messageCursorPos, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        TextBox box;
        GuiEventListener guiEventListener = this.getFocused();
        if (guiEventListener instanceof TextBox && (box = (TextBox)guiEventListener).formattingToolbarMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(this.getFocused() instanceof TextBox) && Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void setFocused(@Nullable GuiEventListener focused) {
        @Nullable GuiEventListener lastFocused = this.getFocused();
        super.setFocused(focused);
        if (lastFocused != null && !lastFocused.equals((Object)this.getFocused()) && lastFocused instanceof TextBox) {
            TextBox box = (TextBox)lastFocused;
            box.getEditor().clearSelection();
            box.getDisplayCache().scheduleUpdate();
        }
    }

    public void onClose() {
        super.onClose();
        this.saveChanges(false);
    }

    protected void saveChanges(boolean fold) {
        String text = this.textBox.getEditor().getText().toString();
        int slot = this.hand == InteractionHand.MAIN_HAND ? Minecrft.player().getInventory().selected : 40;
        Packets.sendToServer(new LetterEditC2SP(slot, text, fold));
    }

    @Override
    public boolean shouldBlockJeiInput() {
        return true;
    }
}

