/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.LetterViewScreenClosedS2CP;
import io.github.mortuusars.envelope.util.ItemAndStack;
import io.github.mortuusars.envelope.world.item.LetterItem;
import io.github.mortuusars.envelope.world.item.component.LetterContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LetterViewScreen
extends Screen {
    public static final ResourceLocation REGULAR_TEXTURE = Envelope.resource("textures/gui/letter.png");
    public static final ResourceLocation TATTERED_TEXTURE = Envelope.resource("textures/gui/letter_tattered.png");
    public static final ResourceLocation TATTERED_OVERLAY = Envelope.resource("textures/gui/letter_tattered_overlay.png");
    protected final ItemAndStack<LetterItem> letter;
    protected final InteractionHand hand;
    protected final boolean isTattered;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected int maxTextWidth;
    protected int maxTextHeight;
    protected int maxTextLines;
    protected List<FormattedCharSequence> lines;

    public LetterViewScreen(ItemStack letter, InteractionHand hand) {
        super((Component)Component.empty());
        this.letter = new ItemAndStack(letter);
        this.hand = hand;
        this.isTattered = letter.has(Envelope.DataComponents.LETTER_TATTERED);
    }

    public boolean isPauseScreen() {
        return (Boolean)Config.Server.LETTER_PAUSE.get();
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 192;
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.maxTextWidth = 142;
        this.maxTextHeight = 144;
        Objects.requireNonNull(this.font);
        this.maxTextLines = this.maxTextHeight / 9;
        this.createLines(((LetterContent)this.letter.getOrDefault(Envelope.DataComponents.LETTER_CONTENT, LetterContent.EMPTY)).text());
    }

    protected void createLines(Component text) {
        this.lines = this.font.split((FormattedText)text, this.maxTextWidth);
        if (this.lines.size() > this.maxTextLines) {
            this.lines = new ArrayList<FormattedCharSequence>(this.lines);
            int lastLineIndex = this.maxTextLines - 1;
            FormattedCharSequence ellipsis = CommonComponents.ELLIPSIS.getVisualOrderText();
            this.lines.set(lastLineIndex, FormattedCharSequence.composite((FormattedCharSequence)this.lines.get(lastLineIndex), (FormattedCharSequence)ellipsis));
            this.lines.set(lastLineIndex + 1, FormattedCharSequence.composite((FormattedCharSequence)ellipsis, (FormattedCharSequence)this.lines.get(lastLineIndex + 1)));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        Style style;
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = this.leftPos + 17;
        int y = this.topPos + 21;
        int textColor = -8693443;
        for (int i = 0; i < Math.min(this.lines.size(), this.maxTextLines); ++i) {
            Objects.requireNonNull(this.font);
            guiGraphics.drawString(this.font, this.lines.get(i), x, y + i * 9, textColor, false);
        }
        if (this.isTattered) {
            RenderSystem.enableBlend();
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
            guiGraphics.blit(TATTERED_OVERLAY, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
            guiGraphics.pose().popPose();
            RenderSystem.disableBlend();
        }
        if ((style = this.getComponentStyleAt(mouseX, mouseY)) != null && style.getHoverEvent() != null) {
            guiGraphics.renderComponentHoverEffect(this.font, style, mouseX, mouseY);
        } else if (this.lines.size() > this.maxTextLines && mouseX >= x && mouseX < x + this.maxTextWidth && mouseY >= y && mouseY < y + this.maxTextHeight) {
            List leftovers = this.lines.stream().skip(this.maxTextLines).toList();
            guiGraphics.renderTooltip(this.font, leftovers, mouseX, mouseY);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        ResourceLocation texture = this.isTattered ? TATTERED_TEXTURE : REGULAR_TEXTURE;
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Nullable
    public Style getComponentStyleAt(double mouseX, double mouseY) {
        if (this.lines.isEmpty() || mouseX < (double)(this.leftPos + 17) || mouseX >= (double)(this.leftPos + 17 + this.maxTextWidth) || mouseY < (double)(this.topPos + 21) || mouseY >= (double)(this.topPos + 21 + this.maxTextHeight)) {
            return null;
        }
        int x = (int)mouseX - (this.leftPos + 17);
        int y = (int)mouseY - (this.topPos + 21);
        int linesCount = Math.min(this.lines.size(), this.maxTextLines);
        Objects.requireNonNull(this.font);
        if (y < 9 * linesCount + linesCount) {
            Objects.requireNonNull(this.font);
            int clickedLine = y / 9;
            if (clickedLine >= 0 && clickedLine < this.lines.size()) {
                FormattedCharSequence text = this.lines.get(clickedLine);
                return this.font.getSplitter().componentStyleAtWidth(text, x);
            }
            return null;
        }
        return null;
    }

    public void onClose() {
        super.onClose();
        int slot = this.hand == InteractionHand.MAIN_HAND ? Minecrft.player().getInventory().selected : 40;
        Packets.sendToServer(new LetterViewScreenClosedS2CP(slot));
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (Minecraft.getInstance().options.keyInventory.matches(keyCode, scanCode)) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double x, double y, int button) {
        Style style;
        if (button == 0 && this.handleComponentClicked(style = this.getComponentStyleAt(x, y))) {
            return true;
        }
        return super.mouseClicked(x, y, button);
    }

    public boolean handleComponentClicked(@Nullable Style style) {
        if (style == null) {
            return false;
        }
        @Nullable ClickEvent clickEvent = style.getClickEvent();
        if (clickEvent == null) {
            return false;
        }
        boolean handled = this.handleComponentClicked(style);
        if (handled && clickEvent.getAction() == ClickEvent.Action.RUN_COMMAND) {
            this.onClose();
        }
        return handled;
    }
}

