/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.client.gui.screen.AbstractMailboxAddressScreen;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.MailboxAddressTagApplyC2SP;
import io.github.mortuusars.envelope.world.item.AddressTagItem;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MailboxChangeAddressScreen
extends AbstractMailboxAddressScreen {
    protected final BlockPos pos;
    protected final BlockState state;
    protected final BlockEntity blockEntity;

    public MailboxChangeAddressScreen(InteractionHand hand, AllAddresses knownAddresses, BlockPos pos, Address.Block existingAddress, Component title) {
        super(hand, knownAddresses, Optional.ofNullable(existingAddress), title);
        this.pos = pos;
        this.state = this.player.level().getBlockState(pos);
        this.blockEntity = this.player.level().getBlockEntity(pos);
    }

    @Override
    protected ItemStack getTargetPreview() {
        return new ItemStack((ItemLike)this.state.getBlock().asItem());
    }

    @Override
    protected void onConfirm() {
        Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.UI_CARTOGRAPHY_TABLE_TAKE_RESULT, (float)1.0f));
        if ((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get() > 0) {
            this.player.level().playSound((Player)this.player, this.pos, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS);
        }
        Packets.sendToServer(new MailboxAddressTagApplyC2SP(this.hand, this.getCurrentAddressId().trim(), this.pos));
    }

    @Override
    protected boolean stillValid() {
        return this.player.getItemInHand(this.hand).getItem() instanceof AddressTagItem && Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)this.player);
    }
}

