/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Config;
import io.github.mortuusars.envelope.client.gui.screen.AbstractMailboxAddressScreen;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.MailboxPlaceC2SP;
import io.github.mortuusars.envelope.world.item.MailboxBlockItem;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.Optional;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.phys.BlockHitResult;

public class MailboxPlacingScreen
extends AbstractMailboxAddressScreen {
    protected final LocalPlayer player = Minecrft.player();
    protected final BlockHitResult hitResult;

    public MailboxPlacingScreen(InteractionHand hand, AllAddresses knownAddresses, BlockHitResult hitResult, Component title) {
        super(hand, knownAddresses, Optional.empty(), title);
        this.hitResult = hitResult;
        this.existingAddress = Optional.empty();
    }

    @Override
    protected ItemStack getTargetPreview() {
        return Minecrft.player().getItemInHand(this.hand);
    }

    @Override
    protected void onConfirm() {
        ItemStack stack = this.player.getItemInHand(this.hand);
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        if (blockItem.place(new BlockPlaceContext((Player)this.player, this.hand, stack, this.hitResult)).consumesAction()) {
            if ((Integer)Config.Server.MAILBOX_ADDRESS_EXPERIENCE_LEVELS_COST.get() > 0) {
                this.player.level().playSound((Player)this.player, this.hitResult.getBlockPos(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS);
            }
            Packets.sendToServer(new MailboxPlaceC2SP(this.hand, this.getCurrentAddressId().trim(), this.hitResult));
        }
    }

    @Override
    protected boolean stillValid() {
        return this.player.getItemInHand(this.hand).getItem() instanceof MailboxBlockItem;
    }

    @Override
    protected boolean isCurrentIdSameAsExistingAddress() {
        return false;
    }
}

