/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.network.Packets;
import io.github.mortuusars.envelope.network.packet.serverbound.MailboxMenuInboxActionC2SP;
import io.github.mortuusars.envelope.world.inventory.MailboxMenu;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryLog;
import io.github.mortuusars.envelope.world.item.component.mail.log.DeliveryRecord;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MailboxScreen
extends AbstractContainerScreen<MailboxMenu> {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/mailbox.png");
    public static final WidgetSprites ADDRESS_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_button"));
    public static final WidgetSprites ADDRESS_ATTENTION_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_attention_button"), Envelope.resource("mailbox/address_button_highlighted"));
    public static final WidgetSprites ADDRESS_DEFAULT_BUTTON_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/address_default_button"));
    public static final WidgetSprites REGULAR_MAIL_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("mailbox/mail_button"));
    public static final WidgetSprites ICON_ADDRESS_BLOCK_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_block"));
    public static final WidgetSprites ICON_ADDRESS_PLAYER_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_player"));
    public static final WidgetSprites ICON_ADDRESS_ENTITY_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_entity"));
    public static final WidgetSprites ICON_ADDRESS_MAIL_SERVICE_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_mail_service"));
    public static final WidgetSprites ICON_ADDRESS_UNKNOWN_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_unknown"));
    public static final WidgetSprites ICON_RETURNED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_returned"));
    public static final WidgetSprites ICON_REJECTED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_rejected"));
    public static final WidgetSprites ICON_UNCLAIMED_SPRITES = Sprites.normalAndHighlighted(Envelope.resource("mailbox/icon_unclaimed"));
    public static final WidgetSprites NEW_MAIL_INDICATOR_SPRITES = Sprites.normalOnly(Envelope.resource("mailbox/new_mail_indicator"));
    protected static final int SCROLL_THUMB_TOP_HEIGHT = 3;
    protected static final int SCROLL_THUMB_MID_HEIGHT = 2;
    protected static final int SCROLL_THUMB_BOT_HEIGHT = 2;
    protected static final int SCROLL_THUMB_Y_OFFSET = 7;
    protected static final int MAX_INBOX_MAIL_BUTTONS = 8;
    protected Component inboxLabel = Component.translatable((String)"gui.envelope.mailbox.inbox");
    protected Component sendLabel = Component.translatable((String)"gui.envelope.mailbox.send");
    @Nullable
    protected ItemStack hoveredMail;
    protected ImageButton addressButton;
    protected ImageButton addressAttentionButton;
    protected ImageButton addressDefaultButton;
    protected ImageButton newMailButton;
    protected Rect2i mailArea = new Rect2i(0, 0, 0, 0);
    protected Rect2i scrollBarArea = new Rect2i(0, 0, 0, 0);
    protected Rect2i scrollThumb = new Rect2i(0, 0, 0, 0);
    protected int scroll = 0;
    protected int scrollAtDragStart = 0;
    protected boolean isDraggingScrollbar = false;
    protected double dragDelta = 0.0;

    public MailboxScreen(MailboxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 308;
        this.imageHeight = 170;
        this.titleLabelX = Math.max(17, this.imageWidth / 2 - this.font.width((FormattedText)this.title) / 2 + 5);
        this.titleLabelY = -10;
        this.inventoryLabelX = 140;
        this.inventoryLabelY = this.imageHeight - 94;
        super.init();
        this.mailArea = new Rect2i(this.leftPos + 8, this.topPos + 18, 117, 144);
        this.scrollBarArea = new Rect2i(this.leftPos + 128, this.topPos + 18, 6, 144);
        this.addressButton = new ImageButton(this.leftPos + this.titleLabelX - 11, this.topPos - 11, 10, 10, ADDRESS_BUTTON_SPRITES, button -> this.setAsDefaultAddress(), (Component)Component.translatable((String)"gui.envelope.mailbox.address"));
        this.addressButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.mailbox.address").append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox.address.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.addressButton);
        this.addressAttentionButton = new ImageButton(this.leftPos + this.titleLabelX - 11, this.topPos - 11, 10, 10, ADDRESS_ATTENTION_BUTTON_SPRITES, button -> this.setAsDefaultAddress(), (Component)Component.translatable((String)"gui.envelope.mailbox.address"));
        this.addressAttentionButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.mailbox.address").append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox.address.tooltip"))));
        this.addRenderableWidget((GuiEventListener)this.addressAttentionButton);
        this.addressDefaultButton = new ImageButton(this.leftPos + this.titleLabelX - 11, this.topPos - 11, 10, 10, ADDRESS_DEFAULT_BUTTON_SPRITES, btn -> {});
        this.addressDefaultButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.mailbox.address.default").append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox.address.default.tooltip"))));
        this.addressDefaultButton.active = false;
        this.addRenderableWidget((GuiEventListener)this.addressDefaultButton);
        this.newMailButton = new ImageButton(this.leftPos + 7, this.topPos + 6, 8, 8, NEW_MAIL_INDICATOR_SPRITES, button -> {
            this.refreshMail();
            this.scrollTo(0);
        });
        this.newMailButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.mailbox.mail.tooltip.new_mail").append("\n").append((Component)Component.translatable((String)"gui.envelope.mailbox.mail.tooltip.new_mail.click_to_refresh"))));
        this.addRenderableWidget((GuiEventListener)this.newMailButton);
        this.updateButtons();
    }

    protected void setAsDefaultAddress() {
        Minecrft.gameMode().handleInventoryButtonClick(((MailboxMenu)this.getMenu()).containerId, 0);
    }

    protected void refreshMail() {
        Minecrft.gameMode().handleInventoryButtonClick(((MailboxMenu)this.getMenu()).containerId, 1);
    }

    protected void updateScrollThumb() {
        int minSize = 7;
        int totalButtons = ((MailboxMenu)this.getMenu()).getMail().size();
        float ratio = 8.0f / (float)Math.max(totalButtons, 1);
        int size = Mth.clamp((int)Mth.ceil((float)((float)this.scrollBarArea.getHeight() * ratio)), (int)minSize, (int)this.scrollBarArea.getHeight());
        int midSize = size - 3 - 2;
        int correctedMidSize = Math.max(midSize - midSize % 2, 2);
        size = 3 + correctedMidSize + 2;
        float topRowPos = (float)this.scroll / (float)Math.max(1, totalButtons - 8);
        int pos = (int)Mth.map((float)topRowPos, (float)0.0f, (float)1.0f, (float)0.0f, (float)(this.scrollBarArea.getHeight() - size));
        this.scrollThumb = new Rect2i(this.scrollBarArea.getX(), this.scrollBarArea.getY() + pos, this.scrollBarArea.getWidth(), size);
    }

    protected void updateButtons() {
        this.addressButton.visible = !((MailboxMenu)this.getMenu()).isDefaultAddress() && ((MailboxMenu)this.getMenu()).hasDefaultAddress();
        this.addressAttentionButton.visible = !((MailboxMenu)this.getMenu()).hasDefaultAddress();
        this.addressDefaultButton.visible = ((MailboxMenu)this.getMenu()).isDefaultAddress();
        this.newMailButton.visible = ((MailboxMenu)this.getMenu()).hasNewMail();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        super.renderSlot(guiGraphics, slot);
        int mouseX = (int)(Minecrft.get().mouseHandler.xpos() * (double)Minecrft.get().getWindow().getGuiScaledWidth() / (double)Minecrft.get().getWindow().getScreenWidth());
        int mouseY = (int)(Minecrft.get().mouseHandler.ypos() * (double)Minecrft.get().getWindow().getGuiScaledHeight() / (double)Minecrft.get().getWindow().getScreenHeight());
        if (slot.isActive() && slot.getContainerSlot() == 1 && this.isHovering(slot.x, slot.y, 16, 16, mouseX, mouseY)) {
            guiGraphics.fillGradient(RenderType.guiOverlay(), slot.x - 1, slot.y - 1, slot.x + 17, slot.y, -2130706433, -2130706433, 0);
            guiGraphics.fillGradient(RenderType.guiOverlay(), slot.x - 1, slot.y, slot.x, slot.y + 16, -2130706433, -2130706433, 0);
            guiGraphics.fillGradient(RenderType.guiOverlay(), slot.x + 16, slot.y, slot.x + 17, slot.y + 16, -2130706433, -2130706433, 0);
            guiGraphics.fillGradient(RenderType.guiOverlay(), slot.x - 1, slot.y + 16, slot.x + 17, slot.y + 17, -2130706433, -2130706433, 0);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        Slot mailSlot;
        Slot foodSlot;
        this.hoveredMail = null;
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 256);
        int addressBarX = this.titleLabelX - 18;
        int addressBarWidth = this.imageWidth - addressBarX * 2;
        guiGraphics.blit(TEXTURE, this.leftPos + addressBarX, this.topPos - 15, 0.0f, (float)this.imageHeight, 5, 15, 512, 256);
        guiGraphics.blit(TEXTURE, this.leftPos + addressBarX + 5, this.topPos - 15, 5.0f, (float)this.imageHeight, addressBarWidth - 10, 15, 512, 256);
        guiGraphics.blit(TEXTURE, this.leftPos + addressBarX + addressBarWidth - 5, this.topPos - 15, 303.0f, (float)this.imageHeight, 5, 15, 512, 256);
        List<ItemStack> mail = ((MailboxMenu)this.getMenu()).getMail();
        if (!mail.isEmpty()) {
            this.scroll = Math.clamp((long)this.scroll, 0, Math.max(0, mail.size() - 8));
            for (int i = 0; i < Math.min(mail.size(), 8); ++i) {
                int index = i + this.scroll;
                ItemStack item = mail.get(index);
                int x = 8;
                int y = 18 + 18 * i;
                boolean isHovering = this.isHovering(x + 1, y + 1, 115, 16, mouseX, mouseY);
                if (isHovering) {
                    this.hoveredMail = item;
                }
                this.renderMailButton(guiGraphics, partialTick, mouseX, mouseY, item, this.leftPos + x, this.topPos + y);
            }
        } else if (((Object)((Object)this)).hashCode() % 20 == 0) {
            guiGraphics.blit(TEXTURE, this.leftPos + 59, this.topPos + 92, 348.0f, 0.0f, 17, 9, 512, 256);
        }
        if (!(foodSlot = ((MailboxMenu)this.getMenu()).getSlot(0)).hasItem()) {
            guiGraphics.blit(TEXTURE, this.leftPos + foodSlot.x, this.topPos + foodSlot.y, 314.0f, 0.0f, 16, 16, 512, 256);
        }
        if (!(mailSlot = ((MailboxMenu)this.getMenu()).getSlot(1)).hasItem()) {
            guiGraphics.blit(TEXTURE, this.leftPos + mailSlot.x - 1, this.topPos + mailSlot.y - 1, 330.0f, 0.0f, 18, 18, 512, 256);
        }
        this.renderScrollBar(guiGraphics, partialTick, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, this.titleLabelX, this.titleLabelY, 0x404040, false);
        int inboxLabelX = 68 - this.font.width((FormattedText)this.inboxLabel) / 2;
        guiGraphics.drawString(this.font, this.inboxLabel, inboxLabelX, 6, 0x404040, false);
        if (((MailboxMenu)this.getMenu()).getMail().isEmpty()) {
            MutableComponent empty = Component.translatable((String)"gui.envelope.mailbox.empty");
            int emptyLabelX = 68 - this.font.width((FormattedText)empty) / 2;
            guiGraphics.drawString(this.font, (Component)empty, emptyLabelX, 80, 0x606060, false);
        }
        int sendLabelX = 220 - this.font.width((FormattedText)this.sendLabel) / 2;
        guiGraphics.drawString(this.font, this.sendLabel, sendLabelX, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    protected void renderMailButton(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY, ItemStack mail, int x, int y) {
        boolean isHovered = this.hoveredMail == mail;
        guiGraphics.blitSprite(REGULAR_MAIL_BUTTON_SPRITES.get(true, isHovered), x, y, 0, 117, 18);
        guiGraphics.renderItem(mail, x + 2, y + 1);
        WidgetSprites iconSprites = this.getDisplayedIcon(mail);
        ResourceLocation iconSprite = isHovered ? iconSprites.enabledFocused() : iconSprites.enabled();
        guiGraphics.blitSprite(iconSprite, x + 23, y + 4, 0, 10, 10);
        Object sender = this.getDisplayedSender(mail).getName().getString();
        if (this.font.width((String)sender) > 76) {
            sender = this.font.plainSubstrByWidth((String)sender, 72) + "...";
        }
        guiGraphics.drawString(this.font, (String)sender, x + 36, y + 5, -7838649, false);
    }

    protected void renderScrollBar(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.updateScrollThumb();
        int state = 0;
        if (!this.canScroll()) {
            state = 2;
        } else if (this.isDraggingScrollbar || this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
            state = 1;
        }
        guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY(), 308.0f, (float)(state * 7), this.scrollThumb.getWidth(), 3, 512, 256);
        int middlePartsCount = (this.scrollThumb.getHeight() - 3 - 2) / 2;
        for (int i = 0; i < middlePartsCount; ++i) {
            guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY() + 3 + i * 2, 308.0f, (float)(state * 7 + 3), this.scrollThumb.getWidth(), 2, 512, 256);
        }
        guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY() + 3 + middlePartsCount * 2, 308.0f, (float)(5 + state * 7), this.scrollThumb.getWidth(), 2, 512, 256);
        if (!this.canScroll()) {
            guiGraphics.blit(TEXTURE, this.scrollThumb.getX(), this.scrollThumb.getY() + 3 + middlePartsCount * 2 + 1, 308.0f, (float)(5 + state * 7), this.scrollThumb.getWidth(), 2, 512, 256);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        super.renderTooltip(guiGraphics, x, y);
        if (this.hoveredMail != null) {
            this.renderMailTooltip(guiGraphics, x, y, this.hoveredMail);
        }
    }

    protected void renderMailTooltip(GuiGraphics guiGraphics, int x, int y, ItemStack hoveredMail) {
        DeliveryLog deliveryLog;
        if (x >= this.leftPos + 8 && x < this.leftPos + 28) {
            guiGraphics.renderTooltip(this.font, this.getTooltipFromContainerItem(hoveredMail), hoveredMail.getTooltipImage(), x, y);
            return;
        }
        if (x >= this.leftPos + 31 && x < this.leftPos + 41) {
            guiGraphics.renderTooltip(this.font, this.getDisplayedIconName(hoveredMail), x, y);
            return;
        }
        ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
        Address sender = this.getDisplayedSender(hoveredMail);
        if (this.font.width(sender.toString()) > 76) {
            tooltip.add(AddressFormatter.of(sender).withIcon().withIconColor(-1651816).withColor(ChatFormatting.WHITE).toComponent());
        }
        if (!(deliveryLog = Mail.getLog(hoveredMail)).isEmpty()) {
            tooltip.add(Component.translatable((String)"gui.envelope.delivery_log"));
            for (DeliveryRecord record : deliveryLog.records()) {
                tooltip.add(record.toComponent(Minecrft.level().getGameTime()));
            }
        }
        if (!tooltip.isEmpty()) {
            guiGraphics.renderTooltip(this.font, tooltip, Optional.empty(), x, y);
        }
    }

    public boolean canScroll() {
        return ((MailboxMenu)this.getMenu()).getMail().size() > 8;
    }

    public void scroll(int amount) {
        this.scrollTo(this.scroll + amount);
    }

    public void scrollTo(int buttonIndex) {
        int maxScrollWhenAtEnd = Math.max(0, ((MailboxMenu)this.getMenu()).getMail().size() - 8);
        this.scroll = Mth.clamp((int)buttonIndex, (int)0, (int)maxScrollWhenAtEnd);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 268) {
            this.scroll(Integer.MIN_VALUE);
            return true;
        }
        if (keyCode == 269) {
            this.scroll(Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 265) {
            this.scroll(-1);
            return true;
        }
        if (keyCode == 264) {
            this.scroll(1);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0 && this.hoveredMail != null) {
            int index = ((MailboxMenu)this.getMenu()).getMail().indexOf(this.hoveredMail);
            if (index == -1) {
                return false;
            }
            MailboxMenu.MailAction action = MailboxMenu.MailAction.PICK_UP;
            if (Screen.hasShiftDown()) {
                action = Screen.hasControlDown() ? MailboxMenu.MailAction.MOVE_ALL_TO_INVENTORY : MailboxMenu.MailAction.MOVE_TO_INVENTORY;
            }
            if (((MailboxMenu)this.getMenu()).doMailAction((Player)Minecrft.player(), index, action)) {
                Minecrft.player().playSound((SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), 1.0f, 1.0f);
                Packets.sendToServer(new MailboxMenuInboxActionC2SP(index, action));
            }
        }
        if (this.canScroll()) {
            if (this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
                this.setDragging(true);
                this.isDraggingScrollbar = true;
                this.dragDelta = 0.0;
                this.scrollAtDragStart = this.scroll;
                return true;
            }
            if (this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
                int direction = mouseY < (double)this.scrollThumb.getY() ? -1 : 1;
                this.scroll(8 * direction);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar || button != 0) {
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }
        this.dragDelta += dragY;
        double threshold = (double)this.scrollBarArea.getHeight() / (double)Math.max(((MailboxMenu)this.getMenu()).getMail().size(), 1);
        int amount = (int)(this.dragDelta / threshold);
        if (amount != 0 || this.scroll != this.scrollAtDragStart) {
            this.scrollTo(this.scrollAtDragStart + amount);
        }
        return true;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isMouseOver(this.mailArea, mouseX, mouseY) || this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
            this.scroll((int)(-scrollY));
            return true;
        }
        return false;
    }

    protected WidgetSprites getDisplayedIcon(ItemStack mail) {
        if (Mail.isReturned(mail)) {
            return ICON_RETURNED_SPRITES;
        }
        Address sender = Mail.getSenderOrUnknown(mail);
        if (sender.equals(Address.UNKNOWN)) {
            return ICON_ADDRESS_UNKNOWN_SPRITES;
        }
        if (sender.equals(Address.MAIL_SERVICE)) {
            return ICON_ADDRESS_MAIL_SERVICE_SPRITES;
        }
        return switch (sender.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> ICON_ADDRESS_BLOCK_SPRITES;
            case Address.Type.PLAYER -> ICON_ADDRESS_PLAYER_SPRITES;
            case Address.Type.ENTITY -> ICON_ADDRESS_ENTITY_SPRITES;
        };
    }

    protected Component getDisplayedIconName(ItemStack mail) {
        if (Mail.isReturned(mail)) {
            return Component.translatable((String)"gui.envelope.mail.returned");
        }
        Address sender = Mail.getSenderOrUnknown(mail);
        if (sender.equals(Address.UNKNOWN)) {
            return Component.translatable((String)"address.envelope.unknown");
        }
        if (sender.equals(Address.MAIL_SERVICE)) {
            return Component.translatable((String)"address.envelope.mail_service");
        }
        return switch (sender.type()) {
            default -> throw new MatchException(null, null);
            case Address.Type.BLOCK -> Component.translatable((String)"address.envelope.type.block");
            case Address.Type.PLAYER -> Component.translatable((String)"address.envelope.type.player");
            case Address.Type.ENTITY -> Component.translatable((String)"address.envelope.type.entity");
        };
    }

    protected Address getDisplayedSender(ItemStack mail) {
        return Mail.getSenderOrUnknown(mail);
    }

    protected boolean isMouseOver(Rect2i rect, double mouseX, double mouseY) {
        return mouseX >= (double)rect.getX() && mouseX < (double)(rect.getX() + rect.getWidth()) && mouseY >= (double)rect.getY() && mouseY < (double)(rect.getY() + rect.getHeight());
    }
}

