/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.inventory.PackingMenu;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class PackingScreen
extends AbstractContainerScreen<PackingMenu> {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/packing.png");
    public static final WidgetSprites PACK_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("packing_box/pack_button"));
    protected ImageButton packButton;

    public PackingScreen(PackingMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 178;
        super.init();
        this.inventoryLabelY = this.imageHeight - 94;
        this.packButton = (ImageButton)this.addRenderableWidget((GuiEventListener)new ImageButton(this.leftPos + 126, this.topPos + 40, 26, 20, PACK_BUTTON_SPRITES, button -> this.pack(), (Component)Component.translatable((String)"gui.envelope.package.pack")));
        this.packButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.package.pack").append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.envelope.package.pack.tooltip.packs_remaining", (Object[])new Object[]{this.getPrettyPacksRemaining()}))));
    }

    protected String getPrettyPacksRemaining() {
        int count = ((PackingMenu)this.getMenu()).getPackage().getRemainingPacks(((PackingMenu)this.getMenu()).getBoxStack());
        if (count > 99) {
            return ">99";
        }
        return Integer.toString(count);
    }

    protected void pack() {
        ((PackingMenu)this.getMenu()).clickMenuButton(((PackingMenu)this.getMenu()).getPlayer(), 0);
        Minecrft.gameMode().handleInventoryButtonClick(((PackingMenu)this.getMenu()).containerId, 0);
        this.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.packButton.visible = ((PackingMenu)this.getMenu()).needsPacking() && ((PackingMenu)this.getMenu()).canPack();
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((PackingMenu)this.getMenu()).isPackageDestroyedOnClose()) {
            guiGraphics.blit(TEXTURE, this.leftPos + 45, this.topPos + 17, 0, 178, 86, 64);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        super.renderSlot(guiGraphics, slot);
        if (slot instanceof DisabledSlot) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, slot.x - 1, slot.y - 1, 176, 0, 18, 18);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
        }
    }
}

