/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.RequestedItemDisplay;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.inventory.PaybackPackingMenu;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import io.github.mortuusars.envelope.world.inventory.slot.PreviewSlot;
import io.github.mortuusars.envelope.world.inventory.slot.RequestedItemSlot;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class PaybackPackingScreen
extends AbstractContainerScreen<PaybackPackingMenu> {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/payback_packing.png");
    public static final WidgetSprites PACK_BUTTON_SPRITES = Sprites.threeStates(Envelope.resource("payback_packing_box/pack_button"));
    protected ImageButton packButton;

    public PaybackPackingScreen(PaybackPackingMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 176;
        this.imageHeight = 178;
        super.init();
        this.inventoryLabelY = this.imageHeight - 94;
        this.packButton = new ImageButton(this.leftPos + 126, this.topPos + 40, 26, 20, PACK_BUTTON_SPRITES, button -> this.pack(), (Component)Component.translatable((String)"gui.envelope.package.pack"));
        this.packButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.package.pack").append(CommonComponents.NEW_LINE).append((Component)Component.translatable((String)"gui.envelope.package.pack.tooltip.packs_remaining", (Object[])new Object[]{this.getPrettyPacksRemaining()}))));
        this.addRenderableWidget((GuiEventListener)this.packButton);
    }

    protected String getPrettyPacksRemaining() {
        int count = ((PaybackPackingMenu)this.getMenu()).getPackage().getRemainingPacks(((PaybackPackingMenu)this.getMenu()).getBoxStack());
        if (count > 99) {
            return ">99";
        }
        return Integer.toString(count);
    }

    protected void pack() {
        ((PaybackPackingMenu)this.getMenu()).clickMenuButton(((PaybackPackingMenu)this.getMenu()).getPlayer(), 0);
        Minecrft.gameMode().handleInventoryButtonClick(((PaybackPackingMenu)this.getMenu()).containerId, 0);
        this.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        this.packButton.visible = ((PaybackPackingMenu)this.getMenu()).needsPacking() && ((PaybackPackingMenu)this.getMenu()).canPack();
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        if (((PaybackPackingMenu)this.getMenu()).isPackageDestroyedOnClose()) {
            guiGraphics.blit(TEXTURE, this.leftPos + 45, this.topPos + 17, 0, 178, 86, 64);
        }
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof RequestedItemSlot) {
            RequestedItemSlot requestedItemSlot = (RequestedItemSlot)slot;
            if (!slot.hasItem()) {
                RequestedItemDisplay display = new RequestedItemDisplay(requestedItemSlot.getRequestedItem());
                ItemStack preview = display.getDisplayedItem();
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, -100.0f);
                guiGraphics.renderItem(preview, slot.x, slot.y);
                guiGraphics.renderItemDecorations(Minecrft.get().font, preview, slot.x, slot.y);
                if (requestedItemSlot.getRequestedItem().item().left().isPresent()) {
                    guiGraphics.pose().translate(0.0f, 0.0f, 200.0f);
                    guiGraphics.drawString(this.font, "#", slot.x + 1 + 19 - 2 - this.font.width("#"), slot.y - 1, -1, true);
                }
                guiGraphics.pose().popPose();
            }
            boolean isFulfilled = requestedItemSlot.getRequestedItem().matches(slot.getItem());
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 150.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, slot.x - 1, slot.y - 1, 176, isFulfilled ? 54 : 36, 18, 18);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
        }
        super.renderSlot(guiGraphics, slot);
        this.renderSlotOverlays(guiGraphics, slot);
    }

    protected void renderSlotOverlays(GuiGraphics guiGraphics, Slot slot) {
        if (slot instanceof DisabledSlot) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, slot.x - 1, slot.y - 1, 176, 0, 18, 18);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
        }
        if (slot instanceof PreviewSlot) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, slot.x - 1, slot.y - 1, 176, 18, 18, 18);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        RequestedItemSlot requestedItemSlot;
        Slot slot;
        super.renderTooltip(guiGraphics, x, y);
        if (((PaybackPackingMenu)this.menu).getCarried().isEmpty() && (slot = this.hoveredSlot) instanceof RequestedItemSlot && !(requestedItemSlot = (RequestedItemSlot)slot).hasItem()) {
            ItemStack stack = requestedItemSlot.getRequestedItemPreview();
            List lines = (List)requestedItemSlot.getRequestedItem().item().map(tag -> {
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>(this.getTooltipFromContainerItem(stack));
                list.addLast(Component.literal((String)"Accepts Tag:").withStyle(ChatFormatting.GRAY));
                list.addLast(Component.literal((String)("#" + String.valueOf(tag.location()))).withStyle(ChatFormatting.GRAY));
                return list;
            }, item -> this.getTooltipFromContainerItem(stack));
            guiGraphics.renderTooltip(this.font, lines, stack.getTooltipImage(), x, y);
        }
    }
}

