/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.Sprites;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.inventory.PaybackTagMenu;
import io.github.mortuusars.envelope.world.inventory.slot.DisabledSlot;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class PaybackTagScreen
extends AbstractContainerScreen<PaybackTagMenu> {
    public static final ResourceLocation TEXTURE = Envelope.resource("textures/gui/payback_tag.png");
    protected ImageButton confirmButton;

    public PaybackTagScreen(PaybackTagMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        this.imageWidth = 186;
        this.imageHeight = 154;
        super.init();
        this.inventoryLabelY = this.imageHeight - 94;
        this.inventoryLabelX = 12;
        this.titleLabelX = this.imageWidth / 2 - this.font.width((FormattedText)this.getTitle()) / 2;
        this.confirmButton = new ImageButton(this.leftPos + 128, this.topPos + 28, 19, 19, Sprites.CONFIRM_BUTTON_SPRITES, button -> this.confirm(), (Component)Component.translatable((String)"gui.envelope.confirm"));
        this.confirmButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.envelope.confirm")));
        this.addRenderableWidget((GuiEventListener)this.confirmButton);
    }

    protected void confirm() {
        ((PaybackTagMenu)this.getMenu()).clickMenuButton(((PaybackTagMenu)this.getMenu()).getPlayer(), 0);
        Minecrft.gameMode().handleInventoryButtonClick(((PaybackTagMenu)this.getMenu()).containerId, 0);
        this.onClose();
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTargetPreview(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        guiGraphics.blit(TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
    }

    protected void renderSlot(GuiGraphics guiGraphics, Slot slot) {
        super.renderSlot(guiGraphics, slot);
        if (slot instanceof DisabledSlot) {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 300.0f);
            RenderSystem.enableBlend();
            guiGraphics.blit(TEXTURE, slot.x - 1, slot.y - 1, 186, 0, 18, 18);
            RenderSystem.disableBlend();
            guiGraphics.pose().popPose();
        }
    }

    protected void renderTargetPreview(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        ItemStack target = ((PaybackTagMenu)this.getMenu()).getTag().getItemStack();
        if (target.isEmpty()) {
            return;
        }
        float scale = 2.0f;
        int size = (int)(16.0f * scale);
        int x = this.leftPos - size - 4;
        int y = this.topPos + 36 - size / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)x + (float)size / 2.0f, (float)y + (float)size / 2.0f, 0.0f);
        guiGraphics.pose().scale(scale, scale, scale);
        guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
        guiGraphics.renderItem(target, 0, 0);
        guiGraphics.pose().popPose();
        if (this.isHovering(x - this.leftPos, y - this.topPos, size, size, mouseX, mouseY)) {
            guiGraphics.renderTooltip(this.font, target, mouseX, mouseY);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.hoveredSlot != null && this.hoveredSlot.index < 6) {
            boolean decreasing = scrollY < 0.0;
            boolean fast = Screen.hasShiftDown();
            this.changeRequestedItemCount(decreasing, fast);
            return true;
        }
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (this.hoveredSlot != null && this.hoveredSlot.index < 6) {
            if (keyCode == 334 || keyCode == 61) {
                this.changeRequestedItemCount(false, Screen.hasShiftDown());
                return true;
            }
            if (keyCode == 333 || keyCode == 45) {
                this.changeRequestedItemCount(true, Screen.hasShiftDown());
                return true;
            }
        }
        return false;
    }

    protected void changeRequestedItemCount(boolean decreasing, boolean fast) {
        if (this.hoveredSlot == null) {
            return;
        }
        int startId = decreasing ? 112 : 100;
        int id = startId + this.hoveredSlot.index + (fast ? 6 : 0);
        ((PaybackTagMenu)this.getMenu()).clickMenuButton(((PaybackTagMenu)this.getMenu()).getPlayer(), id);
        Minecrft.gameMode().handleInventoryButtonClick(((PaybackTagMenu)this.getMenu()).containerId, id);
    }
}

