/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.tooltip;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public class CompositeTooltipComponent
implements ClientTooltipComponent {
    private final List<ClientTooltipComponent> components;

    public CompositeTooltipComponent(List<ClientTooltipComponent> components) {
        this.components = components;
    }

    public int getWidth(Font font) {
        int width = 0;
        for (ClientTooltipComponent component : this.components) {
            width = Math.max(component.getWidth(font), width);
        }
        return width;
    }

    public int getHeight() {
        int height = 0;
        for (ClientTooltipComponent component : this.components) {
            height += component.getHeight();
        }
        return height;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        for (ClientTooltipComponent component : this.components) {
            component.renderImage(font, x, y, guiGraphics);
            y += component.getHeight();
        }
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        for (ClientTooltipComponent component : this.components) {
            component.renderText(font, mouseX, mouseY, matrix, bufferSource);
            mouseY += component.getHeight();
        }
    }
}

