/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.tooltip;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.mail.address.Address;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public class MailAddressTagTooltipComponent
implements ClientTooltipComponent {
    private static final ItemStack ADDRESS_TAG = new ItemStack((ItemLike)Envelope.Items.ADDRESS_TAG.get());
    @NotNull
    private final Component component;

    public MailAddressTagTooltipComponent(Address address) {
        this.component = address.format().withIcon().withIconColor(-1651816).withColor(-1651816).toComponent();
    }

    public int getWidth(Font font) {
        return 19 + font.width((FormattedText)this.component);
    }

    public int getHeight() {
        return 16;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        guiGraphics.renderFakeItem(ADDRESS_TAG, x - 1, y - 1, 0);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        this.drawText(font, this.component, x + 18, y + 3, matrix, bufferSource);
    }

    private void drawText(Font font, Component component, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        font.drawInBatch(component, (float)x, (float)y, 0, true, matrix, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    private boolean isEmpty(Component component) {
        return component.equals((Object)CommonComponents.EMPTY);
    }
}

