/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.tooltip;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.item.component.PaybackTagContents;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public record PaybackTagContentsTooltipComponent(PaybackTagContents contents) implements ClientTooltipComponent
{
    public static final ResourceLocation SLOT_SPRITE = Envelope.resource("tooltip/payback/slot");

    public int getWidth(Font font) {
        return !this.contents.isEmpty() ? 18 * this.contents().items().size() + 4 : 0;
    }

    public int getHeight() {
        return !this.contents.isEmpty() ? 24 : 0;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.contents.isEmpty()) {
            return;
        }
        List<ItemStack> items = this.contents().items().stream().filter(i -> !i.isEmpty()).toList();
        int slots = items.size();
        for (int i2 = 0; i2 < slots; ++i2) {
            ItemStack stack = items.get(i2);
            int slotX = x + 2 + i2 * 18;
            int slotY = y + 2;
            if (i2 == 0) {
                guiGraphics.blitSprite(SLOT_SPRITE, 22, 22, 0, 0, slotX - 2, y, 2, 22);
            }
            if (i2 == slots - 1) {
                guiGraphics.blitSprite(SLOT_SPRITE, 22, 22, 20, 0, slotX + 18, y, 2, 22);
            }
            guiGraphics.blitSprite(SLOT_SPRITE, 22, 22, 2, 0, slotX, y, 18, 22);
            guiGraphics.renderFakeItem(stack, slotX + 1, slotY + 1, 0);
            guiGraphics.renderItemDecorations(font, stack, slotX + 1, slotY + 1);
        }
    }
}

