/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.tooltip;

import io.github.mortuusars.envelope.EnvelopeClient;
import io.github.mortuusars.envelope.world.item.component.seal.Seal;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.joml.Matrix4f;

public class SealTooltipComponent
implements ClientTooltipComponent {
    protected final Seal seal;

    public SealTooltipComponent(Seal seal) {
        this.seal = seal;
    }

    public int getWidth(Font font) {
        return 35 + font.width((FormattedText)this.seal.signature());
    }

    public int getHeight() {
        return 32;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        EnvelopeClient.getSealRenderer().render(this.seal, guiGraphics, x, y);
    }

    public void renderText(Font font, int x, int y, Matrix4f matrix, MultiBufferSource.BufferSource buffer) {
        int color = ((SealMaterial)this.seal.material().value()).impressionPalette().highlight().tint();
        int outlineColor = ((SealMaterial)this.seal.material().value()).impressionPalette().shadow().tint();
        this.text(this.seal.signature(), font, (x += 34) - 1, y += 11, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x - 1, y - 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x, y - 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x + 1, y - 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x + 1, y, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x + 1, y + 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x, y + 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x - 1, y + 1, outlineColor, matrix, buffer);
        this.text(this.seal.signature(), font, x, y, color, matrix, buffer);
    }

    private void text(Component text, Font font, int x, int y, int color, Matrix4f matrix, MultiBufferSource.BufferSource buffer) {
        font.drawInBatch(text, (float)x, (float)y, color, false, matrix, (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }
}

