/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget;

import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressFormatter;
import io.github.mortuusars.envelope.world.mail.address.AllAddresses;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class AddressBoxSuggestions
extends AbstractWidget {
    protected final Font font;
    protected final EditBox editBox;
    protected final AllAddresses addresses;
    protected final List<Suggestion> suggestions;
    protected int maxDisplayedLines;
    protected int selectedIndex;
    protected int scroll;
    protected boolean show;

    public AddressBoxSuggestions(EditBox addressBox, AllAddresses addresses, int maxDisplayedLines) {
        super(addressBox.getX(), addressBox.getY() + addressBox.getHeight() + 3, addressBox.getWidth(), 1, (Component)Component.empty());
        this.font = Minecrft.get().font;
        this.suggestions = new ArrayList<Suggestion>();
        this.selectedIndex = 0;
        this.scroll = 0;
        this.editBox = addressBox;
        this.addresses = addresses;
        this.maxDisplayedLines = maxDisplayedLines;
    }

    public void update() {
        this.suggestions.clear();
        this.selectedIndex = 0;
        this.setScroll(0);
        this.editBox.setSuggestion(null);
        String text = this.editBox.getValue();
        if (!this.addresses.isKnown(text)) {
            this.suggestions.addAll(((Suggestions)SharedSuggestionProvider.suggest(this.addresses.stream().map(Address::toString), (SuggestionsBuilder)new SuggestionsBuilder(text, 0)).join()).getList());
            this.show = !text.isEmpty();
        }
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.show) {
            return;
        }
        int lineHeight = 11;
        this.setHeight(lineHeight * Math.min(this.maxDisplayedLines, this.suggestions.size()));
        int y = this.getY();
        int hoveredIndex = this.getHoveredSuggestionIndex(mouseX, mouseY);
        for (int i = this.scroll; i < Math.min(this.maxDisplayedLines + this.scroll, this.suggestions.size()); ++i) {
            Object text;
            Suggestion suggestion = this.suggestions.get(i);
            boolean selected = i == this.selectedIndex;
            int textColor = selected ? -1198776 : -1;
            int fillColor = selected ? -805306368 : -804187887;
            guiGraphics.fill(this.getX() - 13, y, this.getX() + this.getWidth(), y + lineHeight, fillColor);
            String icon = this.addresses.byName(suggestion.getText()).map(AddressFormatter::getIcon).orElse("");
            if (!icon.isBlank()) {
                int iconColor = selected ? textColor : -5592406;
                guiGraphics.drawString(this.font, icon, this.getX() - 9, y + 1, iconColor, true);
            }
            if (this.font.width((String)(text = suggestion.getText())) > this.getWidth()) {
                String ellipsis = "...";
                text = this.font.plainSubstrByWidth(suggestion.getText(), this.getWidth() - this.font.width(ellipsis)) + ellipsis;
                if (hoveredIndex == i) {
                    guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)suggestion.getText()), mouseX, mouseY);
                }
            }
            guiGraphics.drawString(this.font, (String)text, this.getX(), y + 1, textColor, true);
            y += lineHeight;
        }
        this.renderScrollBar(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected void renderScrollBar(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.suggestions.isEmpty() && this.suggestions.size() > this.maxDisplayedLines) {
            int trackHeight = this.getHeight() - 2;
            int maxScroll = this.suggestions.size() - this.maxDisplayedLines;
            int thumbHeight = trackHeight * this.maxDisplayedLines / this.suggestions.size();
            float scrollRatio = maxScroll != 0 ? (float)this.scroll / (float)maxScroll : 0.0f;
            int thumbY = (int)((float)(trackHeight - thumbHeight) * scrollRatio);
            guiGraphics.fill(this.getX() + this.getWidth(), this.getY(), this.getX() + this.getWidth() + 3, this.getY() + this.getHeight(), -804187887);
            guiGraphics.fill(this.getX() + this.getWidth() + 1, this.getY() + thumbY + 1, this.getX() + this.getWidth() + 2, this.getY() + thumbY + thumbHeight + 1, -5592406);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 341) {
            this.show = !this.show;
            return true;
        }
        if (!this.show) {
            return false;
        }
        if (keyCode == 265) {
            this.select(this.selectedIndex - 1);
            return true;
        }
        if (keyCode == 264) {
            this.select(this.selectedIndex + 1);
            return true;
        }
        if (keyCode == 258) {
            this.getSelected().ifPresent(suggestion -> this.editBox.setValue(suggestion.getText()));
            Minecrft.get().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            return true;
        }
        return false;
    }

    public void mouseMoved(double mouseX, double mouseY) {
        if (!this.show) {
            return;
        }
        int hoveredSuggestion = this.getHoveredSuggestionIndex(mouseX, mouseY);
        if (hoveredSuggestion >= 0 && this.selectedIndex != hoveredSuggestion) {
            this.select(hoveredSuggestion);
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.show) {
            return false;
        }
        if (this.isActive() && this.isHoveredOrFocused()) {
            this.setScroll(this.scroll - Mth.sign((double)scrollY));
            return true;
        }
        return false;
    }

    public void scrollTo(int index) {
        int currentStart = this.scroll;
        int currentEnd = this.scroll + this.maxDisplayedLines - 1;
        if (index < currentStart) {
            this.setScroll(index);
        } else if (index > currentEnd) {
            this.setScroll(index - this.maxDisplayedLines + 1);
        } else {
            this.setScroll(this.scroll);
        }
    }

    public void setScroll(int value) {
        this.scroll = Mth.clamp((int)value, (int)0, (int)Math.max(0, this.suggestions.size() - this.maxDisplayedLines));
    }

    public void select(int index) {
        if (index < 0) {
            index = this.suggestions.size() - 1;
        } else if (index >= this.suggestions.size()) {
            index = 0;
        }
        this.selectedIndex = Mth.clamp((int)index, (int)0, (int)(this.suggestions.size() - 1));
        this.scrollTo(this.selectedIndex);
        this.getSelected().ifPresent(suggestion -> {
            String suffix = this.calculateSuggestionSuffix(this.editBox.getValue(), suggestion.getText());
            this.editBox.setSuggestion(suffix);
        });
    }

    @Nullable
    protected String calculateSuggestionSuffix(String inputText, String suggestionText) {
        return suggestionText.startsWith(inputText) ? suggestionText.substring(inputText.length()) : null;
    }

    public Optional<Suggestion> getSelected() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.suggestions.size()) {
            return Optional.empty();
        }
        return Optional.of(this.suggestions.get(this.selectedIndex));
    }

    public void onClick(double mouseX, double mouseY) {
        if (!this.show) {
            return;
        }
        int hoveredSuggestion = this.getHoveredSuggestionIndex(mouseX, mouseY);
        if (hoveredSuggestion >= 0 && hoveredSuggestion < this.suggestions.size()) {
            this.editBox.setValue(this.suggestions.get(hoveredSuggestion).getText());
        }
    }

    public int getHoveredSuggestionIndex(double mouseX, double mouseY) {
        if (this.suggestions.isEmpty() || mouseX < (double)this.getX() || mouseX >= (double)(this.getX() + this.getWidth()) || mouseY < (double)this.getY() || mouseY >= (double)(this.getY() + 11 * Math.min(this.maxDisplayedLines, this.suggestions.size()))) {
            return -1;
        }
        int y = (int)(mouseY - (double)this.getY());
        return Mth.clamp((int)(y / 11 + this.scroll), (int)this.scroll, (int)(this.suggestions.size() - 1));
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

