/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget.textbox;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.envelope.client.gui.widget.textbox.display.FormattedStringDisplayCache;
import io.github.mortuusars.envelope.client.gui.widget.textbox.display.FormattingToolbar;
import io.github.mortuusars.envelope.client.gui.widget.textbox.display.HorizontalAlignment;
import io.github.mortuusars.envelope.client.gui.widget.textbox.display.Line;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.FormattedStringEditor;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.Formatting;
import io.github.mortuusars.envelope.client.util.Pos2i;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextBox
extends AbstractWidget {
    protected FormattedStringEditor editor = new FormattedStringEditor(() -> FormattedStringEditor.Validator.fitInDimensions(this.getFont(), this.getWidth(), this.getHeight()));
    protected FormattedStringDisplayCache displayCache = new FormattedStringDisplayCache(this.editor);
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected Font font;
    protected int fontColor = -16777216;
    protected int fontUnfocusedColor = -16777216;
    protected int selectionColor = -16776961;
    protected int selectionUnfocusedColor = -2013265665;
    protected Consumer<FormattedString> onTextChanged = text -> {};
    protected boolean formattingEnabled = true;
    @Nullable
    protected Component hint = null;
    protected int hintColor = 0x77000000;
    @Nullable
    protected FormattedString autocompleteSuggestion = null;
    protected int autocompleteSuggestionColor = 0x77000000;
    protected FormattingToolbar formattingToolbar = new FormattingToolbar(this);
    protected Pos2i lastClickPos = new Pos2i(0, 0);
    protected long lastActionTime;
    protected boolean canDrag;

    public TextBox(int x, int y, int width, int height) {
        this(Minecraft.getInstance().font, x, y, width, height);
    }

    public TextBox(Font font, int x, int y, int width, int height) {
        super(x, y, width, height, (Component)Component.empty());
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public TextBox setFont(Font font) {
        this.font = font;
        this.refreshDisplayCache();
        return this;
    }

    public FormattedStringEditor getEditor() {
        return this.editor;
    }

    public FormattedStringDisplayCache getDisplayCache() {
        if (this.displayCache.shouldUpdate()) {
            this.displayCache.update(this.getFont(), this.getWidth(), this.getHeight(), this.getHorizontalAlignment());
        }
        return this.displayCache;
    }

    public FormattingToolbar getFormattingToolbar() {
        if (this.formattingToolbar.shouldUpdate()) {
            this.formattingToolbar.update();
        }
        return this.formattingToolbar;
    }

    public TextBox setFormattingToolbar(FormattingToolbar formattingToolbar) {
        this.formattingToolbar = formattingToolbar;
        this.formattingToolbar.scheduleUpdate();
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public TextBox setHorizontalAlignment(HorizontalAlignment horizontalAlignment) {
        this.horizontalAlignment = horizontalAlignment;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public TextBox setFontColor(int fontColor) {
        this.fontColor = fontColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getFontUnfocusedColor() {
        return this.fontUnfocusedColor;
    }

    public TextBox setFontUnfocusedColor(int fontUnfocusedColor) {
        this.fontUnfocusedColor = fontUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionColor() {
        return this.selectionColor;
    }

    public TextBox setSelectionColor(int selectionColor) {
        this.selectionColor = selectionColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getSelectionUnfocusedColor() {
        return this.selectionUnfocusedColor;
    }

    public TextBox setSelectionUnfocusedColor(int selectionUnfocusedColor) {
        this.selectionUnfocusedColor = selectionUnfocusedColor;
        this.refreshDisplayCache();
        return this;
    }

    public int getCurrentFontColor() {
        return this.isFocused() ? this.fontColor : this.fontUnfocusedColor;
    }

    public int getCurrentSelectionColor() {
        return this.isFocused() ? this.selectionColor : this.selectionUnfocusedColor;
    }

    public boolean isFormattingEnabled() {
        return this.formattingEnabled;
    }

    public TextBox setFormattingEnabled(boolean formattingEnabled) {
        this.formattingEnabled = formattingEnabled;
        this.getEditor().setFormattingEnabled(formattingEnabled);
        return this;
    }

    public TextBox setTextValidator(Predicate<String> validator) {
        this.getEditor().setValidator(validator);
        return this;
    }

    public Consumer<FormattedString> onTextChanged() {
        return this.onTextChanged;
    }

    public TextBox setOnTextChanged(Consumer<FormattedString> onTextChanged) {
        this.onTextChanged = onTextChanged;
        return this;
    }

    public TextBox setText(FormattedString text) {
        this.getEditor().setText(text);
        this.getEditor().setCursorPos(this.getEditor().length(), false);
        return this;
    }

    public TextBox setTextAndUpdate(FormattedString text) {
        this.setText(text);
        this.onTextChanged().accept(this.getEditor().getText());
        this.getDisplayCache().scheduleUpdate();
        return this;
    }

    public TextBox clearText() {
        this.setTextAndUpdate(FormattedString.parse(""));
        return this;
    }

    @Nullable
    public Component getHint() {
        return this.hint;
    }

    public TextBox setHint(Component hint) {
        this.hint = hint;
        return this;
    }

    public int getHintColor() {
        return this.hintColor;
    }

    public TextBox setHintColor(int color) {
        this.hintColor = color;
        return this;
    }

    @Nullable
    public FormattedString getAutocompleteSuggestion() {
        return this.autocompleteSuggestion;
    }

    public TextBox setAutocompleteSuggestion(FormattedString suggestion) {
        this.autocompleteSuggestion = suggestion;
        return this;
    }

    public int getAutocompleteSuggestionColor() {
        return this.autocompleteSuggestionColor;
    }

    public TextBox setAutocompleteSuggestionColor(int color) {
        this.autocompleteSuggestionColor = color;
        return this;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int x;
        FormattedStringDisplayCache displayCache = this.getDisplayCache();
        if (this.getHint() != null && !this.isFocused() && this.getEditor().getText().toString().isBlank()) {
            x = this.getX() + this.getHorizontalAlignment().align(this.getWidth(), this.font.width((FormattedText)this.getHint()));
            guiGraphics.drawString(this.font, this.getHint(), x, this.getY(), this.getHintColor(), false);
        }
        if (this.getAutocompleteSuggestion() != null && this.isFocused()) {
            x = this.getX() + this.getHorizontalAlignment().align(this.getWidth(), this.font.width((FormattedText)this.getAutocompleteSuggestion()));
            String string = this.getAutocompleteSuggestion().toString().substring(Math.max(0, this.getEditor().length()));
            guiGraphics.drawString(this.font, string, x += this.font.width(this.getEditor().getText().toString()), this.getY(), this.getAutocompleteSuggestionColor(), false);
        }
        this.renderLines(guiGraphics, mouseX, mouseY, partialTick, displayCache.getLines(), this.getCurrentFontColor());
        int cursorColor = this.getCurrentFontColor();
        Formatting currentFormatting = this.getEditor().getFormattingAtCursor();
        if (currentFormatting.color() != null) {
            cursorColor = currentFormatting.color().asChatFormatting().getColor() | 0xFF000000;
        }
        this.renderCursor(guiGraphics, mouseX, mouseY, partialTick, this.getEditor(), displayCache.getCursor(), cursorColor);
        this.renderSelection(guiGraphics, mouseX, mouseY, partialTick, displayCache.getSelection(), this.getCurrentSelectionColor());
        if (this.isFormattingEnabled()) {
            this.getFormattingToolbar().render(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    public void renderLines(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, List<Line> lines, int color) {
        for (Line line : lines) {
            guiGraphics.drawString(this.font, line.renderedString(), this.getX() + line.x(), this.getY() + line.y(), color, false);
        }
    }

    public void renderSelection(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, List<Rect2i> selection, int color) {
        for (Rect2i rect : selection) {
            int x0 = this.getX() + rect.getX();
            int y0 = this.getY() + rect.getY();
            int x1 = x0 + rect.getWidth();
            int y1 = y0 + rect.getHeight();
            guiGraphics.fill(RenderType.guiTextHighlight(), x0, y0, x1, y1, color);
        }
    }

    public void renderCursor(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick, FormattedStringEditor editor, Pos2i cursor, int color) {
        if (!this.isFocused()) {
            return;
        }
        if (editor.isSelecting()) {
            return;
        }
        if (System.currentTimeMillis() - this.lastActionTime > 200L && (System.currentTimeMillis() - this.lastActionTime) % 600L > 300L) {
            return;
        }
        if (editor.isCursorAtEnd()) {
            Line line = this.getDisplayCache().getLine(this.getDisplayCache().getLines().size() - 1);
            int n = cursor.y;
            Objects.requireNonNull(this.font);
            if (n + 9 > this.getHeight()) {
                int x = line.x() + line.width();
                int y = line.y();
                guiGraphics.drawString(this.getFont(), "<", this.getX() + x, this.getY() + y, color, false);
            } else {
                guiGraphics.drawString(this.getFont(), "_", this.getX() + cursor.x, this.getY() + cursor.y, color, false);
            }
        } else {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate(0.0f, 0.0f, 50.0f);
            RenderSystem.disableBlend();
            int n = this.getX() + cursor.x;
            int n2 = this.getY() + cursor.y - 1;
            int n3 = this.getX() + cursor.x + 1;
            int n4 = this.getY() + cursor.y;
            Objects.requireNonNull(this.font);
            guiGraphics.fill(n, n2, n3, n4 + 9, color);
            guiGraphics.pose().popPose();
        }
    }

    protected void refreshDisplayCache() {
        this.displayCache.scheduleUpdate();
        if (this.isFormattingEnabled()) {
            this.formattingToolbar.scheduleUpdate();
        }
    }

    public boolean canConsumeInput() {
        return this.isActive() && this.isFocused();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!(this.isFocused() && this.isActive() && this.visible)) {
            return false;
        }
        if (this.handleKeyPressed(keyCode, scanCode, modifiers)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getText());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    protected boolean handleKeyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.isFormattingEnabled() && this.getFormattingToolbar().keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        if (keyCode == 258 && this.getAutocompleteSuggestion() != null) {
            this.getEditor().setText(this.getAutocompleteSuggestion());
            this.getEditor().setCursorToEnd(false);
            return true;
        }
        if (keyCode == 265) {
            this.changeLine(-1);
            return true;
        }
        if (keyCode == 264) {
            this.changeLine(1);
            return true;
        }
        if (keyCode == 268) {
            this.keyHome();
            return true;
        }
        if (keyCode == 269) {
            this.keyEnd();
            return true;
        }
        return this.getEditor().keyPressed(keyCode);
    }

    public boolean charTyped(char codePoint, int modifiers) {
        if (this.isFocused() && this.getEditor().charTyped(codePoint)) {
            this.lastActionTime = System.currentTimeMillis();
            this.onTextChanged().accept(this.getEditor().getText());
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (!this.isActive() || !this.visible) {
            return false;
        }
        if (this.formattingToolbarMouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (this.isHovered && button == 0) {
            long currentTime = System.currentTimeMillis();
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.getX()), (int)(mouseY - (double)this.getY()));
            if (Math.abs(this.lastClickPos.x - (int)mouseX) < 4 && Math.abs(this.lastClickPos.y - (int)mouseY) < 4 && currentTime - this.lastActionTime < 250L) {
                if (!this.getEditor().isSelecting()) {
                    this.getEditor().selectWord(indexAtMousePos);
                } else {
                    this.getEditor().selectAll();
                }
            } else {
                this.getEditor().setCursorPos(indexAtMousePos, Screen.hasShiftDown());
            }
            this.refreshDisplayCache();
            this.lastClickPos = new Pos2i((int)mouseX, (int)mouseY);
            this.lastActionTime = currentTime;
            this.canDrag = true;
            return true;
        }
        if (!this.isHovered) {
            this.getEditor().clearSelection();
            this.refreshDisplayCache();
        }
        return false;
    }

    public boolean formattingToolbarMouseClicked(double mouseX, double mouseY, int button) {
        if (this.isFormattingEnabled() && this.getFormattingToolbar().mouseClicked(mouseX, mouseY, button)) {
            this.refreshDisplayCache();
            this.onTextChanged().accept(this.getEditor().getText());
            this.canDrag = false;
            return true;
        }
        return false;
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (button == 0 && this.canDrag) {
            FormattedStringDisplayCache display = this.getDisplayCache();
            int indexAtMousePos = display.getCharIndexAtPosition(this.font, (int)(mouseX - (double)this.getX()), (int)(mouseY - (double)this.getY()));
            this.getEditor().setCursorPos(indexAtMousePos, true);
            this.refreshDisplayCache();
            return true;
        }
        return false;
    }

    public void changeLine(int yChange) {
        Pos2i cursor = this.getDisplayCache().getCursor();
        int x = cursor.x;
        int n = cursor.y;
        Objects.requireNonNull(this.font);
        int y = n + 9 * yChange;
        int index = this.getDisplayCache().getCharIndexAtPosition(this.font, x, y);
        this.getEditor().setCursorPos(index, Screen.hasShiftDown());
    }

    public void keyHome() {
        if (Screen.hasControlDown()) {
            this.getEditor().setCursorToStart(Screen.hasShiftDown());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.firstCharIndex(), Screen.hasShiftDown());
        }
    }

    public void keyEnd() {
        if (Screen.hasControlDown()) {
            this.getEditor().setCursorToEnd(Screen.hasShiftDown());
        } else {
            int cursorPos = this.getEditor().getCursorPos();
            int lineIndex = this.getDisplayCache().findLineIndexByCharIndex(cursorPos);
            Line line = this.getDisplayCache().getLine(lineIndex);
            this.getEditor().setCursorPos(line.lastCharIndex() + 1, Screen.hasShiftDown());
        }
    }

    @NotNull
    public Component getMessage() {
        return Component.literal((String)this.getEditor().getText().toStringWithoutFormatting());
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
        narrationElementOutput.add(NarratedElementType.TITLE, (Component)this.createNarrationMessage());
    }
}

