/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget.textbox.display;

import io.github.mortuusars.envelope.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.FormattedString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;

public class Line {
    protected Font font;
    protected FormattedString string;
    protected int firstCharIndex;
    protected int lastCharIndex;
    protected String renderedString;
    protected int width;
    protected int x;
    protected int y;

    public Line(Font font, FormattedString string, int firstCharIndex, int lastCharIndex, String renderedString, int width, int x, int y) {
        this.font = font;
        this.string = string;
        this.firstCharIndex = firstCharIndex;
        this.lastCharIndex = lastCharIndex;
        this.renderedString = renderedString;
        this.width = width;
        this.x = x;
        this.y = y;
    }

    public static Line empty() {
        return new Line(Minecraft.getInstance().font, new FormattedString(), 0, 0, "", 0, 0, 0);
    }

    public Font font() {
        return this.font;
    }

    public FormattedString getString() {
        return this.string;
    }

    public int firstCharIndex() {
        return this.firstCharIndex;
    }

    public int lastCharIndex() {
        return this.lastCharIndex;
    }

    public String renderedString() {
        return this.renderedString;
    }

    public int width() {
        return this.width;
    }

    public int x() {
        return this.x;
    }

    public int y() {
        return this.y;
    }

    public boolean isEmpty() {
        return this.getString().isEmpty();
    }

    public boolean endsWithNewLine() {
        return !this.getString().isEmpty() && ((Char)this.getString().get(this.getString().size() - 1)).character() == '\n';
    }

    public int width(Font font, int first, int last) {
        int width = 0;
        for (int i = first; i <= last; ++i) {
            width += ((Char)this.string.get(i)).getWidth(font, false);
        }
        return width;
    }

    public int widthToIndex(Font font, int index) {
        int width = 0;
        int endIndex = Math.min(index, this.string.size());
        for (int i = 0; i < endIndex; ++i) {
            width += ((Char)this.string.get(i)).getWidth(font, false);
        }
        return width;
    }

    public int indexAtWidth(Font font, int width) {
        if (width <= 0 || this.string.isEmpty()) {
            return this.firstCharIndex();
        }
        int currentWidth = 0;
        for (int i = 0; i < this.string.size(); ++i) {
            Char character = (Char)this.string.get(i);
            int charWidth = character.getWidth(font, false);
            if ((currentWidth += charWidth) - charWidth / 2 <= width) continue;
            return this.firstCharIndex() + i;
        }
        return ((Char)this.string.get(this.string.length() - 1)).character() == '\n' ? this.lastCharIndex() : this.lastCharIndex() + 1;
    }

    public String toString() {
        return this.getString().toStringWithoutFormatting();
    }
}

