/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget.textbox.text;

import io.github.mortuusars.envelope.client.gui.widget.textbox.text.Formatting;
import net.minecraft.client.gui.Font;

public record Char(char character, Formatting formatting) {
    public static final Char EMPTY = new Char('\u0000', Formatting.EMPTY);

    public Char(char c) {
        this(c, Formatting.EMPTY);
    }

    public Char(int c) {
        this((char)c);
    }

    public boolean hasFormatting() {
        return !this.formatting.isEmpty();
    }

    public boolean hasFormatting(Formatting.Type type) {
        if (type.isColor()) {
            return type.equals(this.formatting.color());
        }
        if (type.isFormat()) {
            return this.formatting.format().contains((Formatting.Format)type);
        }
        return false;
    }

    public Char withFormatting(Formatting.Color color) {
        return new Char(this.character, this.formatting.with(color));
    }

    public Char withFormatting(Formatting.Format format) {
        return new Char(this.character, this.formatting.with(format));
    }

    public Char withFormatting(Formatting formatting) {
        return new Char(this.character, formatting);
    }

    public Char flipFormatting(Formatting formatting) {
        return new Char(this.character, this.formatting().flip(formatting));
    }

    public int getWidth(Font font, boolean ignoreNewLine) {
        return ignoreNewLine && this.character == '\n' ? 0 : font.width(this.toStringWithFormatting());
    }

    public String toStringWithFormatting() {
        if (!this.hasFormatting()) {
            return Character.toString(this.character);
        }
        StringBuilder sb = new StringBuilder();
        this.formatting.append(sb);
        sb.append(this.character);
        if (this.hasFormatting()) {
            Formatting.RESET.append(sb);
        }
        return sb.toString();
    }
}

