/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.gui.widget.textbox.text;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.Char;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.FormattedString;
import io.github.mortuusars.envelope.client.gui.widget.textbox.text.Formatting;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;

public class FormattedStringEditor {
    protected FormattedString string = new FormattedString();
    protected int cursorPos;
    protected int selectionAnchor;
    protected boolean formattingEnabled = true;
    protected Predicate<String> validator;
    private boolean suppressNextCharTyped = false;

    public FormattedStringEditor(Predicate<String> validator) {
        this.validator = validator;
    }

    public FormattedStringEditor(Supplier<Predicate<String>> stringValidator) {
        this.validator = str -> ((Predicate)stringValidator.get()).test(str);
    }

    public FormattedString getText() {
        return this.string;
    }

    public void setText(FormattedString string) {
        this.string = string;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public int getSelectionAnchor() {
        return this.selectionAnchor;
    }

    public boolean isFormattingEnabled() {
        return this.formattingEnabled;
    }

    public FormattedStringEditor setFormattingEnabled(boolean formattingEnabled) {
        this.formattingEnabled = formattingEnabled;
        return this;
    }

    public Predicate<String> getValidator() {
        return this.validator;
    }

    public void setValidator(Predicate<String> validator) {
        this.validator = validator;
    }

    public int length() {
        return this.getText().size();
    }

    public List<Char> getSpan(int start, int end) {
        return this.getText().subList(start, end);
    }

    public List<Char> getSelectedSpan() {
        return this.getSpan(this.getSelectionStart(), this.getSelectionEnd());
    }

    public boolean isCursorAtStart() {
        return this.getCursorPos() == 0;
    }

    public boolean isCursorAtEnd() {
        return this.getCursorPos() == this.length();
    }

    public void setCursorPos(int index) {
        this.setCursorPos(index, true);
    }

    public void setCursorPos(int index, boolean keepSelection) {
        this.cursorPos = this.clampIndex(index);
        this.resetSelectionIfNeeded(keepSelection);
    }

    public void setCursorToStart(boolean keepSelection) {
        this.setCursorPos(0, keepSelection);
    }

    public void setCursorToEnd(boolean keepSelection) {
        this.setCursorPos(this.length(), keepSelection);
    }

    public void moveCursorBy(int direction, boolean keepSelection, CursorStep cursorStep) {
        switch (cursorStep.ordinal()) {
            case 0: {
                this.moveCursorByChars(direction, keepSelection);
                break;
            }
            case 1: {
                this.moveCursorByWords(direction, keepSelection);
            }
        }
    }

    public void moveCursorByChars(int direction, boolean keepSelection) {
        if (!keepSelection && this.isSelecting()) {
            this.setCursorPos(direction < 0 ? this.getSelectionStart() : this.getSelectionEnd(), false);
        } else {
            this.setCursorPos(Util.offsetByCodepoints((String)this.getText().toStringWithoutFormatting(), (int)this.getCursorPos(), (int)direction), keepSelection);
        }
    }

    public void moveCursorByWords(int direction, boolean keepSelection) {
        if (!keepSelection && this.isSelecting()) {
            this.setCursorPos(direction < 0 ? this.getSelectionStart() : this.getSelectionEnd(), false);
        } else {
            this.setCursorPos(StringSplitter.getWordPosition((String)this.getText().toStringWithoutFormatting(), (int)direction, (int)this.getCursorPos(), (boolean)true), keepSelection);
        }
    }

    public Formatting getFormattingAtCursor() {
        int charBeforeCursor = this.getCursorPos() - 1;
        if (charBeforeCursor >= 0 && charBeforeCursor < this.length()) {
            return ((Char)this.getText().get(charBeforeCursor)).formatting();
        }
        return Formatting.EMPTY;
    }

    public boolean isSelecting() {
        return this.getCursorPos() != this.getSelectionAnchor();
    }

    public int getSelectionStart() {
        return Math.min(this.getCursorPos(), this.getSelectionAnchor());
    }

    public int getSelectionEnd() {
        return Math.max(this.getCursorPos(), this.getSelectionAnchor());
    }

    public void setSelectionAnchor(int index) {
        this.selectionAnchor = this.clampIndex(index);
    }

    public void setSelectionRange(int start, int end) {
        this.setSelectionAnchor(start);
        this.setCursorPos(end, true);
    }

    public void clearSelection() {
        this.setSelectionAnchor(this.getCursorPos());
    }

    public void selectWord(int index) {
        this.setSelectionRange(StringSplitter.getWordPosition((String)this.getText().toStringWithoutFormatting(), (int)-1, (int)index, (boolean)false), StringSplitter.getWordPosition((String)this.getText().toStringWithoutFormatting(), (int)1, (int)index, (boolean)false));
    }

    public String getSelectedString(boolean withFormatting) {
        if (!this.isSelecting()) {
            return "";
        }
        FormattedString selectedString = this.getText().subString(this.getSelectionStart(), this.getSelectionEnd());
        return withFormatting ? selectedString.toString() : selectedString.toStringWithoutFormatting();
    }

    public boolean keyPressed(int key) {
        if (this.onKeyPressed(key)) {
            this.suppressNextCharTyped = true;
            return true;
        }
        this.suppressNextCharTyped = false;
        return false;
    }

    private boolean onKeyPressed(int key) {
        Formatting formatting;
        CursorStep cursorStep;
        if (Screen.isSelectAll((int)key)) {
            this.selectAll();
            return true;
        }
        if (key == 67 && Screen.hasControlDown() && !Screen.hasAltDown()) {
            this.copy(Screen.hasShiftDown());
            return true;
        }
        if (key == 86 && Screen.hasControlDown() && !Screen.hasAltDown()) {
            this.paste(Screen.hasShiftDown());
            return true;
        }
        if (key == 88 && Screen.hasControlDown() && !Screen.hasAltDown()) {
            this.cut(Screen.hasShiftDown());
            return true;
        }
        CursorStep cursorStep2 = cursorStep = Screen.hasControlDown() ? CursorStep.WORD : CursorStep.CHARACTER;
        if (key == 259) {
            this.removeFromCursor(-1, cursorStep);
            return true;
        }
        if (key == 261) {
            this.removeFromCursor(1, cursorStep);
            return true;
        }
        if (key == 263) {
            this.moveCursorBy(-1, Screen.hasShiftDown(), cursorStep);
            return true;
        }
        if (key == 262) {
            this.moveCursorBy(1, Screen.hasShiftDown(), cursorStep);
            return true;
        }
        if (key == 268) {
            this.setCursorToStart(Screen.hasShiftDown());
            return true;
        }
        if (key == 269) {
            this.setCursorToEnd(Screen.hasShiftDown());
            return true;
        }
        if (key == 257 || key == 335) {
            this.insertTextAtCursor("\n");
            return true;
        }
        if (this.isFormattingEnabled() && (formatting = this.handleFormattingKeys(key)) != null) {
            this.applyFormatting(formatting);
            return true;
        }
        return false;
    }

    protected Formatting handleFormattingKeys(int key) {
        if (Screen.hasControlDown() && !Screen.hasShiftDown() && !Screen.hasAltDown()) {
            return switch (key) {
                case 49 -> Formatting.of(Formatting.Color.BLACK);
                case 50 -> Formatting.of(Formatting.Color.DARK_BLUE);
                case 51 -> Formatting.of(Formatting.Color.DARK_GREEN);
                case 52 -> Formatting.of(Formatting.Color.DARK_AQUA);
                case 53 -> Formatting.of(Formatting.Color.DARK_RED);
                case 54 -> Formatting.of(Formatting.Color.DARK_PURPLE);
                case 55 -> Formatting.of(Formatting.Color.GOLD);
                case 56 -> Formatting.of(Formatting.Color.GRAY);
                case 75 -> Formatting.of(Formatting.Format.OBFUSCATED);
                case 76 -> Formatting.of(Formatting.Format.BOLD);
                case 77 -> Formatting.of(Formatting.Format.STRIKETHROUGH);
                case 78 -> Formatting.of(Formatting.Format.UNDERLINE);
                case 79 -> Formatting.of(Formatting.Format.ITALIC);
                case 82 -> Formatting.EMPTY;
                default -> null;
            };
        }
        if (Screen.hasControlDown() && Screen.hasShiftDown() && !Screen.hasAltDown()) {
            return switch (key) {
                case 49 -> Formatting.of(Formatting.Color.DARK_GRAY);
                case 50 -> Formatting.of(Formatting.Color.BLUE);
                case 51 -> Formatting.of(Formatting.Color.GREEN);
                case 52 -> Formatting.of(Formatting.Color.AQUA);
                case 53 -> Formatting.of(Formatting.Color.RED);
                case 54 -> Formatting.of(Formatting.Color.LIGHT_PURPLE);
                case 55 -> Formatting.of(Formatting.Color.YELLOW);
                case 56 -> Formatting.of(Formatting.Color.WHITE);
                default -> null;
            };
        }
        return null;
    }

    public void applyFormatting(Formatting formatting) {
        if (formatting.format().contains(Formatting.Format.BOLD)) {
            FormattedString string = new FormattedString((Collection<? extends Char>)this.getText().stream().map(c -> new Char(c.character(), c.formatting().copy())).toList());
            List chars = string.subList(this.getSelectionStart(), this.getSelectionEnd());
            chars.replaceAll(c -> c.flipFormatting(formatting));
            if (!this.validator.test(string.toString())) {
                return;
            }
        }
        if (this.isSelecting()) {
            this.getSelectedSpan().replaceAll(c -> c.flipFormatting(formatting));
        } else if (formatting == Formatting.EMPTY) {
            this.getText().replaceAll(c -> c.withFormatting(Formatting.EMPTY));
        }
    }

    public boolean charTyped(char character) {
        return !this.suppressNextCharTyped && StringUtil.isAllowedChatCharacter((char)character) && this.insertTextAtCursor(Character.toString(character));
    }

    public void cut(boolean withFormatting) {
        this.copy(withFormatting);
        this.removeSelectedText();
    }

    public void paste(boolean keepFormatting) {
        try {
            String text = Minecraft.getInstance().keyboardHandler.getClipboard();
            if (!keepFormatting) {
                text = ChatFormatting.stripFormatting((String)text);
            }
            this.insertTextAtCursor(Objects.requireNonNull(text).replaceAll("\\r", ""));
        }
        catch (Exception e) {
            Envelope.LOGGER.error("Text Paste error: ", (Throwable)e);
        }
    }

    public void copy(boolean withFormatting) {
        Minecraft.getInstance().keyboardHandler.setClipboard(this.getSelectedString(withFormatting));
    }

    public void selectAll() {
        this.setSelectionAnchor(0);
        this.setCursorPos(this.length(), true);
    }

    public boolean insertTextAtCursor(String text) {
        if (this.isSelecting()) {
            this.removeSelectedText();
        }
        FormattedString insertedString = FormattedString.parse(text);
        insertedString.replaceAll(c -> {
            if (!c.hasFormatting()) {
                return c.withFormatting(this.getFormattingAtCursor());
            }
            return c;
        });
        FormattedString newString = new FormattedString(this.getText());
        newString.addAll(this.getCursorPos(), insertedString);
        String string = newString.toStringWithoutFormatting();
        if (this.validator.test(string)) {
            this.string = newString;
            this.setCursorPos(this.getCursorPos() + insertedString.length(), false);
            return true;
        }
        return false;
    }

    public void removeFromCursor(int direction, CursorStep step) {
        switch (step.ordinal()) {
            case 0: {
                this.removeCharsFromCursor(direction);
                break;
            }
            case 1: {
                this.removeWordsFromCursor(direction);
            }
        }
    }

    public void removeWordsFromCursor(int direction) {
        int charsCount = StringSplitter.getWordPosition((String)this.getText().toStringWithoutFormatting(), (int)direction, (int)this.cursorPos, (boolean)true);
        this.removeCharsFromCursor(charsCount - this.cursorPos);
    }

    public void removeCharsFromCursor(int direction) {
        String string = this.getText().toStringWithoutFormatting();
        if (!string.isEmpty()) {
            if (this.isSelecting()) {
                this.removeSelectedText();
            } else {
                int cursor = this.getCursorPos();
                int removePos = Util.offsetByCodepoints((String)string, (int)cursor, (int)direction);
                int start = Math.min(removePos, cursor);
                int end = Math.max(removePos, cursor);
                this.getSpan(start, end).clear();
                this.setCursorPos(start, false);
            }
        }
    }

    public void removeSelectedText() {
        if (!this.isSelecting()) {
            return;
        }
        int start = this.getSelectionStart();
        int end = this.getSelectionEnd();
        this.getSpan(start, end).clear();
        this.setCursorPos(start, false);
    }

    protected void resetSelectionIfNeeded(boolean keepSelection) {
        if (!keepSelection) {
            this.setSelectionAnchor(this.getCursorPos());
        }
    }

    protected int clampIndex(int index) {
        return Mth.clamp((int)index, (int)0, (int)this.length());
    }

    public static enum CursorStep {
        CHARACTER,
        WORD;

    }

    public static interface Validator {
        public static Predicate<String> fitInDimensions(Font font, int width, int height) {
            return string -> {
                int n;
                if (string.length() >= 1024) return false;
                int n2 = font.wordWrapHeight(string, width);
                if (string.endsWith("\n")) {
                    Objects.requireNonNull(font);
                    n = 9;
                } else {
                    n = 0;
                }
                if (n2 + n > height) return false;
                return true;
            };
        }
    }
}

