/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.model;

import com.google.common.collect.ImmutableList;
import io.github.mortuusars.envelope.client.util.Minecrft;
import io.github.mortuusars.envelope.util.EasingFunction;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PigeonModel
extends AgeableListModel<Pigeon> {
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart beak;
    private final ModelPart hat;
    private final ModelPart body;
    private final ModelPart backpackStraps;
    private final ModelPart backpackBag;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart tail;
    private final ModelPart leftWing;
    private final ModelPart rightWing;

    public PigeonModel(ModelPart root) {
        super(true, 6.7f, 0.0f, 1.75f, 2.1f, 26.400002f);
        this.root = root;
        this.head = root.getChild("head");
        this.beak = this.head.getChild("beak");
        this.hat = this.head.getChild("hat");
        this.body = root.getChild("body");
        this.backpackStraps = this.body.getChild("backpack_straps");
        this.backpackBag = this.body.getChild("backpack_bag");
        this.leftLeg = root.getChild("left_leg");
        this.rightLeg = root.getChild("right_leg");
        this.tail = root.getChild("tail");
        this.leftWing = root.getChild("left_wing");
        this.rightWing = root.getChild("right_wing");
    }

    public static LayerDefinition createLayerDefinition() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition part = mesh.getRoot();
        PartDefinition head = part.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 14).addBox(-3.0f, -4.0f, -5.0f, 6.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)16.0f, (float)-1.0f));
        PartDefinition beak = head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.01f)).texOffs(0, 16).addBox(0.0f, 0.0f, -2.0f, 0.0f, 1.0f, 1.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)-1.0f, (float)-5.0f));
        PartDefinition hat = head.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(1, 46).addBox(-3.5f, -2.0f, -3.5f, 7.0f, 2.0f, 7.0f, CubeDeformation.NONE).texOffs(0, 55).addBox(-3.5f, 0.0f, -4.5f, 7.0f, 1.0f, 8.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-4.0f, (float)-2.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition body = part.addOrReplaceChild("body", CubeListBuilder.create().texOffs(0, 0).addBox(-4.0f, -8.0f, -4.0f, 8.0f, 6.0f, 8.0f, CubeDeformation.NONE), PartPose.offset((float)0.0f, (float)24.05f, (float)0.0f));
        PartDefinition backpackStraps = body.addOrReplaceChild("backpack_straps", CubeListBuilder.create().texOffs(32, 50).addBox(-4.0f, -3.0f, -4.0f, 8.0f, 6.0f, 8.0f, new CubeDeformation(0.0f, 0.01f, 0.01f)), PartPose.offset((float)0.0f, (float)-5.0f, (float)0.0f));
        PartDefinition backpackBag = body.addOrReplaceChild("backpack_bag", CubeListBuilder.create().texOffs(32, 38).addBox(-5.0f, -3.0f, -3.0f, 10.0f, 6.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)-9.0f, (float)2.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = part.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(9, 26).addBox(0.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, CubeDeformation.NONE).texOffs(6, 28).addBox(-1.0f, 2.0f, -3.0f, 3.0f, 0.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)1.0f, (float)22.0f, (float)1.0f));
        PartDefinition rightLeg = part.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(7, 26).addBox(-1.0f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, CubeDeformation.NONE).texOffs(0, 28).addBox(-2.0f, 2.0f, -3.0f, 3.0f, 0.0f, 3.0f, CubeDeformation.NONE), PartPose.offset((float)-1.0f, (float)22.0f, (float)1.0f));
        PartDefinition tail = part.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(24, 0).addBox(-3.0f, 0.0f, -1.0f, 6.0f, 5.0f, 1.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)0.0f, (float)19.0f, (float)4.0f, (float)0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftWing = part.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(46, 3).mirror().addBox(-1.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, CubeDeformation.NONE).mirror(false), PartPose.offsetAndRotation((float)4.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition rightWing = part.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(32, 3).addBox(0.0f, 0.0f, -3.0f, 1.0f, 4.0f, 6.0f, CubeDeformation.NONE), PartPose.offsetAndRotation((float)-4.0f, (float)17.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        return LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void setupAnim(Pigeon pigeon, float limbSwing, float limbSwingAmount, float bob, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.head.xRot = headPitch * ((float)Math.PI / 180);
        this.head.yRot = netHeadYaw * ((float)Math.PI / 180);
        switch (this.getState(pigeon).ordinal()) {
            case 0: {
                this.leftWing.zRot = -bob;
                this.rightWing.zRot = bob;
                this.leftLeg.xRot = 0.75f * limbSwingAmount;
                this.leftLeg.yRot = -0.15f;
                this.rightLeg.xRot = 0.75f * limbSwingAmount;
                this.rightLeg.yRot = 0.15f;
                float anim = ((float)pigeon.tickCount + Minecrft.get().getTimer().getGameTimeDeltaPartialTick(true)) % 60.0f / 60.0f;
                anim *= 2.0f;
                if (anim > 1.0f) {
                    anim = 2.0f - anim;
                }
                anim = (float)EasingFunction.EASE_IN_OUT_QUAD.ease(anim);
                this.body.xRot = anim * 0.1f;
                this.head.xRot = -anim * 0.05f;
                this.head.z -= 0.75f * anim;
                this.leftWing.xRot += anim * 0.2f;
                this.leftWing.y -= 0.35f * anim;
                this.leftWing.z -= 0.5f * anim;
                this.rightWing.xRot += anim * 0.2f;
                this.rightWing.y -= 0.35f * anim;
                this.rightWing.z -= 0.5f * anim;
                this.tail.xRot += limbSwingAmount * 0.75f + anim * 0.1f;
                this.tail.y -= 0.35f * anim;
                this.tail.z -= 0.5f * anim;
                break;
            }
            case 1: {
                this.leftWing.zRot = -0.3927f;
                this.rightWing.zRot = 0.3927f;
                this.leftLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
                this.rightLeg.xRot = Mth.cos((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
                break;
            }
            case 2: {
                this.body.y += 1.9f;
                this.head.y = this.head.y + (pigeon.isBaby() ? 1.9f : 2.9f);
                this.leftWing.zRot = -0.2f;
                this.rightWing.zRot = 0.2f;
                this.leftWing.y += 2.0f;
                this.rightWing.y += 2.0f;
                this.tail.xRot = 0.75f;
            }
        }
    }

    public State getState(@Nullable Pigeon pigeon) {
        if (pigeon == null) {
            return State.STANDING;
        }
        if (pigeon.isSitting()) {
            return State.SITTING;
        }
        return pigeon.isFlying() ? State.FLYING : State.STANDING;
    }

    @NotNull
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightLeg, (Object)this.leftLeg, (Object)this.rightWing, (Object)this.leftWing, (Object)this.tail);
    }

    public static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

