/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.client.renderer.entity;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.client.model.PigeonModel;
import io.github.mortuusars.envelope.client.renderer.entity.layer.PigeonBackpackLayer;
import io.github.mortuusars.envelope.client.renderer.entity.layer.PigeonHatLayer;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.entity.PigeonVariant;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class PigeonRenderer
extends MobRenderer<Pigeon, PigeonModel> {
    public static final ModelLayerLocation PIGEON_LAYER = new ModelLayerLocation(Envelope.resource("pigeon"), "main");
    public static final ResourceLocation GRAY = Envelope.resource("textures/entity/pigeon/pigeon_gray.png");
    public static final ResourceLocation BROWN = Envelope.resource("textures/entity/pigeon/pigeon_brown.png");
    public static final ResourceLocation WHITE = Envelope.resource("textures/entity/pigeon/pigeon_white.png");
    public static final ResourceLocation PASSENGER = Envelope.resource("textures/entity/pigeon/pigeon_passenger.png");

    public PigeonRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PigeonModel(context.bakeLayer(PIGEON_LAYER)), 0.35f);
        this.addLayer(new PigeonBackpackLayer((RenderLayerParent<Pigeon, PigeonModel>)this, context.getModelSet()));
        this.addLayer(new PigeonHatLayer((RenderLayerParent<Pigeon, PigeonModel>)this, context.getModelSet()));
    }

    @NotNull
    public ResourceLocation getTextureLocation(Pigeon entity) {
        return PigeonRenderer.getVariantTexture(entity.getVariant());
    }

    protected float getBob(Pigeon livingBase, float partialTick) {
        float f = Mth.lerp((float)partialTick, (float)livingBase.oFlap, (float)livingBase.flap);
        float g = Mth.lerp((float)partialTick, (float)livingBase.oFlapSpeed, (float)livingBase.flapSpeed);
        return (Mth.sin((float)f) + 1.0f) * g;
    }

    @NotNull
    public static ResourceLocation getVariantTexture(PigeonVariant variant) {
        return switch (variant) {
            default -> throw new MatchException(null, null);
            case PigeonVariant.GRAY -> GRAY;
            case PigeonVariant.BROWN -> BROWN;
            case PigeonVariant.WHITE -> WHITE;
            case PigeonVariant.PASSENGER -> PASSENGER;
        };
    }
}

