/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.serialization.DynamicOps;
import io.github.mortuusars.envelope.command.EnvelopeDebugCommand;
import io.github.mortuusars.envelope.command.argument.AddressArgument;
import io.github.mortuusars.envelope.command.suggestion.AddressSuggestions;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;

public class EnvelopeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"envelope").requires(stack -> stack.hasPermission(2))).then(Commands.literal((String)"send").then(((RequiredArgumentBuilder)Commands.argument((String)"mail", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(c -> EnvelopeCommand.sendMail((CommandContext<CommandSourceStack>)c, ItemArgument.getItem((CommandContext)c, (String)"mail"), Address.UNKNOWN))).then(Commands.argument((String)"sender", (ArgumentType)CompoundTagArgument.compoundTag()).executes(c -> EnvelopeCommand.sendMail((CommandContext<CommandSourceStack>)c, ItemArgument.getItem((CommandContext)c, (String)"mail"), EnvelopeCommand.parseAddress(CompoundTagArgument.getCompoundTag((CommandContext)c, (String)"sender")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"mailbox").then(((LiteralArgumentBuilder)Commands.literal((String)"list").executes(EnvelopeCommand::listAllMailboxes)).then(Commands.literal((String)"default").executes(EnvelopeCommand::listDefaultMailboxes)))).then(Commands.literal((String)"position").then(Commands.argument((String)"address", (ArgumentType)AddressArgument.block()).suggests((SuggestionProvider)AddressSuggestions.block()).executes(c -> EnvelopeCommand.mailboxPosition((CommandContext<CommandSourceStack>)c, AddressArgument.getBlock((CommandContext<CommandSourceStack>)c, "address"))))))).then(EnvelopeDebugCommand.commands()));
    }

    private static int sendMail(CommandContext<CommandSourceStack> context, ItemInput item, Address sender) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        ItemStack mail = item.createItemStack(1, false);
        Address recipient = Mail.getRecipientOrUnknown(mail);
        if (recipient.equals(Address.UNKNOWN)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Cannot send: recipient is not defined."));
            return 0;
        }
        MailService.of(level).getDeliveryManager().startService(Delivery.draft().deliver(mail).from(sender).to(recipient)).ifPresentOrElse(delivery -> {
            MutableComponent message = Component.literal((String)"Mail sent to ").append((Component)delivery.delivery().getRecipient().format().asRecipient().toComponent());
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> EnvelopeCommand.lambda$sendMail$4((Component)message), true);
        }, error -> ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"Cannot send: ").append((Component)error.getTranslation())));
        return 0;
    }

    private static Address parseAddress(CompoundTag tag) {
        return (Address)Address.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)tag).getOrThrow();
    }

    private static int listAllMailboxes(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Set<Address.Block> addresses = MailService.of(level).getMailboxes().getAllAddresses();
        if (!addresses.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"All mailboxes:"), true);
            for (Address.Block address : addresses) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> EnvelopeCommand.copyableAddressAndPos(address, MailService.of(level).getMailboxes().getPositionOf(address)), true);
            }
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"There are no known mailboxes."), true);
        }
        return 0;
    }

    private static int listDefaultMailboxes(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        Map<Address.Player, Address.Block> defaultAddresses = MailService.of(level).getPlayers().getDefaultAddresses();
        if (!defaultAddresses.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Default addresses:"), true);
            defaultAddresses.forEach((playerAddress, address) -> {
                Optional<BlockPos> position = MailService.of(level).getMailboxes().getPositionOf((Address.Block)address);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)playerAddress.toString()).append(" - ").append((Component)EnvelopeCommand.copyableAddressAndPos(address, position)), true);
            });
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"There are no default mailboxes."), true);
        }
        return 0;
    }

    private static int mailboxPosition(CommandContext<CommandSourceStack> context, Address.Block address) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        if (!MailService.of(level).getMailboxes().exists(address)) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)address.getName().append(" does not exist."));
            return 1;
        }
        MailService.of(level).getMailboxes().getPositionOf(address).ifPresentOrElse(pos -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> EnvelopeCommand.copyableAddressAndPos(address, Optional.of(pos)), true), () -> ((CommandSourceStack)context.getSource()).sendFailure((Component)address.getName().append(" does not have a position associated with it.")));
        return 0;
    }

    private static MutableComponent copyableAddressAndPos(Address address, Optional<BlockPos> pos) {
        String addressId = address.getName().getString();
        String posStr = pos.map(Vec3i::toShortString).orElse("");
        String posToCopy = posStr.replace(",", "");
        return address.getName().withStyle(Style.EMPTY.withColor(-1651816).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy Address").append("\n").append((Component)Component.literal((String)addressId).withStyle(ChatFormatting.GRAY)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, addressId))).append((Component)Component.literal((String)("@[" + posStr + "]")).withStyle(Style.EMPTY.withColor(ChatFormatting.WHITE).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (Object)Component.literal((String)"Copy Position").append("\n").append((Component)Component.literal((String)posToCopy).withStyle(ChatFormatting.GRAY)))).withClickEvent(new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, posToCopy))));
    }

    private static /* synthetic */ Component lambda$sendMail$4(Component message) {
        return message;
    }
}

