/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.mortuusars.envelope.util.bugger.test.BuggerTests;
import io.github.mortuusars.envelope.util.bugger.test.TestResults;
import io.github.mortuusars.envelope.util.bugger.test.cases.DeliveryHandlerTests;
import io.github.mortuusars.envelope.util.bugger.test.cases.RequestedItemTests;
import io.github.mortuusars.envelope.world.delivery.Delivery;
import io.github.mortuusars.envelope.world.delivery.phase.DeliveryPhase;
import io.github.mortuusars.envelope.world.item.component.PackageContents;
import io.github.mortuusars.envelope.world.item.mail.Mail;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.service.MailService;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class EnvelopeDebugCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> commands() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"debug").then(Commands.literal((String)"expire_all_awaiting_payback").executes(EnvelopeDebugCommand::timeoutAllPaybackMail))).then(Commands.literal((String)"run_tests").executes(EnvelopeDebugCommand::runBuggerTests))).then(Commands.literal((String)"test").executes(EnvelopeDebugCommand::test));
    }

    private static int timeoutAllPaybackMail(CommandContext<CommandSourceStack> context) {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        MailService service = MailService.of(level);
        int returnedCount = service.getPaybackDepartment().returnAllAwaitingAsTimedOut();
        if (returnedCount > 0) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Returned " + returnedCount + " mail awaiting payback.")), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.literal((String)"No mail awaiting payback is returned."));
        }
        return 0;
    }

    private static int runBuggerTests(CommandContext<CommandSourceStack> context) {
        TestResults testResults = new BuggerTests().add(new RequestedItemTests(((CommandSourceStack)context.getSource()).getServer())).add(new DeliveryHandlerTests(((CommandSourceStack)context.getSource()).getServer())).run(count -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Running " + count + " bugger tests.")), true));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Bugger tests finished:"), true);
        if (testResults.failed().isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"All tests are passed!").withStyle(ChatFormatting.GREEN), true);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Passed: " + testResults.passed().size() + "\n")), true);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Failed: " + testResults.failed().size() + ":")).withStyle(ChatFormatting.RED), true);
            testResults.failed().forEach(failedTest -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)(" " + failedTest.name() + ": " + failedTest.error())).withStyle(ChatFormatting.RED), true));
        }
        return 0;
    }

    private static int test(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        MailService.of(player.serverLevel()).getDeliveryManager().startService(Delivery.draft().deliver(Mail.createPackage(new PackageContents(List.of(new ItemStack((ItemLike)Items.ACACIA_LOG)))).get()).from(new Address.Block("Blue")).to(new Address.Block("Red")).startAtPhase(DeliveryPhase.DISPATCHING_DELIVERY));
        return 0;
    }
}

