/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.command.argument;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import io.github.mortuusars.envelope.util.result.Error;
import io.github.mortuusars.envelope.world.mail.address.Address;
import io.github.mortuusars.envelope.world.mail.address.AddressValidation;
import java.lang.runtime.SwitchBootstraps;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.Nullable;

public class AddressArgument
implements ArgumentType<Address> {
    @Nullable
    private final Address.Type type;

    protected AddressArgument(@Nullable Address.Type type) {
        this.type = type;
    }

    public static AddressArgument all() {
        return new AddressArgument(null);
    }

    public static AddressArgument block() {
        return new AddressArgument(Address.Type.BLOCK);
    }

    public static AddressArgument player() {
        return new AddressArgument(Address.Type.PLAYER);
    }

    public static AddressArgument entity() {
        return new AddressArgument(Address.Type.ENTITY);
    }

    public static Address.Block getBlock(CommandContext<CommandSourceStack> context, String name) throws CommandSyntaxException {
        Address address = (Address)context.getArgument(name, Address.class);
        if (address instanceof Address.Block) {
            Address.Block block = (Address.Block)address;
            return block;
        }
        MutableComponent message = Component.literal((String)("Address has wrong type: Expected: " + Address.Type.BLOCK.getSerializedName() + ", Got: " + address.type().getSerializedName()));
        throw new SimpleCommandExceptionType((Message)message).create();
    }

    public Address parse(StringReader reader) throws CommandSyntaxException {
        String id = reader.readString();
        Optional<Error> error = AddressValidation.id().test(id).getError();
        if (error.isPresent()) {
            MutableComponent message = Component.literal((String)"Invalid address: ").append((Component)error.get().getTranslation());
            throw new SimpleCommandExceptionType((Message)message).create();
        }
        Address.Type type = this.type;
        int n = 0;
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"BLOCK", "PLAYER", "ENTITY"}, (Address.Type)type, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> new Address.Block(id);
            case 1 -> new Address.Player(id);
            case 2 -> new Address.Entity(id);
            case -1 -> new Address.Block(id);
        };
    }
}

