/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.neoforge.datagen;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.neoforge.datagen.client.ModelsDatagen;
import io.github.mortuusars.envelope.neoforge.datagen.server.BlockTagsDatagen;
import io.github.mortuusars.envelope.neoforge.datagen.server.ItemTagsDatagen;
import io.github.mortuusars.envelope.neoforge.datagen.server.LootTablesDatagen;
import io.github.mortuusars.envelope.neoforge.datagen.server.RecipesDatagen;
import io.github.mortuusars.envelope.neoforge.datagen.server.SealImpressionDatagen;
import io.github.mortuusars.envelope.world.item.component.seal.SealImpression;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="envelope", bus=EventBusSubscriber.Bus.MOD)
public class DataGeneration {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture registries = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new ModelsDatagen(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new RecipesDatagen(output, registries));
        BlockTagsDatagen blockTags = new BlockTagsDatagen(output, registries, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new ItemTagsDatagen(output, registries, blockTags.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)LootTablesDatagen.create(output, registries));
        EnvelopeDatapackRegistries datapackRegistries = new EnvelopeDatapackRegistries(output, registries);
        generator.addProvider(event.includeServer(), (DataProvider)datapackRegistries);
        generator.addProvider(event.includeServer(), (DataProvider)new SealImpressionDatagen(output, datapackRegistries.getRegistryProvider(), "envelope", existingFileHelper));
    }

    public static class EnvelopeDatapackRegistries
    extends DatapackBuiltinEntriesProvider {
        public static final RegistrySetBuilder REGISTRIES = new RegistrySetBuilder().add(Envelope.Registries.SEAL_MATERIAL, SealMaterial::bootstrap).add(Envelope.Registries.SEAL_IMPRESSION, SealImpression::bootstrap);

        public EnvelopeDatapackRegistries(PackOutput output, CompletableFuture<HolderLookup.Provider> provider) {
            super(output, provider, REGISTRIES, Set.of("envelope"));
        }
    }
}

