/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.neoforge.datagen.client;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.EnvelopeClient;
import io.github.mortuusars.envelope.world.block.PaperBoxBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModelsDatagen
extends BlockStateProvider {
    public ModelsDatagen(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "envelope", exFileHelper);
    }

    protected void registerStatesAndModels() {
        Envelope.Blocks.PIGEONHOLES.forEach((id, block) -> {
            this.pigeonhole((ResourceLocation)id, (Block)block.get());
            this.itemModels().simpleBlockItem((Block)block.get());
        });
        this.itemModels().simpleBlockItem((Block)Envelope.Blocks.MAILBOX.get()).transforms().transform(ItemDisplayContext.GUI).rotation(30.0f, -135.0f, 0.0f).scale(0.75f).translation(0.0f, 0.75f, 0.0f).end();
        this.horizontalBlock(Envelope.Blocks.PACKAGE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/package")));
        this.horizontalBlock(Envelope.Blocks.SEALED_PACKAGE.get(), (ModelFile)this.models().getExistingFile(this.modLoc("block/sealed_package")));
        this.getVariantBuilder(Envelope.Blocks.PAPER_BOX.get()).forAllStates(state -> {
            String[] boxes = new String[]{"one", "two", "three", "four"};
            ModelFile.ExistingModelFile model = this.models().getExistingFile(this.modLoc("block/paper_box_" + boxes[(Integer)state.getValue((Property)PaperBoxBlock.BOXES) - 1]));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(state.getValue(PaperBoxBlock.AXIS) == Direction.Axis.X ? 0 : 90).build();
        });
        this.itemModels().basicItem((Item)Envelope.Items.ADDRESS_TAG.get());
        this.itemModels().basicItem((Item)Envelope.Items.SEAL_STAMP.get());
        this.itemModels().basicItem((Item)Envelope.Items.LETTER_AND_QUILL.get()).override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 1.0f).model((ModelFile)this.model(Envelope.resource("letter_and_quill_content"))).end();
        this.letterTatteredUnfoldedContent(Envelope.Items.LETTER.get());
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(Envelope.resource("sealed_letter").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", Envelope.resource("item/letter"))).texture("layer1", Envelope.resource("item/letter_seal_overlay"))).override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 1.0f).model((ModelFile)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(Envelope.resource("sealed_letter_tattered").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", Envelope.resource("item/letter_tattered"))).texture("layer1", Envelope.resource("item/letter_seal_overlay"))).end();
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(Envelope.resource("sealed_package").toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", Envelope.resource("item/package"))).texture("layer1", Envelope.resource("item/package_seal_overlay"));
        this.itemModels().basicItem((Item)Envelope.Items.PAPER_BOX.get());
        this.itemModels().basicItem((Item)Envelope.Items.PACKING_BOX.get());
        this.itemModels().basicItem((Item)Envelope.Items.PACKAGE.get());
        this.itemModels().basicItem((Item)Envelope.Items.PAYBACK_TAG.get());
        this.itemModels().basicItem((Item)Envelope.Items.PAYBACK_PACKING_BOX.get());
        this.itemModels().basicItem((Item)Envelope.Items.PAYBACK_PACKAGE.get());
        this.itemModels().spawnEggItem((Item)Envelope.Items.PIGEON_SPAWN_EGG.get());
    }

    protected ItemModelBuilder letterTatteredUnfoldedContent(Item item) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)item);
        return this.itemModels().basicItem(id).override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 0.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_UNFOLDED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 0.0f).model((ModelFile)this.model(id.withSuffix("_unfolded"))).end().override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 0.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_UNFOLDED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 1.0f).model((ModelFile)this.model(id.withSuffix("_unfolded_content"))).end().override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_UNFOLDED, 0.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 0.0f).model((ModelFile)this.model(id.withSuffix("_tattered"))).end().override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_UNFOLDED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 0.0f).model((ModelFile)this.model(id.withSuffix("_tattered_unfolded"))).end().override().predicate(EnvelopeClient.ItemModelOverrides.LETTER_TATTERED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_UNFOLDED, 1.0f).predicate(EnvelopeClient.ItemModelOverrides.LETTER_CONTENT, 1.0f).model((ModelFile)this.model(id.withSuffix("_tattered_unfolded_content"))).end();
    }

    protected ItemModelBuilder model(ResourceLocation path) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.itemModels().getBuilder(path.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)path.getNamespace(), (String)("item/" + path.getPath())));
    }

    protected void pigeonhole(ResourceLocation id, Block block) {
        String baseName = id.getPath();
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction facing = (Direction)state.getValue((Property)PigeonholeBlock.FACING);
            int waste = (Integer)state.getValue((Property)PigeonholeBlock.WASTE_LEVEL);
            String suffix = waste >= 5 ? "_waste" : "";
            ModelBuilder model = this.models().orientableWithBottom(baseName + suffix, Envelope.resource("block/" + baseName + "_side"), Envelope.resource("block/" + baseName + "_front" + suffix), Envelope.resource("block/" + baseName + "_end"), Envelope.resource("block/" + baseName + "_end"));
            return ConfiguredModel.builder().modelFile((ModelFile)model).rotationY(((int)facing.toYRot() + 180) % 360).build();
        });
    }
}

