/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.neoforge.datagen.server.loot;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.world.block.PaperBoxBlock;
import io.github.mortuusars.envelope.world.block.PigeonholeBlock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyBlockState;
import net.minecraft.world.level.storage.loot.functions.CopyComponentsFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import org.jetbrains.annotations.NotNull;

public class BlockLootTableProvider
extends BlockLootSubProvider {
    public BlockLootTableProvider(HolderLookup.Provider registries) {
        super(Collections.emptySet(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    @NotNull
    protected Iterable<Block> getKnownBlocks() {
        ArrayList<PigeonholeBlock> blocks = new ArrayList<PigeonholeBlock>(Envelope.Blocks.PIGEONHOLES.values().stream().map(Supplier::get).toList());
        blocks.add((PigeonholeBlock)((Block)Envelope.Blocks.MAILBOX.get()));
        blocks.add((PigeonholeBlock)((Object)Envelope.Blocks.PAPER_BOX.get()));
        return blocks;
    }

    public void generate() {
        Envelope.Blocks.PIGEONHOLES.forEach((id, block) -> this.add((Block)block.get(), this::createPigeonholeDrop));
        this.dropSelf((Block)Envelope.Blocks.MAILBOX.get());
        this.add(Envelope.Blocks.PAPER_BOX.get(), this::createPaperBoxDrops);
    }

    protected LootTable.Builder createPaperBoxDrops(Block paperBoxBlock) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)paperBoxBlock, LootItem.lootTableItem((ItemLike)paperBoxBlock).apply(List.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), count -> SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)count.intValue())).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)paperBoxBlock).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)PaperBoxBlock.BOXES, count.intValue())))))));
    }

    protected LootTable.Builder createPigeonholeDrop(Block block) {
        return LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)block).when(this.hasSilkTouch())).apply((LootItemFunction.Builder)CopyComponentsFunction.copyComponents((CopyComponentsFunction.Source)CopyComponentsFunction.Source.BLOCK_ENTITY).include(Envelope.DataComponents.PIGEONS)).apply((LootItemFunction.Builder)CopyBlockState.copyState((Block)block).copy((Property)PigeonholeBlock.WASTE_LEVEL)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)block))));
    }
}

