/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.neoforge.event;

import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.EnvelopeClient;
import io.github.mortuusars.envelope.client.gui.screen.MailboxScreen;
import io.github.mortuusars.envelope.client.gui.screen.PackingScreen;
import io.github.mortuusars.envelope.client.gui.screen.PaybackPackingScreen;
import io.github.mortuusars.envelope.client.gui.screen.PaybackTagScreen;
import io.github.mortuusars.envelope.client.model.PigeonModel;
import io.github.mortuusars.envelope.client.renderer.entity.PigeonRenderer;
import io.github.mortuusars.envelope.client.renderer.entity.layer.PigeonBackpackLayer;
import io.github.mortuusars.envelope.client.renderer.entity.layer.PigeonHatLayer;
import io.github.mortuusars.envelope.world.item.Sealable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

public class NeoForgeClientEvents {

    public static class GameBus {
    }

    @EventBusSubscriber(modid="envelope", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        public static void clientSetup(FMLClientSetupEvent event) {
            event.enqueueWork(EnvelopeClient::init);
        }

        @SubscribeEvent
        public static void registerMenuScreens(RegisterMenuScreensEvent event) {
            event.register(Envelope.MenuTypes.PIGEONHOLE.get(), MailboxScreen::new);
            event.register(Envelope.MenuTypes.PACKAGE.get(), PackingScreen::new);
            event.register(Envelope.MenuTypes.PAYBACK_PACKAGE.get(), PaybackPackingScreen::new);
            event.register(Envelope.MenuTypes.PAYBACK_TAG.get(), PaybackTagScreen::new);
        }

        @SubscribeEvent
        public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerEntityRenderer(Envelope.EntityTypes.PIGEON.get(), PigeonRenderer::new);
        }

        @SubscribeEvent
        public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
            event.registerLayerDefinition(PigeonRenderer.PIGEON_LAYER, PigeonModel::createLayerDefinition);
            event.registerLayerDefinition(PigeonBackpackLayer.PIGEON_BACKPACK, PigeonModel::createLayerDefinition);
            event.registerLayerDefinition(PigeonHatLayer.PIGEON_HAT, PigeonModel::createLayerDefinition);
        }

        @SubscribeEvent
        public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
            event.register(Sealable::getSealOverlayColor, new ItemLike[]{(ItemLike)Envelope.Items.SEALED_LETTER.get()});
            event.register(Sealable::getSealOverlayColor, new ItemLike[]{(ItemLike)Envelope.Items.SEALED_PACKAGE.get()});
        }

        @SubscribeEvent
        public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
            event.register(Sealable::getSealOverlayColor, new Block[]{Envelope.Blocks.SEALED_PACKAGE.get()});
        }
    }
}

