/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.envelope.neoforge.event;

import com.mojang.brigadier.CommandDispatcher;
import io.github.mortuusars.envelope.Envelope;
import io.github.mortuusars.envelope.command.EnvelopeCommand;
import io.github.mortuusars.envelope.event.CommonEvents;
import io.github.mortuusars.envelope.event.ServerEvents;
import io.github.mortuusars.envelope.neoforge.RegisterImpl;
import io.github.mortuusars.envelope.network.neoforge.PacketsImpl;
import io.github.mortuusars.envelope.network.packet.C2SPackets;
import io.github.mortuusars.envelope.network.packet.CommonPackets;
import io.github.mortuusars.envelope.network.packet.S2CPackets;
import io.github.mortuusars.envelope.world.entity.Pigeon;
import io.github.mortuusars.envelope.world.item.component.seal.SealImpression;
import io.github.mortuusars.envelope.world.item.component.seal.SealMaterial;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.EntityLeaveLevelEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DataPackRegistryEvent;

public class NeoForgeCommonEvents {

    @EventBusSubscriber(modid="envelope", bus=EventBusSubscriber.Bus.GAME)
    public static class GameBus {
        @SubscribeEvent
        public static void registerCommands(RegisterCommandsEvent event) {
            EnvelopeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
        }

        @SubscribeEvent
        public static void serverStarted(ServerStartedEvent event) {
            ServerEvents.serverStarted(event.getServer());
        }

        @SubscribeEvent
        public static void serverTick(ServerTickEvent.Post tick) {
            ServerEvents.serverTick(tick.getServer());
        }

        @SubscribeEvent
        public static void levelTick(LevelTickEvent.Post event) {
            CommonEvents.levelTick(event.getLevel());
        }

        @SubscribeEvent
        public static void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            Player player = event.getEntity();
            if (player instanceof ServerPlayer) {
                ServerPlayer player2 = (ServerPlayer)player;
                ServerEvents.playerLogin(player2);
            }
        }

        @SubscribeEvent
        public static void entityLeaveLevel(EntityLeaveLevelEvent event) {
            CommonEvents.entityLeaveLevel(event.getLevel(), event.getEntity());
        }
    }

    @EventBusSubscriber(modid="envelope", bus=EventBusSubscriber.Bus.MOD)
    public static class ModBus {
        @SubscribeEvent
        public static void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> {
                CommonEvents.commonSetup();
                for (Map.Entry<ResourceLocation, StatFormatter> entry : RegisterImpl.STATS.entrySet()) {
                    Stats.CUSTOM.get((Object)entry.getKey(), entry.getValue());
                }
            });
        }

        @SubscribeEvent
        public static void registerPackets(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar("1");
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : S2CPackets.getDefinitions()) {
                registrar.playToClient(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : C2SPackets.getDefinitions()) {
                registrar.playToServer(definition.type(), definition.codec(), PacketsImpl::handle);
            }
            for (CustomPacketPayload.TypeAndCodec<? extends FriendlyByteBuf, ? extends CustomPacketPayload> definition : CommonPackets.getDefinitions()) {
                registrar.playBidirectional(definition.type(), definition.codec(), PacketsImpl::handle);
            }
        }

        @SubscribeEvent
        public static void buildCreativeTabs(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey().equals(CreativeModeTabs.FUNCTIONAL_BLOCKS)) {
                Envelope.Items.PIGEONHOLES.forEach(item -> event.accept((ItemLike)item.get()));
                event.accept((ItemLike)Envelope.Items.PAPER_BOX.get());
                event.accept((ItemLike)Envelope.Items.MAILBOX.get());
            }
            if (event.getTabKey().equals(CreativeModeTabs.TOOLS_AND_UTILITIES)) {
                event.accept((ItemLike)Envelope.Items.LETTER_AND_QUILL.get());
                event.accept((ItemLike)Envelope.Items.LETTER.get());
                event.accept((ItemLike)Envelope.Items.SEALED_LETTER.get());
                event.accept((ItemLike)Envelope.Items.PACKING_BOX.get());
                event.accept((ItemLike)Envelope.Items.PACKAGE.get());
                event.accept((ItemLike)Envelope.Items.SEALED_PACKAGE.get());
                event.accept((ItemLike)Envelope.Items.ADDRESS_TAG.get());
                event.accept((ItemLike)Envelope.Items.PAYBACK_TAG.get());
                event.accept((ItemLike)Envelope.Items.SEAL_STAMP.get());
            }
            if (event.getTabKey().equals(CreativeModeTabs.SPAWN_EGGS)) {
                event.accept((ItemLike)Envelope.Items.PIGEON_SPAWN_EGG.get());
            }
        }

        @SubscribeEvent
        public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
            event.put(Envelope.EntityTypes.PIGEON.get(), Pigeon.createAttributes().build());
        }

        @SubscribeEvent
        public static void registerSpawnPlacements(RegisterSpawnPlacementsEvent event) {
            event.register(Envelope.EntityTypes.PIGEON.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING, Pigeon::checkSpawnRules, RegisterSpawnPlacementsEvent.Operation.REPLACE);
        }

        @SubscribeEvent
        public static void addDatapackRegistries(DataPackRegistryEvent.NewRegistry event) {
            event.dataPackRegistry(Envelope.Registries.SEAL_MATERIAL, SealMaterial.DIRECT_CODEC, SealMaterial.DIRECT_CODEC);
            event.dataPackRegistry(Envelope.Registries.SEAL_IMPRESSION, SealImpression.DIRECT_CODEC, SealImpression.DIRECT_CODEC);
        }
    }
}

